/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.destroystokyo.paper.event.entity.PhantomPreSpawnEvent;
import io.papermc.paper.util.MCUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PhantomSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        if (!spawnMonsters) {
            return 0;
        }
        if (!world.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return 0;
        }
        if (world.paperConfig().entities.behavior.phantomsSpawnAttemptMaxSeconds <= 0) {
            return 0;
        }
        RandomSource randomsource = world.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        int spawnAttemptMinSeconds = world.paperConfig().entities.behavior.phantomsSpawnAttemptMinSeconds;
        int spawnAttemptMaxSeconds = world.paperConfig().entities.behavior.phantomsSpawnAttemptMaxSeconds;
        this.nextTick += (spawnAttemptMinSeconds + randomsource.nextInt(spawnAttemptMaxSeconds - spawnAttemptMinSeconds + 1)) * 20;
        if (world.getSkyDarken() < 5 && world.dimensionType().hasSkyLight()) {
            return 0;
        }
        int i = 0;
        block0: for (ServerPlayer entityplayer : world.players()) {
            FluidState fluid;
            BlockState iblockdata;
            BlockPos blockposition1;
            DifficultyInstance difficultydamagescaler;
            if (entityplayer.isSpectator() || world.paperConfig().entities.behavior.phantomsDoNotSpawnOnCreativePlayers && entityplayer.isCreative()) continue;
            BlockPos blockposition = entityplayer.blockPosition();
            if (world.dimensionType().hasSkyLight() && (blockposition.getY() < world.getSeaLevel() || !world.canSeeSky(blockposition)) || !(difficultydamagescaler = world.getCurrentDifficultyAt(blockposition)).isHarderThan(randomsource.nextFloat() * 3.0f)) continue;
            ServerStatsCounter serverstatisticmanager = entityplayer.getStats();
            int j = Mth.clamp(serverstatisticmanager.getValue(Stats.CUSTOM.get(Stats.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            boolean flag2 = true;
            if (randomsource.nextInt(j) < world.paperConfig().entities.behavior.playerInsomniaStartTicks || !NaturalSpawner.isValidEmptySpawnBlock(world, blockposition1 = blockposition.above(20 + randomsource.nextInt(15)).east(-10 + randomsource.nextInt(21)).south(-10 + randomsource.nextInt(21)), iblockdata = world.getBlockState(blockposition1), fluid = world.getFluidState(blockposition1), EntityType.PHANTOM)) continue;
            SpawnGroupData groupdataentity = null;
            int k = 1 + randomsource.nextInt(difficultydamagescaler.getDifficulty().getId() + 1);
            for (int l = 0; l < k; ++l) {
                PhantomPreSpawnEvent event = new PhantomPreSpawnEvent(MCUtil.toLocation(world, blockposition1), (Entity)entityplayer.getBukkitEntity(), CreatureSpawnEvent.SpawnReason.NATURAL);
                if (!event.callEvent()) {
                    if (!event.shouldAbortSpawn()) continue;
                    continue block0;
                }
                Phantom entityphantom = EntityType.PHANTOM.create(world);
                if (entityphantom == null) continue;
                entityphantom.setSpawningEntity(entityplayer.getUUID());
                entityphantom.moveTo(blockposition1, 0.0f, 0.0f);
                groupdataentity = entityphantom.finalizeSpawn(world, difficultydamagescaler, MobSpawnType.NATURAL, groupdataentity);
                world.addFreshEntityWithPassengers(entityphantom, CreatureSpawnEvent.SpawnReason.NATURAL);
                ++i;
            }
        }
        return i;
    }
}

