/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class DripstoneClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<DripstoneClusterConfiguration> context) {
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        DripstoneClusterConfiguration dripstoneClusterConfiguration = context.config();
        RandomSource randomSource = context.random();
        if (!DripstoneUtils.isEmptyOrWater(worldGenLevel, blockPos)) {
            return false;
        }
        int i = dripstoneClusterConfiguration.height.sample(randomSource);
        float f = dripstoneClusterConfiguration.wetness.sample(randomSource);
        float g = dripstoneClusterConfiguration.density.sample(randomSource);
        int j = dripstoneClusterConfiguration.radius.sample(randomSource);
        int k = dripstoneClusterConfiguration.radius.sample(randomSource);
        for (int l = -j; l <= j; ++l) {
            for (int m = -k; m <= k; ++m) {
                double d = this.getChanceOfStalagmiteOrStalactite(j, k, l, m, dripstoneClusterConfiguration);
                BlockPos blockPos2 = blockPos.offset(l, 0, m);
                this.placeColumn(worldGenLevel, randomSource, blockPos2, l, m, f, d, i, g, dripstoneClusterConfiguration);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel world, RandomSource random, BlockPos pos, int localX, int localZ, float wetness, double dripstoneChance, int height, float density, DripstoneClusterConfiguration config) {
        boolean bl4;
        int ab;
        int aa;
        int r;
        boolean bl3;
        int n;
        boolean bl2;
        Column column2;
        boolean bl;
        Optional<Column> optional = Column.scan(world, pos, config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isNeitherEmptyNorWater);
        if (optional.isEmpty()) {
            return;
        }
        OptionalInt optionalInt = optional.get().getCeiling();
        OptionalInt optionalInt2 = optional.get().getFloor();
        if (optionalInt.isEmpty() && optionalInt2.isEmpty()) {
            return;
        }
        boolean bl5 = bl = random.nextFloat() < wetness;
        if (bl && optionalInt2.isPresent() && this.canPlacePool(world, pos.atY(optionalInt2.getAsInt()))) {
            int i = optionalInt2.getAsInt();
            Column column = optional.get().withFloor(OptionalInt.of(i - 1));
            world.setBlock(pos.atY(i), Blocks.WATER.defaultBlockState(), 2);
        } else {
            column2 = optional.get();
        }
        OptionalInt optionalInt3 = column2.getFloor();
        boolean bl6 = bl2 = random.nextDouble() < dripstoneChance;
        if (optionalInt.isPresent() && bl2 && !this.isLava(world, pos.atY(optionalInt.getAsInt()))) {
            int l;
            int j = config.dripstoneBlockLayerThickness.sample(random);
            this.replaceBlocksWithDripstoneBlocks(world, pos.atY(optionalInt.getAsInt()), j, Direction.UP);
            if (optionalInt3.isPresent()) {
                int k = Math.min(height, optionalInt.getAsInt() - optionalInt3.getAsInt());
            } else {
                l = height;
            }
            int m = this.getDripstoneHeight(random, localX, localZ, density, l, config);
        } else {
            n = 0;
        }
        boolean bl7 = bl3 = random.nextDouble() < dripstoneChance;
        if (optionalInt3.isPresent() && bl3 && !this.isLava(world, pos.atY(optionalInt3.getAsInt()))) {
            int o = config.dripstoneBlockLayerThickness.sample(random);
            this.replaceBlocksWithDripstoneBlocks(world, pos.atY(optionalInt3.getAsInt()), o, Direction.DOWN);
            if (optionalInt.isPresent()) {
                int p = Math.max(0, n + Mth.randomBetweenInclusive(random, -config.maxStalagmiteStalactiteHeightDiff, config.maxStalagmiteStalactiteHeightDiff));
            } else {
                int q = this.getDripstoneHeight(random, localX, localZ, density, height, config);
            }
        } else {
            r = 0;
        }
        if (optionalInt.isPresent() && optionalInt3.isPresent() && optionalInt.getAsInt() - n <= optionalInt3.getAsInt() + r) {
            int s = optionalInt3.getAsInt();
            int t = optionalInt.getAsInt();
            int u = Math.max(t - n, s + 1);
            int v = Math.min(s + r, t - 1);
            int w = Mth.randomBetweenInclusive(random, u, v + 1);
            int x = w - 1;
            int y = t - w;
            int z = x - s;
        } else {
            aa = n;
            ab = r;
        }
        boolean bl8 = bl4 = random.nextBoolean() && aa > 0 && ab > 0 && column2.getHeight().isPresent() && aa + ab == column2.getHeight().getAsInt();
        if (optionalInt.isPresent()) {
            DripstoneUtils.growPointedDripstone(world, pos.atY(optionalInt.getAsInt() - 1), Direction.DOWN, aa, bl4);
        }
        if (optionalInt3.isPresent()) {
            DripstoneUtils.growPointedDripstone(world, pos.atY(optionalInt3.getAsInt() + 1), Direction.UP, ab, bl4);
        }
    }

    private boolean isLava(LevelReader world, BlockPos pos) {
        return world.getBlockState(pos).is(Blocks.LAVA);
    }

    private int getDripstoneHeight(RandomSource random, int localX, int localZ, float density, int height, DripstoneClusterConfiguration config) {
        if (random.nextFloat() > density) {
            return 0;
        }
        int i = Math.abs(localX) + Math.abs(localZ);
        float f = (float)Mth.clampedMap((double)i, 0.0, (double)config.maxDistanceFromCenterAffectingHeightBias, (double)height / 2.0, 0.0);
        return (int)DripstoneClusterFeature.randomBetweenBiased(random, 0.0f, height, f, config.heightDeviation);
    }

    private boolean canPlacePool(WorldGenLevel world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(Blocks.WATER) || blockState.is(Blocks.DRIPSTONE_BLOCK) || blockState.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        if (world.getBlockState(pos.above()).getFluidState().is(FluidTags.WATER)) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (this.canBeAdjacentToWater(world, pos.relative(direction))) continue;
            return false;
        }
        return this.canBeAdjacentToWater(world, pos.below());
    }

    private boolean canBeAdjacentToWater(LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.is(BlockTags.BASE_STONE_OVERWORLD) || blockState.getFluidState().is(FluidTags.WATER);
    }

    private void replaceBlocksWithDripstoneBlocks(WorldGenLevel world, BlockPos pos, int height, Direction direction) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 0; i < height; ++i) {
            if (!DripstoneUtils.placeDripstoneBlockIfPossible(world, mutableBlockPos)) {
                return;
            }
            mutableBlockPos.move(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int radiusX, int radiusZ, int localX, int localZ, DripstoneClusterConfiguration config) {
        int i = radiusX - Math.abs(localX);
        int j = radiusZ - Math.abs(localZ);
        int k = Math.min(i, j);
        return Mth.clampedMap(k, 0.0f, config.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn, config.chanceOfDripstoneColumnAtMaxDistanceFromCenter, 1.0f);
    }

    private static float randomBetweenBiased(RandomSource random, float min, float max, float mean, float deviation) {
        return ClampedNormalFloat.sample(random, mean, deviation, min, max);
    }
}

