/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.WeepingVinesFeature;

public class HugeFungusFeature
extends Feature<HugeFungusConfiguration> {
    private static final float HUGE_PROBABILITY = 0.06f;

    public HugeFungusFeature(Codec<HugeFungusConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<HugeFungusConfiguration> context) {
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        RandomSource randomSource = context.random();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        HugeFungusConfiguration hugeFungusConfiguration = context.config();
        Block block = hugeFungusConfiguration.validBaseState.getBlock();
        BlockPos blockPos2 = null;
        BlockState blockState = worldGenLevel.getBlockState(blockPos.below());
        if (blockState.is(block)) {
            blockPos2 = blockPos;
        }
        if (blockPos2 == null) {
            return false;
        }
        int i = Mth.nextInt(randomSource, 4, 13);
        if (randomSource.nextInt(12) == 0) {
            i *= 2;
        }
        if (!hugeFungusConfiguration.planted) {
            int j = chunkGenerator.getGenDepth();
            if (blockPos2.getY() + i + 1 >= j) {
                return false;
            }
        }
        boolean bl = !hugeFungusConfiguration.planted && randomSource.nextFloat() < 0.06f;
        worldGenLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 4);
        this.placeStem(worldGenLevel, randomSource, hugeFungusConfiguration, blockPos2, i, bl);
        this.placeHat(worldGenLevel, randomSource, hugeFungusConfiguration, blockPos2, i, bl);
        return true;
    }

    private static boolean isReplaceable(WorldGenLevel world, BlockPos pos, HugeFungusConfiguration config, boolean checkConfig) {
        if (world.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::canBeReplaced)) {
            return true;
        }
        if (checkConfig) {
            return config.replaceableBlocks.test(world, pos);
        }
        return false;
    }

    private void placeStem(WorldGenLevel world, RandomSource random, HugeFungusConfiguration config, BlockPos pos, int stemHeight, boolean thickStem) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockState blockState = config.stemState;
        int i = thickStem ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean bl = thickStem && Mth.abs(j) == i && Mth.abs(k) == i;
                for (int l = 0; l < stemHeight; ++l) {
                    mutableBlockPos.setWithOffset(pos, j, l, k);
                    if (!HugeFungusFeature.isReplaceable(world, mutableBlockPos, config, true)) continue;
                    if (config.planted) {
                        if (!world.getBlockState((BlockPos)mutableBlockPos.below()).isAir()) {
                            world.destroyBlock(mutableBlockPos, true);
                        }
                        world.setBlock(mutableBlockPos, blockState, 3);
                        continue;
                    }
                    if (bl) {
                        if (!(random.nextFloat() < 0.1f)) continue;
                        this.setBlock(world, mutableBlockPos, blockState);
                        continue;
                    }
                    this.setBlock(world, mutableBlockPos, blockState);
                }
            }
        }
    }

    private void placeHat(WorldGenLevel world, RandomSource random, HugeFungusConfiguration config, BlockPos pos, int hatHeight, boolean thickStem) {
        int j;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        boolean bl = config.hatState.is(Blocks.NETHER_WART_BLOCK);
        int i = Math.min(random.nextInt(1 + hatHeight / 3) + 5, hatHeight);
        for (int k = j = hatHeight - i; k <= hatHeight; ++k) {
            int l;
            int n = l = k < hatHeight - random.nextInt(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (thickStem) {
                ++l;
            }
            for (int m = -l; m <= l; ++m) {
                for (int n2 = -l; n2 <= l; ++n2) {
                    boolean bl2 = m == -l || m == l;
                    boolean bl3 = n2 == -l || n2 == l;
                    boolean bl4 = !bl2 && !bl3 && k != hatHeight;
                    boolean bl5 = bl2 && bl3;
                    boolean bl6 = k < j + 3;
                    mutableBlockPos.setWithOffset(pos, m, k, n2);
                    if (!HugeFungusFeature.isReplaceable(world, mutableBlockPos, config, false)) continue;
                    if (config.planted && !world.getBlockState((BlockPos)mutableBlockPos.below()).isAir()) {
                        world.destroyBlock(mutableBlockPos, true);
                    }
                    if (bl6) {
                        if (bl4) continue;
                        this.placeHatDropBlock(world, random, mutableBlockPos, config.hatState, bl);
                        continue;
                    }
                    if (bl4) {
                        this.placeHatBlock(world, random, config, mutableBlockPos, 0.1f, 0.2f, bl ? 0.1f : 0.0f);
                        continue;
                    }
                    if (bl5) {
                        this.placeHatBlock(world, random, config, mutableBlockPos, 0.01f, 0.7f, bl ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock(world, random, config, mutableBlockPos, 5.0E-4f, 0.98f, bl ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(LevelAccessor world, RandomSource random, HugeFungusConfiguration config, BlockPos.MutableBlockPos pos, float decorationChance, float generationChance, float vineChance) {
        if (random.nextFloat() < decorationChance) {
            this.setBlock(world, pos, config.decorState);
        } else if (random.nextFloat() < generationChance) {
            this.setBlock(world, pos, config.hatState);
            if (random.nextFloat() < vineChance) {
                HugeFungusFeature.tryPlaceWeepingVines(pos, world, random);
            }
        }
    }

    private void placeHatDropBlock(LevelAccessor world, RandomSource random, BlockPos pos, BlockState state, boolean vines) {
        if (world.getBlockState(pos.below()).is(state.getBlock())) {
            this.setBlock(world, pos, state);
        } else if ((double)random.nextFloat() < 0.15) {
            this.setBlock(world, pos, state);
            if (vines && random.nextInt(11) == 0) {
                HugeFungusFeature.tryPlaceWeepingVines(pos, world, random);
            }
        }
    }

    private static void tryPlaceWeepingVines(BlockPos pos, LevelAccessor world, RandomSource random) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable().move(Direction.DOWN);
        if (!world.isEmptyBlock(mutableBlockPos)) {
            return;
        }
        int i = Mth.nextInt(random, 1, 5);
        if (random.nextInt(7) == 0) {
            i *= 2;
        }
        int j = 23;
        int k = 25;
        WeepingVinesFeature.placeWeepingVinesColumn(world, random, mutableBlockPos, i, 23, 25);
    }
}

