/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class OreFeature
extends Feature<OreConfiguration> {
    public OreFeature(Codec<OreConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<OreConfiguration> context) {
        RandomSource randomSource = context.random();
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        OreConfiguration oreConfiguration = context.config();
        float f = randomSource.nextFloat() * (float)Math.PI;
        float g = (float)oreConfiguration.size / 8.0f;
        int i = Mth.ceil(((float)oreConfiguration.size / 16.0f * 2.0f + 1.0f) / 2.0f);
        double d = (double)blockPos.getX() + Math.sin(f) * (double)g;
        double e = (double)blockPos.getX() - Math.sin(f) * (double)g;
        double h = (double)blockPos.getZ() + Math.cos(f) * (double)g;
        double j = (double)blockPos.getZ() - Math.cos(f) * (double)g;
        int k = 2;
        double l = blockPos.getY() + randomSource.nextInt(3) - 2;
        double m = blockPos.getY() + randomSource.nextInt(3) - 2;
        int n = blockPos.getX() - Mth.ceil(g) - i;
        int o = blockPos.getY() - 2 - i;
        int p = blockPos.getZ() - Mth.ceil(g) - i;
        int q = 2 * (Mth.ceil(g) + i);
        int r = 2 * (2 + i);
        for (int s = n; s <= n + q; ++s) {
            for (int t = p; t <= p + q; ++t) {
                if (o > worldGenLevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, s, t)) continue;
                return this.doPlace(worldGenLevel, randomSource, oreConfiguration, d, e, h, j, l, m, n, o, p, q, r);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel world, RandomSource random, OreConfiguration config, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int horizontalSize, int verticalSize) {
        int i = 0;
        BitSet bitSet = new BitSet(horizontalSize * verticalSize * horizontalSize);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int j = config.size;
        double[] ds = new double[j * 4];
        for (int k = 0; k < j; ++k) {
            float f = (float)k / (float)j;
            double d = Mth.lerp((double)f, startX, endX);
            double e = Mth.lerp((double)f, startY, endY);
            double g = Mth.lerp((double)f, startZ, endZ);
            double h = random.nextDouble() * (double)j / 16.0;
            double l = ((double)(Mth.sin((float)Math.PI * f) + 1.0f) * h + 1.0) / 2.0;
            ds[k * 4 + 0] = d;
            ds[k * 4 + 1] = e;
            ds[k * 4 + 2] = g;
            ds[k * 4 + 3] = l;
        }
        for (int m = 0; m < j - 1; ++m) {
            if (ds[m * 4 + 3] <= 0.0) continue;
            for (int n = m + 1; n < j; ++n) {
                double q;
                double p;
                double o;
                double r;
                if (ds[n * 4 + 3] <= 0.0 || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4 + 0] - ds[n * 4 + 0]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess(world);){
            for (int s = 0; s < j; ++s) {
                double t = ds[s * 4 + 3];
                if (t < 0.0) continue;
                double u = ds[s * 4 + 0];
                double v = ds[s * 4 + 1];
                double w = ds[s * 4 + 2];
                int aa = Math.max(Mth.floor(u - t), x);
                int ab = Math.max(Mth.floor(v - t), y);
                int ac = Math.max(Mth.floor(w - t), z);
                int ad = Math.max(Mth.floor(u + t), aa);
                int ae = Math.max(Mth.floor(v + t), ab);
                int af = Math.max(Mth.floor(w + t), ac);
                for (int ag = aa; ag <= ad; ++ag) {
                    double ah = ((double)ag + 0.5 - u) / t;
                    if (!(ah * ah < 1.0)) continue;
                    for (int ai = ab; ai <= ae; ++ai) {
                        double aj = ((double)ai + 0.5 - v) / t;
                        if (!(ah * ah + aj * aj < 1.0)) continue;
                        block11: for (int ak = ac; ak <= af; ++ak) {
                            LevelChunkSection levelChunkSection;
                            int am;
                            double al = ((double)ak + 0.5 - w) / t;
                            if (!(ah * ah + aj * aj + al * al < 1.0) || world.isOutsideBuildHeight(ai) || bitSet.get(am = ag - x + (ai - y) * horizontalSize + (ak - z) * horizontalSize * verticalSize)) continue;
                            bitSet.set(am);
                            mutableBlockPos.set(ag, ai, ak);
                            if (!world.ensureCanWrite(mutableBlockPos) || (levelChunkSection = bulkSectionAccess.getSection(mutableBlockPos)) == null) continue;
                            int an = SectionPos.sectionRelative(ag);
                            int ao = SectionPos.sectionRelative(ai);
                            int ap = SectionPos.sectionRelative(ak);
                            BlockState blockState = levelChunkSection.getBlockState(an, ao, ap);
                            for (OreConfiguration.TargetBlockState targetBlockState : config.targetStates) {
                                if (!OreFeature.canPlaceOre(blockState, bulkSectionAccess::getBlockState, random, config, targetBlockState, mutableBlockPos)) continue;
                                levelChunkSection.setBlockState(an, ao, ap, targetBlockState.state, false);
                                ++i;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    public static boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> posToState, RandomSource random, OreConfiguration config, OreConfiguration.TargetBlockState target, BlockPos.MutableBlockPos pos) {
        if (!target.target.test(state, random)) {
            return false;
        }
        if (OreFeature.shouldSkipAirCheck(random, config.discardChanceOnAirExposure)) {
            return true;
        }
        return !OreFeature.isAdjacentToAir(posToState, pos);
    }

    protected static boolean shouldSkipAirCheck(RandomSource random, float chance) {
        if (chance <= 0.0f) {
            return true;
        }
        if (chance >= 1.0f) {
            return false;
        }
        return random.nextFloat() >= chance;
    }
}

