/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeFeature
extends Feature<TreeConfiguration> {
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public TreeFeature(Codec<TreeConfiguration> configCodec) {
        super(configCodec);
    }

    private static boolean isVine(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.is(Blocks.VINE));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.LEAVES));
    }

    private static void setBlockKnownShape(LevelWriter world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES));
    }

    private boolean doPlace(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> rootPlacerReplacer, BiConsumer<BlockPos, BlockState> trunkPlacerReplacer, FoliagePlacer.FoliageSetter blockPlacer, TreeConfiguration config) {
        int i = config.trunkPlacer.getTreeHeight(random);
        int j = config.foliagePlacer.foliageHeight(random, i, config);
        int k = i - j;
        int l = config.foliagePlacer.foliageRadius(random, k);
        BlockPos blockPos = config.rootPlacer.map(rootPlacer -> rootPlacer.getTrunkOrigin(pos, random)).orElse(pos);
        int m = Math.min(pos.getY(), blockPos.getY());
        int n = Math.max(pos.getY(), blockPos.getY()) + i + 1;
        if (m < world.getMinBuildHeight() + 1 || n > world.getMaxBuildHeight()) {
            return false;
        }
        OptionalInt optionalInt = config.minimumSize.minClippedHeight();
        int o = this.getMaxFreeTreeHeight(world, i, blockPos, config);
        if (o < i && (optionalInt.isEmpty() || o < optionalInt.getAsInt())) {
            return false;
        }
        if (config.rootPlacer.isPresent() && !config.rootPlacer.get().placeRoots(world, rootPlacerReplacer, random, pos, blockPos, config)) {
            return false;
        }
        List<FoliagePlacer.FoliageAttachment> list = config.trunkPlacer.placeTrunk(world, trunkPlacerReplacer, random, o, blockPos, config);
        list.forEach(node -> treeConfiguration.foliagePlacer.createFoliage(world, blockPlacer, random, config, o, (FoliagePlacer.FoliageAttachment)node, j, l));
        return true;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader world, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int j = config.minimumSize.getSizeAtHeight(height, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutableBlockPos.setWithOffset(pos, k, i, l);
                    if (config.trunkPlacer.isFree(world, mutableBlockPos) && (config.ignoreVines || !TreeFeature.isVine(world, mutableBlockPos))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    @Override
    @Override
    protected void setBlock(LevelWriter world, BlockPos pos, BlockState state) {
        TreeFeature.setBlockKnownShape(world, pos, state);
    }

    @Override
    @Override
    public final boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        final WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        BlockPos blockPos = context.origin();
        TreeConfiguration treeConfiguration = context.config();
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        final HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biConsumer = (pos, state) -> {
            set.add(pos.immutable());
            worldGenLevel.setBlock((BlockPos)pos, (BlockState)state, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer2 = (pos, state) -> {
            set2.add(pos.immutable());
            worldGenLevel.setBlock((BlockPos)pos, (BlockState)state, 19);
        };
        FoliagePlacer.FoliageSetter foliageSetter = new FoliagePlacer.FoliageSetter(){

            @Override
            @Override
            public void set(BlockPos pos, BlockState state) {
                set3.add(pos.immutable());
                worldGenLevel.setBlock(pos, state, 19);
            }

            @Override
            @Override
            public boolean isSet(BlockPos pos) {
                return set3.contains(pos);
            }
        };
        BiConsumer<BlockPos, BlockState> biConsumer3 = (pos, state) -> {
            set4.add(pos.immutable());
            worldGenLevel.setBlock((BlockPos)pos, (BlockState)state, 19);
        };
        boolean bl = this.doPlace(worldGenLevel, randomSource, blockPos, biConsumer, biConsumer2, foliageSetter, treeConfiguration);
        if (!bl || set2.isEmpty() && set3.isEmpty()) {
            return false;
        }
        if (!treeConfiguration.decorators.isEmpty()) {
            TreeDecorator.Context context2 = new TreeDecorator.Context(worldGenLevel, biConsumer3, randomSource, set2, set3, set);
            treeConfiguration.decorators.forEach(decorator -> decorator.place(context2));
        }
        return BoundingBox.encapsulatingPositions(Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3, (Iterable)set4)).map(box -> {
            DiscreteVoxelShape discreteVoxelShape = TreeFeature.updateLeaves(worldGenLevel, box, set2, set4, set);
            StructureTemplate.updateShapeAtEdge(worldGenLevel, 3, discreteVoxelShape, box.minX(), box.minY(), box.minZ());
            return true;
        }).orElse(false);
    }

    /*
     * Unable to fully structure code
     */
    private static DiscreteVoxelShape updateLeaves(LevelAccessor world, BoundingBox box, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions, Set<BlockPos> rootPositions) {
        discreteVoxelShape = new BitSetDiscreteVoxelShape(box.getXSpan(), box.getYSpan(), box.getZSpan());
        i = 7;
        list = Lists.newArrayList();
        for (j = 0; j < 7; ++j) {
            list.add(Sets.newHashSet());
        }
        for (BlockPos blockPos : Lists.newArrayList((Iterable)Sets.union(decorationPositions, rootPositions))) {
            if (!box.isInside(blockPos)) continue;
            discreteVoxelShape.fill(blockPos.getX() - box.minX(), blockPos.getY() - box.minY(), blockPos.getZ() - box.minZ());
        }
        mutableBlockPos = new BlockPos.MutableBlockPos();
        k = 0;
        ((Set)list.get(0)).addAll(trunkPositions);
        block2: while (true) {
            if (k < 7 && ((Set)list.get(k)).isEmpty()) {
                ++k;
                continue;
            }
            if (k >= 7) break;
            iterator = ((Set)list.get(k)).iterator();
            blockPos2 = (BlockPos)iterator.next();
            iterator.remove();
            if (!box.isInside(blockPos2)) continue;
            if (k != 0) {
                blockState = world.getBlockState(blockPos2);
                TreeFeature.setBlockKnownShape(world, blockPos2, (BlockState)blockState.setValue(BlockStateProperties.DISTANCE, k));
            }
            discreteVoxelShape.fill(blockPos2.getX() - box.minX(), blockPos2.getY() - box.minY(), blockPos2.getZ() - box.minZ());
            var12_14 = Direction.values();
            var13_15 = var12_14.length;
            var14_16 = 0;
            while (true) {
                if (var14_16 < var13_15) ** break;
                continue block2;
                direction = var12_14[var14_16];
                mutableBlockPos.setWithOffset((Vec3i)blockPos2, direction);
                if (box.isInside(mutableBlockPos) && !discreteVoxelShape.isFull(l = mutableBlockPos.getX() - box.minX(), m = mutableBlockPos.getY() - box.minY(), n = mutableBlockPos.getZ() - box.minZ()) && !(optionalInt = LeavesBlock.getOptionalDistanceAt(blockState2 = world.getBlockState(mutableBlockPos))).isEmpty() && (o = Math.min(optionalInt.getAsInt(), k + 1)) < 7) {
                    ((Set)list.get(o)).add(mutableBlockPos.immutable());
                    k = Math.min(k, o);
                }
                ++var14_16;
            }
            break;
        }
        return discreteVoxelShape;
    }
}

