/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class OreConfiguration
implements FeatureConfiguration {
    public static final Codec<OreConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(TargetBlockState.CODEC).fieldOf("targets").forGetter(config -> config.targetStates), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(config -> config.size), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(config -> Float.valueOf(config.discardChanceOnAirExposure))).apply((Applicative)instance, OreConfiguration::new));
    public final List<TargetBlockState> targetStates;
    public final int size;
    public final float discardChanceOnAirExposure;

    public OreConfiguration(List<TargetBlockState> targets, int size, float discardOnAirChance) {
        this.size = size;
        this.targetStates = targets;
        this.discardChanceOnAirExposure = discardOnAirChance;
    }

    public OreConfiguration(List<TargetBlockState> targets, int size) {
        this(targets, size, 0.0f);
    }

    public OreConfiguration(RuleTest test, BlockState state, int size, float discardOnAirChance) {
        this((List<TargetBlockState>)ImmutableList.of((Object)new TargetBlockState(test, state)), size, discardOnAirChance);
    }

    public OreConfiguration(RuleTest test, BlockState state, int size) {
        this((List<TargetBlockState>)ImmutableList.of((Object)new TargetBlockState(test, state)), size, 0.0f);
    }

    public static TargetBlockState target(RuleTest test, BlockState state) {
        return new TargetBlockState(test, state);
    }

    public static class TargetBlockState {
        public static final Codec<TargetBlockState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.CODEC.fieldOf("target").forGetter(target -> target.target), (App)BlockState.CODEC.fieldOf("state").forGetter(target -> target.state)).apply((Applicative)instance, TargetBlockState::new));
        public final RuleTest target;
        public final BlockState state;

        TargetBlockState(RuleTest target, BlockState state) {
            this.target = target;
            this.state = state;
        }
    }
}

