/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class DarkOakFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<DarkOakFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> DarkOakFoliagePlacer.foliagePlacerParts(instance).apply((Applicative)instance, DarkOakFoliagePlacer::new));

    public DarkOakFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    @Override
    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.DARK_OAK_FOLIAGE_PLACER;
    }

    @Override
    @Override
    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        BlockPos blockPos = treeNode.pos().above(offset);
        boolean bl = treeNode.doubleTrunk();
        if (bl) {
            this.placeLeavesRow(world, placer, random, config, blockPos, radius + 2, -1, bl);
            this.placeLeavesRow(world, placer, random, config, blockPos, radius + 3, 0, bl);
            this.placeLeavesRow(world, placer, random, config, blockPos, radius + 2, 1, bl);
            if (random.nextBoolean()) {
                this.placeLeavesRow(world, placer, random, config, blockPos, radius, 2, bl);
            }
        } else {
            this.placeLeavesRow(world, placer, random, config, blockPos, radius + 2, -1, bl);
            this.placeLeavesRow(world, placer, random, config, blockPos, radius + 1, 0, bl);
        }
    }

    @Override
    @Override
    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return 4;
    }

    @Override
    @Override
    protected boolean shouldSkipLocationSigned(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (!(y != 0 || !giantTrunk || dx != -radius && dx < radius || dz != -radius && dz < radius)) {
            return true;
        }
        return super.shouldSkipLocationSigned(random, dx, y, dz, radius, giantTrunk);
    }

    @Override
    @Override
    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        if (y == -1 && !giantTrunk) {
            return dx == radius && dz == radius;
        }
        if (y == 1) {
            return dx + dz > radius * 2 - 2;
        }
        return false;
    }
}

