/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CocoaDecorator
extends TreeDecorator {
    public static final MapCodec<CocoaDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CocoaDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public CocoaDecorator(float probability) {
        this.probability = probability;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.COCOA;
    }

    @Override
    public void place(TreeDecorator.Context generator) {
        if (generator.logs().isEmpty()) {
            return;
        }
        RandomSource randomSource = generator.random();
        if (!(randomSource.nextFloat() >= this.probability)) {
            ObjectArrayList<BlockPos> list = generator.logs();
            int i = ((BlockPos)list.get(0)).getY();
            list.stream().filter(pos -> pos.getY() - i <= 2).forEach(pos -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction2;
                    BlockPos blockPos;
                    if (!(randomSource.nextFloat() <= 0.25f) || !generator.isAir(blockPos = pos.offset((direction2 = direction.getOpposite()).getStepX(), 0, direction2.getStepZ()))) continue;
                    generator.setBlock(blockPos, (BlockState)((BlockState)Blocks.COCOA.defaultBlockState().setValue(CocoaBlock.AGE, randomSource.nextInt(3))).setValue(HorizontalDirectionalBlock.FACING, direction));
                }
            });
        }
    }
}

