/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class PerlinSimplexNoise {
    private final SimplexNoise[] noiseLevels;
    private final double highestFreqValueFactor;
    private final double highestFreqInputFactor;

    public PerlinSimplexNoise(RandomSource random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    private PerlinSimplexNoise(RandomSource random, IntSortedSet octaves) {
        int j;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -octaves.firstInt();
        int k = i + (j = octaves.lastInt()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        SimplexNoise simplexNoise = new SimplexNoise(random);
        int l = j;
        this.noiseLevels = new SimplexNoise[k];
        if (l >= 0 && l < k && octaves.contains(0)) {
            this.noiseLevels[l] = simplexNoise;
        }
        for (int m = l + 1; m < k; ++m) {
            if (m >= 0 && octaves.contains(l - m)) {
                this.noiseLevels[m] = new SimplexNoise(random);
                continue;
            }
            random.consumeCount(262);
        }
        if (j > 0) {
            long n = (long)(simplexNoise.getValue(simplexNoise.xo, simplexNoise.yo, simplexNoise.zo) * 9.223372036854776E18);
            WorldgenRandom randomSource = new WorldgenRandom(new LegacyRandomSource(n));
            for (int o = l - 1; o >= 0; --o) {
                if (o < k && octaves.contains(l - o)) {
                    this.noiseLevels[o] = new SimplexNoise(randomSource);
                    continue;
                }
                randomSource.consumeCount(262);
            }
        }
        this.highestFreqInputFactor = Math.pow(2.0, j);
        this.highestFreqValueFactor = 1.0 / (Math.pow(2.0, k) - 1.0);
    }

    public double getValue(double x, double y, boolean useOrigin) {
        double d = 0.0;
        double e = this.highestFreqInputFactor;
        double f = this.highestFreqValueFactor;
        for (SimplexNoise simplexNoise : this.noiseLevels) {
            if (simplexNoise != null) {
                d += simplexNoise.getValue(x * e + (useOrigin ? simplexNoise.xo : 0.0), y * e + (useOrigin ? simplexNoise.yo : 0.0)) * f;
            }
            e /= 2.0;
            f *= 2.0;
        }
        return d;
    }
}

