/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.util.NoSuchElementException;
import net.minecraft.util.Mth;

public class SpatialLongSet
extends LongLinkedOpenHashSet {
    private final InternalMap map;

    public SpatialLongSet(int expectedSize, float loadFactor) {
        super(expectedSize, loadFactor);
        this.map = new InternalMap(expectedSize / 64, loadFactor);
    }

    public boolean add(long l) {
        return this.map.addBit(l);
    }

    public boolean rem(long l) {
        return this.map.removeBit(l);
    }

    public long removeFirstLong() {
        return this.map.removeFirstBit();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    protected static class InternalMap
    extends Long2LongLinkedOpenHashMap {
        private static final int X_BITS = Mth.log2(60000000);
        private static final int Z_BITS = Mth.log2(60000000);
        private static final int Y_BITS;
        private static final int Y_OFFSET = 0;
        private static final int Z_OFFSET;
        private static final int X_OFFSET;
        private static final long OUTER_MASK;
        private int lastPos = -1;
        private long lastOuterKey;
        private final int minSize;

        public InternalMap(int expectedSize, float loadFactor) {
            super(expectedSize, loadFactor);
            this.minSize = expectedSize;
        }

        static long getOuterKey(long posLong) {
            return posLong & (OUTER_MASK ^ 0xFFFFFFFFFFFFFFFFL);
        }

        static int getInnerKey(long posLong) {
            int i = (int)(posLong >>> X_OFFSET & 3L);
            int j = (int)(posLong >>> 0 & 3L);
            int k = (int)(posLong >>> Z_OFFSET & 3L);
            return i << 4 | k << 2 | j;
        }

        static long getFullKey(long key, int valueLength) {
            key |= (long)(valueLength >>> 4 & 3) << X_OFFSET;
            key |= (long)(valueLength >>> 2 & 3) << Z_OFFSET;
            return key |= (long)(valueLength >>> 0 & 3) << 0;
        }

        public boolean addBit(long posLong) {
            int k;
            long l = InternalMap.getOuterKey(posLong);
            int i = InternalMap.getInnerKey(posLong);
            long m = 1L << i;
            if (l == 0L) {
                if (this.containsNullKey) {
                    return this.replaceBit(this.n, m);
                }
                this.containsNullKey = true;
                int j = this.n;
            } else {
                if (this.lastPos != -1 && l == this.lastOuterKey) {
                    return this.replaceBit(this.lastPos, m);
                }
                long[] ls = this.key;
                k = (int)HashCommon.mix((long)l) & this.mask;
                long n = ls[k];
                while (n != 0L) {
                    if (n == l) {
                        this.lastPos = k;
                        this.lastOuterKey = l;
                        return this.replaceBit(k, m);
                    }
                    k = k + 1 & this.mask;
                    n = ls[k];
                }
            }
            this.key[k] = l;
            this.value[k] = m;
            if (this.size == 0) {
                this.first = this.last = k;
                this.link[k] = -1L;
            } else {
                int n = this.last;
                this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)k & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                this.link[k] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
                this.last = k;
            }
            if (this.size++ >= this.maxFill) {
                this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
            }
            return false;
        }

        private boolean replaceBit(int index, long mask) {
            boolean bl = (this.value[index] & mask) != 0L;
            int n = index;
            this.value[n] = this.value[n] | mask;
            return bl;
        }

        public boolean removeBit(long posLong) {
            long l = InternalMap.getOuterKey(posLong);
            int i = InternalMap.getInnerKey(posLong);
            long m = 1L << i;
            if (l == 0L) {
                if (this.containsNullKey) {
                    return this.removeFromNullEntry(m);
                }
                return false;
            }
            if (this.lastPos != -1 && l == this.lastOuterKey) {
                return this.removeFromEntry(this.lastPos, m);
            }
            long[] ls = this.key;
            int j = (int)HashCommon.mix((long)l) & this.mask;
            long n = ls[j];
            while (n != 0L) {
                if (l == n) {
                    this.lastPos = j;
                    this.lastOuterKey = l;
                    return this.removeFromEntry(j, m);
                }
                j = j + 1 & this.mask;
                n = ls[j];
            }
            return false;
        }

        private boolean removeFromNullEntry(long mask) {
            if ((this.value[this.n] & mask) == 0L) {
                return false;
            }
            int n = this.n;
            this.value[n] = this.value[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.value[this.n] != 0L) {
                return true;
            }
            this.containsNullKey = false;
            --this.size;
            this.fixPointers(this.n);
            if (this.size < this.maxFill / 4 && this.n > 16) {
                this.rehash(this.n / 2);
            }
            return true;
        }

        private boolean removeFromEntry(int index, long mask) {
            if ((this.value[index] & mask) == 0L) {
                return false;
            }
            int n = index;
            this.value[n] = this.value[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.value[index] != 0L) {
                return true;
            }
            this.lastPos = -1;
            --this.size;
            this.fixPointers(index);
            this.shiftKeys(index);
            if (this.size < this.maxFill / 4 && this.n > 16) {
                this.rehash(this.n / 2);
            }
            return true;
        }

        public long removeFirstBit() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            int i = this.first;
            long l = this.key[i];
            int j = Long.numberOfTrailingZeros(this.value[i]);
            int n = i;
            this.value[n] = this.value[n] & (1L << j ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.value[i] == 0L) {
                this.removeFirstLong();
                this.lastPos = -1;
            }
            return InternalMap.getFullKey(l, j);
        }

        protected void rehash(int i) {
            if (i > this.minSize) {
                super.rehash(i);
            }
        }

        static {
            Z_OFFSET = Y_BITS = 64 - X_BITS - Z_BITS;
            X_OFFSET = Y_BITS + Z_BITS;
            OUTER_MASK = 3L << X_OFFSET | 3L | 3L << Z_OFFSET;
        }
    }
}

