/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = Maps.newHashMap();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage stateManager) {
        this.storage = stateManager;
    }

    private Container newStorage(String namespace) {
        Container container = new Container();
        this.namespaces.put(namespace, container);
        return container;
    }

    private SavedData.Factory<Container> factory(String namespace) {
        return new SavedData.Factory<Container>(() -> this.newStorage(namespace), (nbt, registryLookup) -> this.newStorage(namespace).load((CompoundTag)nbt), DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
    }

    public CompoundTag get(ResourceLocation id) {
        String string = id.getNamespace();
        Container container = this.storage.get(this.factory(string), CommandStorage.createId(string));
        return container != null ? container.get(id.getPath()) : new CompoundTag();
    }

    public void set(ResourceLocation id, CompoundTag nbt) {
        String string = id.getNamespace();
        this.storage.computeIfAbsent(this.factory(string), CommandStorage.createId(string)).put(id.getPath(), nbt);
    }

    public Stream<ResourceLocation> keys() {
        return this.namespaces.entrySet().stream().flatMap(entry -> ((Container)entry.getValue()).getKeys((String)entry.getKey()));
    }

    private static String createId(String namespace) {
        return ID_PREFIX + namespace;
    }

    static class Container
    extends SavedData {
        private static final String TAG_CONTENTS = "contents";
        private final Map<String, CompoundTag> storage = Maps.newHashMap();

        Container() {
        }

        Container load(CompoundTag nbt) {
            CompoundTag compoundTag = nbt.getCompound(TAG_CONTENTS);
            for (String string : compoundTag.getAllKeys()) {
                this.storage.put(string, compoundTag.getCompound(string));
            }
            return this;
        }

        @Override
        @Override
        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
            CompoundTag compoundTag = new CompoundTag();
            this.storage.forEach((key, value) -> compoundTag.put((String)key, value.copy()));
            nbt.put(TAG_CONTENTS, compoundTag);
            return nbt;
        }

        public CompoundTag get(String name) {
            CompoundTag compoundTag = this.storage.get(name);
            return compoundTag != null ? compoundTag : new CompoundTag();
        }

        public void put(String name, CompoundTag nbt) {
            if (nbt.isEmpty()) {
                this.storage.remove(name);
            } else {
                this.storage.put(name, nbt);
            }
            this.setDirty();
        }

        public Stream<ResourceLocation> getKeys(String namespace) {
            return this.storage.keySet().stream().map(key -> ResourceLocation.fromNamespaceAndPath(namespace, key));
        }
    }
}

