/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();
    private static final String TAG_DATA = "Data";
    private static final PathMatcher NO_SYMLINKS_ALLOWED = path -> false;
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    private static final int UNCOMPRESSED_NBT_QUOTA = 0x6400000;
    private static final int DISK_SPACE_WARNING_THRESHOLD = 0x4000000;
    public final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public LevelStorageSource(Path savesDirectory, Path backupsDirectory, DirectoryValidator symlinkFinder, DataFixer dataFixer) {
        this.fixerUpper = dataFixer;
        try {
            FileUtil.createDirectoriesSafe(savesDirectory);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.baseDir = savesDirectory;
        this.backupDir = backupsDirectory;
        this.worldDirValidator = symlinkFinder;
    }

    public static DirectoryValidator parseValidator(Path allowedSymlinksFile) {
        if (Files.exists(allowedSymlinksFile, new LinkOption[0])) {
            try {
                DirectoryValidator directoryvalidator;
                try (BufferedReader bufferedreader = Files.newBufferedReader(allowedSymlinksFile);){
                    directoryvalidator = new DirectoryValidator(PathAllowList.readPlain(bufferedreader));
                }
                return directoryvalidator;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)exception);
            }
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static LevelStorageSource createDefault(Path path) {
        DirectoryValidator directoryvalidator = LevelStorageSource.parseValidator(path.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new LevelStorageSource(path, path.resolve("../backups"), directoryvalidator, DataFixers.getDataFixer());
    }

    public static WorldDataConfiguration readDataConfig(Dynamic<?> dynamic) {
        DataResult dataresult = WorldDataConfiguration.CODEC.parse(dynamic);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public static WorldLoader.PackConfig getPackConfig(Dynamic<?> dynamic, PackRepository dataPackManager, boolean safeMode) {
        return new WorldLoader.PackConfig(dataPackManager, LevelStorageSource.readDataConfig(dynamic), safeMode, false);
    }

    public static LevelDataAndDimensions getLevelDataAndDimensions(Dynamic<?> dynamic, WorldDataConfiguration dataConfiguration, Registry<LevelStem> dimensionsRegistry, RegistryAccess.Frozen registryManager) {
        Dynamic<?> dynamic1 = RegistryOps.injectRegistryContext(dynamic, registryManager);
        Dynamic dynamic2 = dynamic1.get("WorldGenSettings").orElseEmptyMap();
        WorldGenSettings generatorsettings = (WorldGenSettings)WorldGenSettings.CODEC.parse(dynamic2).getOrThrow();
        LevelSettings worldsettings = LevelSettings.parse(dynamic1, dataConfiguration);
        WorldDimensions.Complete worlddimensions_b = generatorsettings.dimensions().bake(dimensionsRegistry);
        Lifecycle lifecycle = worlddimensions_b.lifecycle().add(registryManager.allRegistriesLifecycle());
        PrimaryLevelData worlddataserver = PrimaryLevelData.parse(dynamic1, worldsettings, worlddimensions_b.specialWorldProperty(), generatorsettings.options(), lifecycle);
        worlddataserver.pdc = (Tag)dynamic1.getElement("BukkitValues", null);
        return new LevelDataAndDimensions(worlddataserver, worlddimensions_b);
    }

    public String getName() {
        return "Anvil";
    }

    public LevelCandidates findLevelCandidates() throws LevelStorageException {
        if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
            throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
        }
        try {
            LevelCandidates convertable_a;
            try (Stream<Path> stream = Files.list(this.baseDir);){
                List<LevelDirectory> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(LevelDirectory::new).filter(convertable_b -> Files.isRegularFile(convertable_b.dataFile(), new LinkOption[0]) || Files.isRegularFile(convertable_b.oldDataFile(), new LinkOption[0])).toList();
                convertable_a = new LevelCandidates(list);
            }
            return convertable_a;
        }
        catch (IOException ioexception) {
            throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<LevelSummary>> loadLevelSummaries(LevelCandidates levels) {
        ArrayList<CompletableFuture<LevelSummary>> list = new ArrayList<CompletableFuture<LevelSummary>>(levels.levels.size());
        for (LevelDirectory convertable_b : levels.levels) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = DirectoryLock.isLocked(convertable_b.path());
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to read {} lock", (Object)convertable_b.path(), (Object)exception);
                    return null;
                }
                try {
                    return this.readLevelSummary(convertable_b, flag);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.release();
                    System.gc();
                    String s = "Ran out of memory trying to read summary of world folder \"" + convertable_b.directoryName() + "\"";
                    LOGGER.error(LogUtils.FATAL_MARKER, s);
                    OutOfMemoryError outofmemoryerror1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror1.initCause(outofmemoryerror);
                    CrashReport crashreport = CrashReport.forThrowable(outofmemoryerror1, s);
                    CrashReportCategory crashreportsystemdetails = crashreport.addCategory("World details");
                    crashreportsystemdetails.setDetail("Folder Name", convertable_b.directoryName());
                    try {
                        long i = Files.size(convertable_b.dataFile());
                        crashreportsystemdetails.setDetail("level.dat size", i);
                    }
                    catch (IOException ioexception) {
                        crashreportsystemdetails.setDetailError("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, Util.backgroundExecutor()));
        }
        return Util.sequenceFailFastAndCancel(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    static CompoundTag readLevelDataTagRaw(Path path) throws IOException {
        return NbtIo.readCompressed(path, NbtAccounter.create(0x6400000L));
    }

    static Dynamic<?> readLevelDataTagFixed(Path path, DataFixer dataFixer) throws IOException {
        int i;
        CompoundTag nbttagcompound = LevelStorageSource.readLevelDataTagRaw(path);
        CompoundTag nbttagcompound1 = nbttagcompound.getCompound(TAG_DATA);
        int version = i = NbtUtils.getDataVersion(nbttagcompound1, -1);
        Dynamic<CompoundTag> dynamic = DataFixTypes.LEVEL.updateToCurrentVersion(dataFixer, new Dynamic<CompoundTag>(NbtOps.INSTANCE, nbttagcompound1), i);
        dynamic = dynamic.update("Player", dynamic1 -> new Dynamic<CompoundTag>(NbtOps.INSTANCE, MCDataConverter.convertTag(MCTypeRegistry.PLAYER, (CompoundTag)dynamic1.getValue(), version, SharedConstants.getCurrentVersion().getDataVersion().getVersion())));
        dynamic = dynamic.update("WorldGenSettings", dynamic1 -> DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(dataFixer, dynamic1, i));
        return dynamic;
    }

    private LevelSummary readLevelSummary(LevelDirectory save, boolean locked) {
        Path path = save.dataFile();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.worldDirValidator.validateSymlink(path)).isEmpty()) {
                    LOGGER.warn("{}", (Object)ContentValidationException.getMessage(path, list));
                    return new LevelSummary.SymlinkLevelSummary(save.directoryName(), save.iconFile());
                }
                Tag nbtbase = LevelStorageSource.readLightweightData(path);
                if (nbtbase instanceof CompoundTag) {
                    CompoundTag nbttagcompound = (CompoundTag)nbtbase;
                    CompoundTag nbttagcompound1 = nbttagcompound.getCompound(TAG_DATA);
                    int i = NbtUtils.getDataVersion(nbttagcompound1, -1);
                    Dynamic<CompoundTag> dynamic = DataFixTypes.LEVEL.updateToCurrentVersion(this.fixerUpper, new Dynamic<CompoundTag>(NbtOps.INSTANCE, nbttagcompound1), i);
                    return this.makeLevelSummary(dynamic, save, locked);
                }
                LOGGER.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                LOGGER.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new LevelSummary.CorruptedLevelSummary(save.directoryName(), save.iconFile(), LevelStorageSource.getFileModificationTime(save));
    }

    private static long getFileModificationTime(LevelDirectory save) {
        Instant instant = LevelStorageSource.getFileModificationTime(save.dataFile());
        if (instant == null) {
            instant = LevelStorageSource.getFileModificationTime(save.oldDataFile());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    @Nullable
    static Instant getFileModificationTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    LevelSummary makeLevelSummary(Dynamic<?> dynamic, LevelDirectory save, boolean locked) {
        LevelVersion levelversion = LevelVersion.parse(dynamic);
        int i = levelversion.levelDataVersion();
        if (i != 19132 && i != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i));
        }
        boolean flag1 = i != this.getStorageVersion();
        Path path = save.iconFile();
        WorldDataConfiguration worlddataconfiguration = LevelStorageSource.readDataConfig(dynamic);
        LevelSettings worldsettings = LevelSettings.parse(dynamic, worlddataconfiguration);
        FeatureFlagSet featureflagset = LevelStorageSource.parseFeatureFlagsFromSummary(dynamic);
        boolean flag2 = FeatureFlags.isExperimental(featureflagset);
        return new LevelSummary(worldsettings, levelversion, save.directoryName(), flag1, locked, flag2, path);
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> levelData) {
        Set<ResourceLocation> set = levelData.get("enabled_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().map(ResourceLocation::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames(set, minecraftkey -> {});
    }

    @Nullable
    private static Tag readLightweightData(Path path) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(TAG_DATA, CompoundTag.TYPE, "Player"), new FieldSelector(TAG_DATA, CompoundTag.TYPE, "WorldGenSettings"));
        NbtIo.parseCompressed(path, (StreamTagVisitor)skipfields, NbtAccounter.create(0x6400000L));
        return skipfields.getResult();
    }

    public boolean isNewLevelIdAcceptable(String name) {
        try {
            Path path = this.getLevelPath(name);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean levelExists(String name) {
        try {
            return Files.isDirectory(this.getLevelPath(name), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path getLevelPath(String name) {
        return this.baseDir.resolve(name);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public LevelStorageAccess validateAndCreateAccess(String s, ResourceKey<LevelStem> dimensionType) throws IOException, ContentValidationException {
        List<ForbiddenSymlinkInfo> list;
        Path path = this.getLevelPath(s);
        List<ForbiddenSymlinkInfo> list2 = list = Boolean.getBoolean("paper.disableWorldSymlinkValidation") ? List.of() : this.worldDirValidator.validateDirectory(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new LevelStorageAccess(s, path, dimensionType);
    }

    public LevelStorageAccess createAccess(String s, ResourceKey<LevelStem> dimensionType) throws IOException {
        Path path = this.getLevelPath(s);
        return new LevelStorageAccess(s, path, dimensionType);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public static Path getStorageFolder(Path path, ResourceKey<LevelStem> dimensionType) {
        if (dimensionType == LevelStem.OVERWORLD) {
            return path;
        }
        if (dimensionType == LevelStem.NETHER) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == LevelStem.END) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.location().getNamespace()).resolve(dimensionType.location().getPath());
    }

    public record LevelCandidates(List<LevelDirectory> levels) implements Iterable<LevelDirectory>
    {
        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.levels.iterator();
        }
    }

    public record LevelDirectory(Path path) {
        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(LevelResource.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(LevelResource.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(LocalDateTime dateTime) {
            Path path = this.path;
            String s = LevelResource.LEVEL_DATA_FILE.getId();
            return path.resolve(s + "_corrupted_" + dateTime.format(FORMATTER));
        }

        public Path rawDataFile(LocalDateTime dateTime) {
            Path path = this.path;
            String s = LevelResource.LEVEL_DATA_FILE.getId();
            return path.resolve(s + "_raw_" + dateTime.format(FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(LevelResource.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(LevelResource.LOCK_FILE);
        }

        public Path resourcePath(LevelResource savePath) {
            return this.path.resolve(savePath.getId());
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock lock;
        public final LevelDirectory levelDirectory;
        private final String levelId;
        private final Map<LevelResource, Path> resources = Maps.newHashMap();
        public final ResourceKey<LevelStem> dimensionType;

        LevelStorageAccess(String s, Path path, ResourceKey<LevelStem> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.levelId = s;
            this.levelDirectory = new LevelDirectory(path);
            this.lock = DirectoryLock.create(path);
        }

        public long estimateDiskSpace() {
            try {
                return Files.getFileStore(this.levelDirectory.path).getUsableSpace();
            }
            catch (Exception exception) {
                return Long.MAX_VALUE;
            }
        }

        public boolean checkForLowDiskSpace() {
            return this.estimateDiskSpace() < 0x4000000L;
        }

        public void safeClose() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)this.getLevelId(), (Object)ioexception);
            }
        }

        public LevelStorageSource parent() {
            return LevelStorageSource.this;
        }

        public LevelDirectory getLevelDirectory() {
            return this.levelDirectory;
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(LevelResource savePath) {
            Map<LevelResource, Path> map = this.resources;
            LevelDirectory convertable_b = this.levelDirectory;
            Objects.requireNonNull(this.levelDirectory);
            return map.computeIfAbsent(savePath, convertable_b::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<Level> key) {
            return LevelStorageSource.getStorageFolder(this.levelDirectory.path(), this.dimensionType);
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage createPlayerStorage() {
            this.checkLock();
            return new PlayerDataStorage(this, LevelStorageSource.this.fixerUpper);
        }

        public LevelSummary getSummary(Dynamic<?> dynamic) {
            this.checkLock();
            return LevelStorageSource.this.makeLevelSummary(dynamic, this.levelDirectory, false);
        }

        public Dynamic<?> getDataTag() throws IOException {
            return this.getDataTag(false);
        }

        public Dynamic<?> getDataTagFallback() throws IOException {
            return this.getDataTag(true);
        }

        private Dynamic<?> getDataTag(boolean old) throws IOException {
            this.checkLock();
            return LevelStorageSource.readLevelDataTagFixed(old ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile(), LevelStorageSource.this.fixerUpper);
        }

        public void saveDataTag(RegistryAccess registryManager, WorldData saveProperties) {
            this.saveDataTag(registryManager, saveProperties, null);
        }

        public void saveDataTag(RegistryAccess registryManager, WorldData saveProperties, @Nullable CompoundTag nbt) {
            CompoundTag nbttagcompound1 = saveProperties.createTag(registryManager, nbt);
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.put(LevelStorageSource.TAG_DATA, nbttagcompound1);
            this.saveLevelData(nbttagcompound2);
        }

        private void saveLevelData(CompoundTag nbt) {
            Path path = this.levelDirectory.path();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NbtIo.writeCompressed(nbt, path1);
                Path path2 = this.levelDirectory.oldDataFile();
                Path path3 = this.levelDirectory.dataFile();
                Util.safeReplaceFile(path3, path1, path2);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> getIconFile() {
            return !this.lock.isValid() ? Optional.empty() : Optional.of(this.levelDirectory.iconFile());
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path path = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int i = 1; i <= 5; ++i) {
                LOGGER.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                LOGGER.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path1, @Nullable IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(LevelStorageAccess.this.levelDirectory.path())) {
                                LevelStorageAccess.this.lock.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void renameLevel(String name) throws IOException {
            this.modifyLevelDataWithoutDatafix(nbttagcompound -> nbttagcompound.putString("LevelName", name.trim()));
        }

        public void renameAndDropPlayer(String name) throws IOException {
            this.modifyLevelDataWithoutDatafix(nbttagcompound -> {
                nbttagcompound.putString("LevelName", name.trim());
                nbttagcompound.remove("Player");
            });
        }

        private void modifyLevelDataWithoutDatafix(Consumer<CompoundTag> nbtProcessor) throws IOException {
            this.checkLock();
            CompoundTag nbttagcompound = LevelStorageSource.readLevelDataTagRaw(this.levelDirectory.dataFile());
            nbtProcessor.accept(nbttagcompound.getCompound(LevelStorageSource.TAG_DATA));
            this.saveLevelData(nbttagcompound);
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String s = LocalDateTime.now().format(FORMATTER);
            String s1 = s + "_" + this.levelId;
            Path path = LevelStorageSource.this.getBackupPath();
            try {
                FileUtil.createDirectoriesSafe(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.findAvailableName(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(LevelStorageAccess.this.levelDirectory.path().relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean hasWorldData() {
            return Files.exists(this.levelDirectory.dataFile(), new LinkOption[0]) || Files.exists(this.levelDirectory.oldDataFile(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }

        public boolean restoreLevelDataFromOld() {
            return Util.safeReplaceOrMoveFile(this.levelDirectory.dataFile(), this.levelDirectory.oldDataFile(), this.levelDirectory.corruptedDataFile(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant getFileModificationTime(boolean old) {
            return LevelStorageSource.getFileModificationTime(old ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile());
        }
    }
}

