/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AlternativesEntry
extends CompositeEntryBase {
    public static final MapCodec<AlternativesEntry> CODEC = AlternativesEntry.createCodec(AlternativesEntry::new);

    AlternativesEntry(List<LootPoolEntryContainer> terms, List<LootItemCondition> conditions) {
        super(terms, conditions);
    }

    @Override
    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.ALTERNATIVES;
    }

    @Override
    @Override
    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> terms) {
        return switch (terms.size()) {
            case 0 -> ALWAYS_FALSE;
            case 1 -> terms.get(0);
            case 2 -> terms.get(0).or(terms.get(1));
            default -> (context, lootChoiceExpander) -> {
                for (ComposableEntryContainer composableEntryContainer : terms) {
                    if (!composableEntryContainer.expand(context, lootChoiceExpander)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    @Override
    @Override
    public void validate(ValidationContext reporter) {
        super.validate(reporter);
        for (int i = 0; i < this.children.size() - 1; ++i) {
            if (!this.children.get((int)i).conditions.isEmpty()) continue;
            reporter.reportProblem("Unreachable entry!");
        }
    }

    public static Builder alternatives(LootPoolEntryContainer.Builder<?> ... children) {
        return new Builder(children);
    }

    public static <E> Builder alternatives(Collection<E> children, Function<E, LootPoolEntryContainer.Builder<?>> toBuilderFunction) {
        return new Builder((LootPoolEntryContainer.Builder[])children.stream().map(toBuilderFunction::apply).toArray(LootPoolEntryContainer.Builder[]::new));
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... children) {
            for (LootPoolEntryContainer.Builder<?> builder : children) {
                this.entries.add((Object)builder.build());
            }
        }

        @Override
        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        @Override
        public Builder otherwise(LootPoolEntryContainer.Builder<?> builder) {
            this.entries.add((Object)builder.build());
            return this;
        }

        @Override
        @Override
        public LootPoolEntryContainer build() {
            return new AlternativesEntry((List<LootPoolEntryContainer>)this.entries.build(), this.getConditions());
        }

        @Override
        protected /* synthetic */ LootPoolEntryContainer.Builder getThis() {
            return this.getThis();
        }
    }
}

