/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyNameFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyNameFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyNameFunction.commonFields(instance).and((App)NameSource.CODEC.fieldOf("source").forGetter(function -> function.source)).apply((Applicative)instance, CopyNameFunction::new));
    private final NameSource source;

    private CopyNameFunction(List<LootItemCondition> conditions, NameSource source) {
        super(conditions);
        this.source = source;
    }

    @Override
    public LootItemFunctionType<CopyNameFunction> getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of(this.source.param);
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        Object object = context.getParamOrNull(this.source.param);
        if (object instanceof Nameable) {
            Nameable nameable = (Nameable)object;
            stack.set(DataComponents.CUSTOM_NAME, nameable.getCustomName());
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> copyName(NameSource source) {
        return CopyNameFunction.simpleBuilder(conditions -> new CopyNameFunction((List<LootItemCondition>)conditions, source));
    }

    public static enum NameSource implements StringRepresentable
    {
        THIS("this", LootContextParams.THIS_ENTITY),
        ATTACKING_ENTITY("attacking_entity", LootContextParams.ATTACKING_ENTITY),
        LAST_DAMAGE_PLAYER("last_damage_player", LootContextParams.LAST_DAMAGE_PLAYER),
        BLOCK_ENTITY("block_entity", LootContextParams.BLOCK_ENTITY);

        public static final Codec<NameSource> CODEC;
        private final String name;
        final LootContextParam<?> param;

        private NameSource(String name, LootContextParam<?> parameter) {
            this.name = name;
            this.param = parameter;
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(NameSource::values);
        }
    }
}

