/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FilteredFunction
extends LootItemConditionalFunction {
    public static final MapCodec<FilteredFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> FilteredFunction.commonFields(instance).and(instance.group((App)ItemPredicate.CODEC.fieldOf("item_filter").forGetter(lootFunction -> lootFunction.filter), (App)LootItemFunctions.ROOT_CODEC.fieldOf("modifier").forGetter(lootFunction -> lootFunction.modifier))).apply((Applicative)instance, FilteredFunction::new));
    private final ItemPredicate filter;
    private final LootItemFunction modifier;

    private FilteredFunction(List<LootItemCondition> conditions, ItemPredicate itemFilter, LootItemFunction modifier) {
        super(conditions);
        this.filter = itemFilter;
        this.modifier = modifier;
    }

    @Override
    public LootItemFunctionType<FilteredFunction> getType() {
        return LootItemFunctions.FILTERED;
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        if (this.filter.test(stack)) {
            return (ItemStack)this.modifier.apply(stack, context);
        }
        return stack;
    }

    @Override
    @Override
    public void validate(ValidationContext reporter) {
        super.validate(reporter);
        this.modifier.validate(reporter.forChild(".modifier"));
    }
}

