/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.Shapes;

public final class DiscreteCubeMerger
implements IndexMerger {
    private final CubePointRange result;
    private final int firstDiv;
    private final int secondDiv;

    DiscreteCubeMerger(int i, int j) {
        this.result = new CubePointRange((int)Shapes.lcm(i, j));
        int k = IntMath.gcd((int)i, (int)j);
        this.firstDiv = i / k;
        this.secondDiv = j / k;
    }

    @Override
    @Override
    public boolean forMergedIndexes(IndexMerger.IndexConsumer predicate) {
        int i = this.result.size() - 1;
        for (int j = 0; j < i; ++j) {
            if (predicate.merge(j / this.secondDiv, j / this.firstDiv, j)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    @Override
    public DoubleList getList() {
        return this.result;
    }
}

