/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;

public class Score
implements ReadOnlyScoreInfo {
    private static final String TAG_SCORE = "Score";
    private static final String TAG_LOCKED = "Locked";
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_FORMAT = "format";
    private int value;
    private boolean locked = true;
    @Nullable
    private Component display;
    @Nullable
    private NumberFormat numberFormat;

    @Override
    @Override
    public int value() {
        return this.value;
    }

    public void value(int score) {
        this.value = score;
    }

    @Override
    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Nullable
    public Component display() {
        return this.display;
    }

    public void display(@Nullable Component text) {
        this.display = text;
    }

    @Override
    @Nullable
    @Override
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public CompoundTag write(HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt(TAG_SCORE, this.value);
        compoundTag.putBoolean(TAG_LOCKED, this.locked);
        if (this.display != null) {
            compoundTag.putString(TAG_DISPLAY, Component.Serializer.toJson(this.display, registries));
        }
        if (this.numberFormat != null) {
            NumberFormatTypes.CODEC.encodeStart(registries.createSerializationContext(NbtOps.INSTANCE), (Object)this.numberFormat).ifSuccess(formatElement -> compoundTag.put(TAG_FORMAT, (Tag)formatElement));
        }
        return compoundTag;
    }

    public static Score read(CompoundTag nbt, HolderLookup.Provider registries) {
        Score score = new Score();
        score.value = nbt.getInt(TAG_SCORE);
        score.locked = nbt.getBoolean(TAG_LOCKED);
        if (nbt.contains(TAG_DISPLAY, 8)) {
            score.display = Component.Serializer.fromJson(nbt.getString(TAG_DISPLAY), registries);
        }
        if (nbt.contains(TAG_FORMAT, 10)) {
            NumberFormatTypes.CODEC.parse(registries.createSerializationContext(NbtOps.INSTANCE), (Object)nbt.get(TAG_FORMAT)).ifSuccess(format -> {
                score.numberFormat = format;
            });
        }
        return score;
    }
}

