/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Crafter;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.inventory.Inventory;

public class CraftCrafter
extends CraftLootable<CrafterBlockEntity>
implements Crafter {
    public CraftCrafter(World world, CrafterBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCrafter(CraftCrafter state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    public Inventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getTileEntity());
    }

    @Override
    public CraftCrafter copy() {
        return new CraftCrafter(this, null);
    }

    @Override
    public CraftCrafter copy(Location location) {
        return new CraftCrafter(this, location);
    }

    public int getCraftingTicks() {
        return ((CrafterBlockEntity)this.getSnapshot()).craftingTicksRemaining;
    }

    public void setCraftingTicks(int ticks) {
        ((CrafterBlockEntity)this.getSnapshot()).setCraftingTicksRemaining(ticks);
    }

    public boolean isSlotDisabled(int slot) {
        Preconditions.checkArgument((slot >= 0 && slot < 9 ? 1 : 0) != 0, (String)"Invalid slot index %s for Crafter", (int)slot);
        return ((CrafterBlockEntity)this.getSnapshot()).isSlotDisabled(slot);
    }

    public void setSlotDisabled(int slot, boolean disabled) {
        Preconditions.checkArgument((slot >= 0 && slot < 9 ? 1 : 0) != 0, (String)"Invalid slot index %s for Crafter", (int)slot);
        ((CrafterBlockEntity)this.getSnapshot()).setSlotState(slot, disabled);
    }

    public boolean isTriggered() {
        return ((CrafterBlockEntity)this.getSnapshot()).isTriggered();
    }

    public void setTriggered(boolean triggered) {
        ((CrafterBlockEntity)this.getSnapshot()).setTriggered(triggered);
    }
}

