/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.command;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.command.ServerCommandSender;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.ServerOperator;

public class CraftBlockCommandSender
extends ServerCommandSender
implements BlockCommandSender {
    private static final PermissibleBase SHARED_PERM = new PermissibleBase(new ServerOperator(){

        public boolean isOp() {
            return true;
        }

        public void setOp(boolean value) {
            throw new UnsupportedOperationException("Cannot change operator status of a block");
        }
    });
    private final CommandSourceStack block;
    private final BlockEntity tile;

    public CraftBlockCommandSender(CommandSourceStack commandBlockListenerAbstract, BlockEntity tile) {
        super(SHARED_PERM);
        this.block = commandBlockListenerAbstract;
        this.tile = tile;
    }

    public Block getBlock() {
        return CraftBlock.at(this.tile.getLevel(), this.tile.getBlockPos());
    }

    public void sendMessage(String message) {
        for (Component component : CraftChatMessage.fromString(message)) {
            this.block.source.sendSystemMessage(component);
        }
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public String getName() {
        return this.block.getTextName();
    }

    public void sendMessage(Identity identity, net.kyori.adventure.text.Component message, MessageType type) {
        this.block.source.sendSystemMessage(PaperAdventure.asVanilla(message));
    }

    public net.kyori.adventure.text.Component name() {
        return PaperAdventure.asAdventure(this.block.getDisplayName());
    }

    public boolean isOp() {
        return SHARED_PERM.isOp();
    }

    public void setOp(boolean value) {
        SHARED_PERM.setOp(value);
    }

    public CommandSourceStack getWrapper() {
        return this.block;
    }
}

