/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.command;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.net.SocketAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.server.rcon.RconConsoleSource;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.craftbukkit.command.ServerCommandSender;
import org.bukkit.permissions.Permission;

public class CraftRemoteConsoleCommandSender
extends ServerCommandSender
implements RemoteConsoleCommandSender {
    private final RconConsoleSource listener;

    public CraftRemoteConsoleCommandSender(RconConsoleSource listener) {
        this.listener = listener;
    }

    public RconConsoleSource getListener() {
        return this.listener;
    }

    public SocketAddress getAddress() {
        return this.listener.socketAddress;
    }

    public void sendMessage(String message) {
        this.listener.sendSystemMessage(Component.literal(message + "\n"));
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public String getName() {
        return "Rcon";
    }

    public net.kyori.adventure.text.Component name() {
        return net.kyori.adventure.text.Component.text((String)this.getName());
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of remote controller.");
    }

    @Override
    public boolean hasPermission(String name) {
        return GlobalConfiguration.get().console.hasAllPermissions || super.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return GlobalConfiguration.get().console.hasAllPermissions || super.hasPermission(perm);
    }
}

