/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.BossBarImplementationImpl;
import io.papermc.paper.adventure.DisplayNames;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarImplementation;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.util.MonkeyBars;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ClientboundStoreCookiePacket;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.ServerLinks;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.ban.IpBanList;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.CraftEffect;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftOfflinePlayer;
import org.bukkit.craftbukkit.CraftParticle;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftServerLinks;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.CraftWorldBorder;
import org.bukkit.craftbukkit.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.conversations.ConversationTracker;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.map.CraftMapCursor;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.craftbukkit.map.RenderData;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements org.bukkit.entity.Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> invertedVisibilityEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private final Set<UUID> unlistedEntities = new HashSet<UUID>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private BorderChangeListener clientWorldBorderListener = this.createWorldBorderListener();
    public PlayerResourcePackStatusEvent.Status resourcePackStatus;
    private static final boolean DISABLE_CHANNEL_LIMIT = System.getProperty("paper.disableChannelLimit") != null;
    private long lastSaveTime;
    private final Queue<CookieFuture> requestedCookies = new LinkedList<CookieFuture>();
    private Component playerListHeader;
    private Component playerListFooter;
    private static final Component DEFAULT_KICK_COMPONENT = Component.translatable((String)"multiplayer.disconnect.kicked");
    @Nullable
    private Set<BossBar> activeBossBars;
    private final Player.Spigot spigot = new Player.Spigot(){

        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().connection.getRawAddress();
        }

        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().getPlayerList().respawn(CraftPlayer.this.getHandle(), false, Entity.RemovalReason.KILLED, PlayerRespawnEvent.RespawnReason.PLUGIN);
            }
        }

        public Set<org.bukkit.entity.Player> getHiddenPlayers() {
            HashSet<org.bukkit.entity.Player> ret = new HashSet<org.bukkit.entity.Player>();
            for (org.bukkit.entity.Player p : CraftPlayer.this.getServer().getOnlinePlayers()) {
                if (CraftPlayer.this.canSee(p)) continue;
                ret.add(p);
            }
            return Collections.unmodifiableSet(ret);
        }

        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        public void sendMessage(BaseComponent ... components) {
            this.sendMessage(ChatMessageType.SYSTEM, components);
        }

        public void sendMessage(UUID sender, BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, sender, component);
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, sender, components);
        }

        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            this.sendMessage(position, (UUID)null, components);
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent component) {
            this.sendMessage(position, sender, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().connection == null) {
                return;
            }
            CraftPlayer.this.getHandle().connection.send(new ClientboundSystemChatPacket(components, position == ChatMessageType.ACTION_BAR));
        }

        public int getPing() {
            return CraftPlayer.this.getPing();
        }
    };
    private boolean simplifyContainerDesyncCheck;

    public CraftPlayer(CraftServer server, ServerPlayer entity) {
        super(server, entity);
        this.simplifyContainerDesyncCheck = GlobalConfiguration.get().unsupportedSettings.simplifyRemoteItemMatching;
        this.firstPlayed = System.currentTimeMillis();
    }

    public GameProfile getProfile() {
        return this.getHandle().getGameProfile();
    }

    @Override
    public void remove() {
        if (this.getHandle().getClass().equals(ServerPlayer.class)) {
            throw new UnsupportedOperationException(String.format("Cannot remove player %s, use Player#kickPlayer(String) instead.", this.getName()));
        }
        super.remove();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().isOp(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().op(this.getProfile());
        } else {
            this.server.getHandle().deop(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    public boolean isConnected() {
        return !this.getHandle().hasDisconnected();
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().connection == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().connection.getRemoteAddress();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Nullable
    public InetSocketAddress getHAProxyAddress() {
        InetSocketAddress inetSocketAddress;
        if (this.getHandle().connection == null) {
            return null;
        }
        SocketAddress socketAddress = this.getHandle().connection.connection.haProxyAddress;
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public boolean handleCookieResponse(ServerboundCookieResponsePacket response) {
        CookieFuture future = this.requestedCookies.peek();
        if (future != null && future.key.equals(response.key())) {
            Preconditions.checkState((future == this.requestedCookies.poll() ? 1 : 0) != 0, (Object)"requestedCookies queue mismatch");
            future.future().complete(response.payload());
            return true;
        }
        return false;
    }

    public boolean isTransferred() {
        return this.getHandle().transferCookieConnection.isTransferred();
    }

    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        ResourceLocation nms = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.add(new CookieFuture(nms, future));
        this.getHandle().transferCookieConnection.sendPacket(new ClientboundCookieRequestPacket(nms));
        return future;
    }

    public void storeCookie(NamespacedKey key, byte[] value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Cookie value cannot be null");
        Preconditions.checkArgument((value.length <= 5120 ? 1 : 0) != 0, (Object)"Cookie value too large, must be smaller than 5120 bytes");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.CONFIGURATION || this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.PLAY ? 1 : 0) != 0, (Object)"Can only store cookie in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket(new ClientboundStoreCookiePacket(CraftNamespacedKey.toMinecraft(key), value));
    }

    public void transfer(String host, int port) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"Host cannot be null");
        Preconditions.checkState((this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.CONFIGURATION || this.getHandle().transferCookieConnection.getProtocol() == ConnectionProtocol.PLAY ? 1 : 0) != 0, (Object)"Can only transfer in CONFIGURATION or PLAY protocol.");
        this.getHandle().transferCookieConnection.sendPacket(new ClientboundTransferPacket(host, port));
    }

    public int getProtocolVersion() {
        if (this.getHandle().connection == null) {
            return -1;
        }
        return this.getHandle().connection.connection.protocolVersion;
    }

    public InetSocketAddress getVirtualHost() {
        if (this.getHandle().connection == null) {
            return null;
        }
        return this.getHandle().connection.connection.virtualHost;
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    public void sendRawMessage(String message) {
        this.sendRawMessage(null, message);
    }

    public void sendRawMessage(UUID sender, String message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        for (net.minecraft.network.chat.Component component : CraftChatMessage.fromString(message)) {
            this.getHandle().sendSystemMessage(component);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    @Deprecated
    public void sendActionBar(BaseComponent[] message) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket(CraftChatMessage.fromJSON(ComponentSerializer.toString((BaseComponent[])message)));
        this.getHandle().connection.send(packet);
    }

    @Deprecated
    public void sendActionBar(String message) {
        if (this.getHandle().connection == null || message == null || message.isEmpty()) {
            return;
        }
        this.getHandle().connection.send(new ClientboundSetActionBarTextPacket(CraftChatMessage.fromStringOrNull(message)));
    }

    @Deprecated
    public void sendActionBar(char alternateChar, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.sendActionBar(ChatColor.translateAlternateColorCodes((char)alternateChar, (String)message));
    }

    public void setPlayerListHeaderFooter(BaseComponent[] header, BaseComponent[] footer) {
        if (header != null) {
            String headerJson = ComponentSerializer.toString((BaseComponent[])header);
            this.playerListHeader = GsonComponentSerializer.gson().deserialize((Object)headerJson);
        } else {
            this.playerListHeader = null;
        }
        if (footer != null) {
            String footerJson = ComponentSerializer.toString((BaseComponent[])footer);
            this.playerListFooter = GsonComponentSerializer.gson().deserialize((Object)footerJson);
        } else {
            this.playerListFooter = null;
        }
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(BaseComponent header, BaseComponent footer) {
        BaseComponent[] baseComponentArray;
        BaseComponent[] baseComponentArray2;
        if (header == null) {
            baseComponentArray2 = null;
        } else {
            BaseComponent[] baseComponentArray3 = new BaseComponent[1];
            baseComponentArray2 = baseComponentArray3;
            baseComponentArray3[0] = header;
        }
        if (footer == null) {
            baseComponentArray = null;
        } else {
            BaseComponent[] baseComponentArray4 = new BaseComponent[1];
            baseComponentArray = baseComponentArray4;
            baseComponentArray4[0] = footer;
        }
        this.setPlayerListHeaderFooter(baseComponentArray2, baseComponentArray);
    }

    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.getHandle().connection.send(new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks));
    }

    public void setSubtitle(BaseComponent[] subtitle) {
        ClientboundSetSubtitleTextPacket packet = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromJSON(ComponentSerializer.toString((BaseComponent[])subtitle)));
        this.getHandle().connection.send(packet);
    }

    public void setSubtitle(BaseComponent subtitle) {
        this.setSubtitle(new BaseComponent[]{subtitle});
    }

    public void showTitle(BaseComponent[] title) {
        ClientboundSetTitleTextPacket packet = new ClientboundSetTitleTextPacket(CraftChatMessage.fromJSON(ComponentSerializer.toString((BaseComponent[])title)));
        this.getHandle().connection.send(packet);
    }

    public void showTitle(BaseComponent title) {
        this.showTitle(new BaseComponent[]{title});
    }

    public void showTitle(BaseComponent[] title, BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void showTitle(BaseComponent title, BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        this.setSubtitle(title.getSubtitle() == null ? new BaseComponent[]{} : title.getSubtitle());
        this.showTitle(title.getTitle());
    }

    public void updateTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        if (title.getSubtitle() != null) {
            this.setSubtitle(title.getSubtitle());
        }
        this.showTitle(title.getTitle());
    }

    public void hideTitle() {
        this.getHandle().connection.send(new ClientboundClearTitlesPacket(false));
    }

    public String getDisplayName() {
        return DisplayNames.getLegacy(this);
    }

    public void setDisplayName(String name) {
        this.getHandle().adventure$displayName = name != null ? LegacyComponentSerializer.legacySection().deserialize(name) : Component.text((String)this.getName());
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    public void playerListName(Component name) {
        net.minecraft.network.chat.Component component = this.getHandle().listName = name == null ? null : PaperAdventure.asVanilla(name);
        if (this.getHandle().connection == null) {
            return;
        }
        for (ServerPlayer player : this.server.getHandle().players) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.connection.send(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.getHandle()));
        }
    }

    public Component playerListName() {
        return this.getHandle().listName == null ? Component.text((String)this.getName()) : PaperAdventure.asAdventure(this.getHandle().listName);
    }

    public Component playerListHeader() {
        return this.playerListHeader;
    }

    public Component playerListFooter() {
        return this.playerListFooter;
    }

    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        net.minecraft.network.chat.Component component = this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        if (this.getHandle().connection == null) {
            return;
        }
        for (ServerPlayer player : this.server.getHandle().players) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.connection.send(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, this.getHandle()));
        }
    }

    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : LegacyComponentSerializer.legacySection().serialize(this.playerListHeader);
    }

    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : LegacyComponentSerializer.legacySection().serialize(this.playerListFooter);
    }

    public void setPlayerListHeader(String header) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListFooter(String footer) {
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundTabListPacket packet = new ClientboundTabListPacket(PaperAdventure.asVanillaNullToEmpty(this.playerListHeader), PaperAdventure.asVanillaNullToEmpty(this.playerListFooter));
        this.getHandle().connection.send(packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    public void kickPlayer(String message) {
        AsyncCatcher.catchOp("player kick");
        this.getHandle().transferCookieConnection.kickPlayer(CraftChatMessage.fromStringOrEmpty(message, true), PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick() {
        this.kick(DEFAULT_KICK_COMPONENT);
    }

    public void kick(Component message) {
        this.kick(message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(Component message, PlayerKickEvent.Cause cause) {
        AsyncCatcher.catchOp("player kick");
        ServerGamePacketListenerImpl connection = this.getHandle().connection;
        if (connection != null) {
            connection.disconnect((Component)(message == null ? Component.empty() : message), cause);
        }
    }

    public <T> T getClientOption(ClientOption<T> type) {
        if (ClientOption.SKIN_PARTS == type) {
            return type.getType().cast(new PaperSkinParts(this.getHandle().getEntityData().get(Player.DATA_PLAYER_MODE_CUSTOMISATION).byteValue()));
        }
        if (ClientOption.CHAT_COLORS_ENABLED == type) {
            return type.getType().cast(this.getHandle().canChatInColor());
        }
        if (ClientOption.CHAT_VISIBILITY == type) {
            return type.getType().cast(this.getHandle().getChatVisibility() == null ? ClientOption.ChatVisibility.UNKNOWN : ClientOption.ChatVisibility.valueOf((String)this.getHandle().getChatVisibility().name()));
        }
        if (ClientOption.LOCALE == type) {
            return type.getType().cast(this.getLocale());
        }
        if (ClientOption.MAIN_HAND == type) {
            return type.getType().cast(this.getMainHand());
        }
        if (ClientOption.VIEW_DISTANCE == type) {
            return type.getType().cast(this.getClientViewDistance());
        }
        if (ClientOption.ALLOW_SERVER_LISTINGS == type) {
            return type.getType().cast(this.getHandle().allowsListing());
        }
        if (ClientOption.TEXT_FILTERING_ENABLED == type) {
            return type.getType().cast(this.getHandle().isTextFilteringEnabled());
        }
        throw new RuntimeException("Unknown settings type");
    }

    public void sendOpLevel(byte level) {
        Preconditions.checkArgument((level >= 0 && level <= 4 ? 1 : 0) != 0, (Object)"Level must be within [0, 4]");
        this.getHandle().getServer().getPlayerList().sendPlayerPermissionLevel(this.getHandle(), level, false);
    }

    public void addAdditionalChatCompletions(@NotNull Collection<String> completions) {
        this.getHandle().connection.send(new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.ADD, new ArrayList<String>(completions)));
    }

    public void removeAdditionalChatCompletions(@NotNull Collection<String> completions) {
        this.getHandle().connection.send(new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.REMOVE, new ArrayList<String>(completions)));
    }

    public void setCompassTarget(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundSetDefaultSpawnPositionPacket(CraftLocation.toBlockPosition(loc), loc.getYaw()));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"msg cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (ServerGamePacketListenerImpl.isChatMessageIllegal(msg)) {
            this.getHandle().connection.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (msg.startsWith("/")) {
            this.getHandle().connection.handleCommand(msg);
        } else {
            PlayerChatMessage playerChatMessage = PlayerChatMessage.system(msg).withUnsignedContent(net.minecraft.network.chat.Component.literal(msg));
            this.getHandle().connection.chat(msg, playerChatMessage, false);
        }
    }

    public boolean performCommand(String command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command cannot be null");
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, byte instrument, byte note) {
        this.playNote(loc, Instrument.getByType((byte)instrument), new Note((int)note));
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((instrument != null ? 1 : 0) != 0, (Object)"Instrument cannot be null");
        Preconditions.checkArgument((note != null ? 1 : 0) != 0, (Object)"Note cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        Sound instrumentSound = instrument.getSound();
        if (instrumentSound == null) {
            return;
        }
        NoteBlockInstrument noteBlockInstrument = CraftBlockData.toNMS(instrument, NoteBlockInstrument.class);
        float pitch = noteBlockInstrument.isTunable() ? note.getPitch() : 1.0f;
        this.getHandle().connection.send(new ClientboundSoundPacket(CraftSound.bukkitToMinecraftHolder(instrumentSound), SoundSource.RECORDS, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, pitch, this.getHandle().getRandom().nextLong()));
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().connection == null) {
            return;
        }
        this.playSound0(loc, CraftSound.bukkitToMinecraftHolder(sound), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        if (loc == null || sound == null || category == null || this.getHandle().connection == null) {
            return;
        }
        this.playSound0(loc, Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Location loc, Holder<SoundEvent> soundEffectHolder, SoundSource categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundSoundPacket packet = new ClientboundSoundPacket(soundEffectHolder, categoryNMS, loc.getX(), loc.getY(), loc.getZ(), volume, pitch, seed);
        this.getHandle().connection.send(packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().connection != null) break block3;
            }
            return;
        }
        this.playSound0(entity, CraftSound.bukkitToMinecraftHolder(sound), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                CraftEntity craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().connection != null) break block3;
            }
            return;
        }
        this.playSound0(entity, Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    private void playSound0(Entity entity, Holder<SoundEvent> soundEffectHolder, SoundSource categoryNMS, float volume, float pitch, long seed) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((soundEffectHolder != null ? 1 : 0) != 0, (Object)"Holder of SoundEffect cannot be null");
        Preconditions.checkArgument((categoryNMS != null ? 1 : 0) != 0, (Object)"SoundCategory cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (!(entity instanceof CraftEntity)) {
            return;
        }
        CraftEntity craftEntity = (CraftEntity)entity;
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(soundEffectHolder, categoryNMS, craftEntity.getHandle(), volume, pitch, seed);
        this.getHandle().connection.send(packet);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundStopSoundPacket(ResourceLocation.parse(sound), category == null ? SoundSource.MASTER : SoundSource.valueOf(category.name())));
    }

    public void stopSound(SoundCategory category) {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundStopSoundPacket(null, SoundSource.valueOf(category.name())));
    }

    public void stopAllSounds() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundStopSoundPacket(null, null));
    }

    public void playEffect(Location loc, Effect effect, int data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        int packetData = effect.getId();
        ClientboundLevelEventPacket packet = new ClientboundLevelEventPacket(packetData, CraftLocation.toBlockPosition(loc), data, false);
        this.getHandle().connection.send(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.isApplicable(data), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals((Object)this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().gameMode.destroyBlock(new BlockPos(block.getX(), block.getY(), block.getZ()));
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(CraftLocation.toBlockPosition(loc), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().connection.send(packet);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(CraftLocation.toBlockPosition(loc), ((CraftBlockData)block).getState());
        this.getHandle().connection.send(packet);
    }

    public void sendMultiBlockChange(Map<? extends Position, BlockData> blockChanges) {
        if (this.getHandle().connection == null) {
            return;
        }
        HashMap<SectionPos, Short2ObjectMap> sectionMap = new HashMap<SectionPos, Short2ObjectMap>();
        for (Map.Entry<? extends Position, BlockData> entry : blockChanges.entrySet()) {
            BlockData blockData = entry.getValue();
            BlockPos blockPos = MCUtil.toBlockPos(entry.getKey());
            SectionPos sectionPos = SectionPos.of(blockPos);
            Short2ObjectMap sectionData = sectionMap.computeIfAbsent(sectionPos, key -> new Short2ObjectArrayMap());
            sectionData.put(SectionPos.sectionRelativePos(blockPos), (Object)((CraftBlockData)blockData).getState());
        }
        for (Map.Entry<Object, Object> entry : sectionMap.entrySet()) {
            SectionPos sectionPos = (SectionPos)entry.getKey();
            Short2ObjectMap blockData = (Short2ObjectMap)entry.getValue();
            ClientboundSectionBlocksUpdatePacket packet = new ClientboundSectionBlocksUpdatePacket(sectionPos, (Short2ObjectMap<BlockState>)blockData);
            this.getHandle().connection.send(packet);
        }
    }

    public void sendBlockChanges(Collection<org.bukkit.block.BlockState> blocks) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().connection == null || blocks.isEmpty()) {
            return;
        }
        HashMap<SectionPos, ChunkSectionChanges> changes = new HashMap<SectionPos, ChunkSectionChanges>();
        for (org.bukkit.block.BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            BlockPos blockPosition = cstate.getPosition();
            SectionPos sectionPosition = SectionPos.of(blockPosition);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(SectionPos.sectionRelativePos(blockPosition));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            ClientboundSectionBlocksUpdatePacket packet = new ClientboundSectionBlocksUpdatePacket((SectionPos)entry.getKey(), chunkChanges.positions(), (BlockState[])chunkChanges.blockData().toArray(BlockState[]::new));
            this.getHandle().connection.send(packet);
        }
    }

    public void sendBlockChanges(Collection<org.bukkit.block.BlockState> blocks, boolean suppressLightUpdates) {
        this.sendBlockChanges(blocks);
    }

    public void sendBlockDamage(Location loc, float progress) {
        this.sendBlockDamage(loc, progress, this.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, Entity source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source must not be null");
        this.sendBlockDamage(loc, progress, source.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().connection == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        ClientboundBlockDestructionPacket packet = new ClientboundBlockDestructionPacket(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().connection.send(packet);
    }

    public void sendSignChange(Location loc, @Nullable List<? extends Component> lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().connection == null) {
            return;
        }
        if (lines == null) {
            lines = new ArrayList<Component>(4);
        }
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines.size() < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        net.minecraft.network.chat.Component[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((dyeColor != null ? 1 : 0) != 0, (Object)"DyeColor cannot be null");
        if (lines == null) {
            lines = new String[4];
        }
        Preconditions.checkArgument((lines.length >= 4 ? 1 : 0) != 0, (String)"Must have at least 4 lines (%s)", (int)lines.length);
        if (this.getHandle().connection == null) {
            return;
        }
        net.minecraft.network.chat.Component[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    private void sendSignChange0(net.minecraft.network.chat.Component[] components, Location loc, DyeColor dyeColor, boolean hasGlowingText) {
        SignBlockEntity sign = new SignBlockEntity(CraftLocation.toBlockPosition(loc), Blocks.OAK_SIGN.defaultBlockState());
        SignText text = sign.getFrontText();
        text = text.setColor(net.minecraft.world.item.DyeColor.byId(dyeColor.getWoolData()));
        text = text.setHasGlowingText(hasGlowingText);
        for (int i = 0; i < components.length; ++i) {
            text = text.setMessage(i, components[i]);
        }
        sign.setText(text, true);
        this.getHandle().connection.send(new ClientboundBlockEntityDataPacket(sign.getBlockPos(), sign.getType(), sign.getUpdateTag(this.getHandle().registryAccess())));
    }

    public void sendBlockUpdate(@NotNull Location location, @NotNull TileState tileState) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location can not be null");
        Preconditions.checkArgument((tileState != null ? 1 : 0) != 0, (Object)"TileState can not be null");
        if (this.getHandle().connection == null) {
            return;
        }
        CraftBlockEntityState craftState = (CraftBlockEntityState)tileState;
        this.getHandle().connection.send(craftState.getUpdatePacket(location));
    }

    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, org.bukkit.inventory.ItemStack item) {
        this.sendEquipmentChange(entity, Collections.singletonMap(slot, item));
    }

    public void sendEquipmentChange(LivingEntity entity, Map<EquipmentSlot, org.bukkit.inventory.ItemStack> items) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        ArrayList<Pair<net.minecraft.world.entity.EquipmentSlot, ItemStack>> equipment = new ArrayList<Pair<net.minecraft.world.entity.EquipmentSlot, ItemStack>>(items.size());
        for (Map.Entry<EquipmentSlot, org.bukkit.inventory.ItemStack> entry : items.entrySet()) {
            EquipmentSlot slot = entry.getKey();
            Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Cannot set null EquipmentSlot");
            equipment.add((Pair<net.minecraft.world.entity.EquipmentSlot, ItemStack>)new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(entry.getValue())));
        }
        this.getHandle().connection.send(new ClientboundSetEquipmentPacket(entity.getEntityId(), equipment));
    }

    public void sendPotionEffectChange(LivingEntity entity, PotionEffect effect) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundUpdateMobEffectPacket(entity.getEntityId(), CraftPotionUtil.fromBukkit(effect), true));
    }

    public void sendPotionEffectChangeRemove(LivingEntity entity, PotionEffectType type) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundRemoveMobEffectPacket(entity.getEntityId(), CraftPotionEffectType.bukkitToMinecraftHolder(type)));
    }

    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    public void setWorldBorder(WorldBorder border) {
        net.minecraft.world.level.border.WorldBorder newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals((Object)this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().removeListener(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().addListener(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        ServerGamePacketListenerImpl connection = this.getHandle().connection;
        connection.send(new ClientboundSetBorderSizePacket(newWorldBorder));
        connection.send(new ClientboundSetBorderLerpSizePacket(newWorldBorder));
        connection.send(new ClientboundSetBorderCenterPacket(newWorldBorder));
        connection.send(new ClientboundSetBorderWarningDelayPacket(newWorldBorder));
        connection.send(new ClientboundSetBorderWarningDistancePacket(newWorldBorder));
    }

    private BorderChangeListener createWorldBorderListener() {
        return new BorderChangeListener(){

            @Override
            public void onBorderSizeSet(net.minecraft.world.level.border.WorldBorder border, double size) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderSizePacket(border));
            }

            @Override
            public void onBorderSizeLerping(net.minecraft.world.level.border.WorldBorder border, double fromSize, double toSize, long time) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderLerpSizePacket(border));
            }

            @Override
            public void onBorderCenterSet(net.minecraft.world.level.border.WorldBorder border, double centerX, double centerZ) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderCenterPacket(border));
            }

            @Override
            public void onBorderSetWarningTime(net.minecraft.world.level.border.WorldBorder border, int warningTime) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderWarningDelayPacket(border));
            }

            @Override
            public void onBorderSetWarningBlocks(net.minecraft.world.level.border.WorldBorder border, int warningBlockDistance) {
                CraftPlayer.this.getHandle().connection.send(new ClientboundSetBorderWarningDistancePacket(border));
            }

            @Override
            public void onBorderSetDamagePerBlock(net.minecraft.world.level.border.WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(net.minecraft.world.level.border.WorldBorder border, double safeZoneRadius) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    public void sendMap(MapView map) {
        if (this.getHandle().connection == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapDecoration> icons = new ArrayList<MapDecoration>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapDecoration(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
        }
        ClientboundMapItemDataPacket packet = new ClientboundMapItemDataPacket(new MapId(map.getId()), map.getScale().getValue(), map.isLocked(), icons, new MapItemSavedData.MapPatch(0, 0, 128, 128, data.buffer));
        this.getHandle().connection.send(packet);
    }

    public void sendHurtAnimation(float yaw) {
        this.sendHurtAnimation(yaw, this);
    }

    public void sendHurtAnimation(float yaw, Entity target) {
        if (this.getHandle().connection == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().connection.send(new ClientboundHurtAnimationPacket(target.getEntityId(), actualYaw));
    }

    public void sendLinks(ServerLinks links) {
        if (this.getHandle().connection == null) {
            return;
        }
        Preconditions.checkArgument((links != null ? 1 : 0) != 0, (Object)"links cannot be null");
        net.minecraft.server.ServerLinks nms = ((CraftServerLinks)links).getServerLinks();
        this.getHandle().connection.send(new ClientboundServerLinksPacket(nms.untrust()));
    }

    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.ADD);
    }

    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.REMOVE);
    }

    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.SET);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, ClientboundCustomChatCompletionsPacket.Action action) {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundCustomChatCompletionsPacket packet = new ClientboundCustomChatCompletionsPacket(action, new ArrayList<String>(completions));
        this.getHandle().connection.send(packet);
    }

    public void showWinScreen() {
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundGameEventPacket packet = new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 1.0f);
        this.getHandle().connection.send(packet);
    }

    public boolean hasSeenWinScreen() {
        return this.getHandle().seenCredits;
    }

    public void setHasSeenWinScreen(boolean hasSeenWinScreen) {
        this.getHandle().seenCredits = hasSeenWinScreen;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        Location targetLocation = this.getEyeLocation();
        targetLocation.setYaw(yaw);
        targetLocation.setPitch(pitch);
        Vector direction = targetLocation.getDirection();
        direction.multiply(9999999);
        targetLocation.add(direction);
        this.lookAt((Position)targetLocation, LookAnchor.EYES);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(location, cause, new TeleportFlag[0]);
    }

    public void lookAt(@NotNull Entity entity, @NotNull LookAnchor playerAnchor, @NotNull LookAnchor entityAnchor) {
        this.getHandle().lookAt(CraftPlayer.toNmsAnchor(playerAnchor), ((CraftEntity)entity).getHandle(), CraftPlayer.toNmsAnchor(entityAnchor));
    }

    public void lookAt(double x, double y, double z, @NotNull LookAnchor playerAnchor) {
        this.getHandle().lookAt(CraftPlayer.toNmsAnchor(playerAnchor), new Vec3(x, y, z));
    }

    public static EntityAnchorArgument.Anchor toNmsAnchor(LookAnchor nmsAnchor) {
        return switch (nmsAnchor) {
            default -> throw new MatchException(null, null);
            case LookAnchor.EYES -> EntityAnchorArgument.Anchor.EYES;
            case LookAnchor.FEET -> EntityAnchorArgument.Anchor.FEET;
        };
    }

    public static LookAnchor toApiAnchor(EntityAnchorArgument.Anchor playerAnchor) {
        return switch (playerAnchor) {
            default -> throw new MatchException(null, null);
            case EntityAnchorArgument.Anchor.EYES -> LookAnchor.EYES;
            case EntityAnchorArgument.Anchor.FEET -> LookAnchor.FEET;
        };
    }

    public static RelativeMovement toNmsRelativeFlag(TeleportFlag.Relative apiFlag) {
        return switch (apiFlag) {
            default -> throw new MatchException(null, null);
            case TeleportFlag.Relative.X -> RelativeMovement.X;
            case TeleportFlag.Relative.Y -> RelativeMovement.Y;
            case TeleportFlag.Relative.Z -> RelativeMovement.Z;
            case TeleportFlag.Relative.PITCH -> RelativeMovement.X_ROT;
            case TeleportFlag.Relative.YAW -> RelativeMovement.Y_ROT;
        };
    }

    public static TeleportFlag.Relative toApiRelativeFlag(RelativeMovement nmsFlag) {
        return switch (nmsFlag) {
            default -> throw new MatchException(null, null);
            case RelativeMovement.X -> TeleportFlag.Relative.X;
            case RelativeMovement.Y -> TeleportFlag.Relative.Y;
            case RelativeMovement.Z -> TeleportFlag.Relative.Z;
            case RelativeMovement.X_ROT -> TeleportFlag.Relative.PITCH;
            case RelativeMovement.Y_ROT -> TeleportFlag.Relative.YAW;
        };
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        Set<TeleportFlag> allFlags;
        Set<TeleportFlag.Relative> relativeArguments;
        if (flags.length == 0) {
            relativeArguments = Set.of();
            allFlags = Set.of();
        } else {
            relativeArguments = EnumSet.noneOf(TeleportFlag.Relative.class);
            allFlags = new HashSet();
            for (TeleportFlag flag : flags) {
                if (flag instanceof TeleportFlag.Relative) {
                    TeleportFlag.Relative relativeTeleportFlag = (TeleportFlag.Relative)flag;
                    relativeArguments.add(relativeTeleportFlag);
                }
                allFlags.add(flag);
            }
        }
        boolean dismount = !allFlags.contains(TeleportFlag.EntityState.RETAIN_VEHICLE);
        boolean ignorePassengers = allFlags.contains(TeleportFlag.EntityState.RETAIN_PASSENGERS);
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        if (ignorePassengers && this.entity.isVehicle() && location.getWorld() != this.getWorld()) {
            return false;
        }
        if (!dismount && this.entity.isPassenger() && location.getWorld() != this.getWorld()) {
            return false;
        }
        location.checkFinite();
        ServerPlayer entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.isRemoved()) {
            return false;
        }
        if (entity.connection == null) {
            return false;
        }
        if (entity.isVehicle() && !ignorePassengers) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((org.bukkit.entity.Player)this, from, to, cause, Set.copyOf(relativeArguments));
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (dismount) {
            entity.stopRiding();
        }
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        ServerLevel fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        ServerLevel toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().containerMenu != this.getHandle().inventoryMenu && !allFlags.contains(TeleportFlag.EntityState.RETAIN_OPEN_INVENTORY)) {
            this.getHandle().closeContainer(InventoryCloseEvent.Reason.TELEPORT);
        }
        if (fromWorld == toWorld) {
            EnumSet<RelativeMovement> nms = EnumSet.noneOf(RelativeMovement.class);
            for (TeleportFlag.Relative bukkit : relativeArguments) {
                nms.add(CraftPlayer.toNmsRelativeFlag(bukkit));
            }
            entity.connection.internalTeleport(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch(), nms);
        } else {
            entity.portalProcess = null;
            this.server.getHandle().respawn(entity, true, Entity.RemovalReason.CHANGED_DIMENSION, null, to);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().setShiftKeyDown(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().isShiftKeyDown();
    }

    public boolean isSprinting() {
        return this.getHandle().isSprinting();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().setSprinting(sprinting);
    }

    public void loadData() {
        this.server.getHandle().playerIo.load(this.getHandle());
    }

    public void saveData() {
        this.server.getHandle().playerIo.save(this.getHandle());
    }

    @Deprecated
    public void updateInventory() {
        this.getHandle().containerMenu.sendAllDataToRemote();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().updateSleepingPlayerList();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public Location getBedSpawnLocation() {
        return this.getRespawnLocation();
    }

    public Location getRespawnLocation() {
        Optional<ServerPlayer.RespawnPosAngle> spawnLoc;
        ServerLevel world = this.getHandle().server.getLevel(this.getHandle().getRespawnDimension());
        BlockPos bed = this.getHandle().getRespawnPosition();
        if (world != null && bed != null && (spawnLoc = ServerPlayer.findRespawnAndUseSpawnBlock(world, bed, this.getHandle().getRespawnAngle(), this.getHandle().isRespawnForced(), true)).isPresent()) {
            ServerPlayer.RespawnPosAngle vec = spawnLoc.get();
            return CraftLocation.toBukkit(vec.position(), (World)world.getWorld(), vec.yaw(), 0.0f);
        }
        return null;
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setRespawnLocation(Location location) {
        this.setRespawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        this.setRespawnLocation(location, override);
    }

    public void setRespawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, null, 0.0f, override, false, PlayerSetSpawnEvent.Cause.PLUGIN);
        } else {
            this.getHandle().setRespawnPosition(((CraftWorld)location.getWorld()).getHandle().dimension(), CraftLocation.toBlockPosition(location), location.getYaw(), override, false, PlayerSetSpawnEvent.Cause.PLUGIN);
        }
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPos bed = this.getHandle().getRespawnPosition();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().getRecipeBook().contains(CraftNamespacedKey.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().getRecipeBook().known.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key)));
        return bukkitRecipeKeys.build();
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, this.getHandle());
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().getStats(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().getStats(), statistic, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, material, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, material, this.getHandle());
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().getStats(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, material, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, material, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().getStats(), statistic, material, newValue, this.getHandle());
    }

    public void incrementStatistic(Statistic statistic, org.bukkit.entity.EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, entityType, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, org.bukkit.entity.EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, entityType, this.getHandle());
    }

    public int getStatistic(Statistic statistic, org.bukkit.entity.EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().getStats(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, org.bukkit.entity.EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().getStats(), statistic, entityType, amount, this.getHandle());
    }

    public void decrementStatistic(Statistic statistic, org.bukkit.entity.EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().getStats(), statistic, entityType, amount, this.getHandle());
    }

    public void setStatistic(Statistic statistic, org.bukkit.entity.EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().getStats(), statistic, entityType, newValue, this.getHandle());
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    public int getExpCooldown() {
        return this.getHandle().takeXpDelay;
    }

    public void setExpCooldown(int ticks) {
        this.getHandle().takeXpDelay = CraftEventFactory.callPlayerXpCooldownEvent(this.getHandle(), ticks, PlayerExpCooldownChangeEvent.ChangeReason.PLUGIN).getNewCooldown();
    }

    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return this.ban(reason, expires, source, true);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return this.ban(reason, expires != null ? Date.from(expires) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source, boolean kickPlayer) {
        BanEntry banEntry = ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.ban(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.ban(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Date expires, String source, boolean kickPlayer) {
        Preconditions.checkArgument((this.getAddress() != null ? 1 : 0) != 0, (Object)"The Address of this Player is null");
        BanEntry banEntry = ((IpBanList)this.server.getBanList(BanList.Type.IP)).addBan((Object)this.getAddress().getAddress(), reason, expires, source);
        if (kickPlayer) {
            this.kickPlayer(reason);
        }
        return banEntry;
    }

    public BanEntry<InetAddress> banIp(String reason, Instant instant, String source, boolean kickPlayer) {
        return this.banIp(reason, instant != null ? Date.from(instant) : null, source, kickPlayer);
    }

    public BanEntry<InetAddress> banIp(String reason, Duration duration, String source, boolean kickPlayer) {
        return this.banIp(reason, duration != null ? Instant.now().plus(duration) : null, source, kickPlayer);
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().getWhiteList().isWhiteListed(this.getProfile());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().getWhiteList().add(new UserWhiteListEntry(this.getProfile()));
        } else {
            this.server.getHandle().getWhiteList().remove(this.getProfile());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().setGameMode(GameType.byId(mode.getValue()), PlayerGameModeChangeEvent.Cause.PLUGIN, null);
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().gameMode.getGameModeForPlayer().getId());
    }

    public GameMode getPreviousGameMode() {
        GameType previousGameMode = this.getHandle().gameMode.getPreviousGameModeForPlayer();
        return previousGameMode == null ? null : GameMode.getByValue((int)previousGameMode.getId());
    }

    public int applyMending(int amount) {
        ServerPlayer handle = this.getHandle();
        Optional<EnchantedItemInUse> stackEntry = EnchantmentHelper.getRandomItemWith(EnchantmentEffectComponents.REPAIR_WITH_XP, handle, ItemStack::isDamaged);
        ItemStack itemstack = stackEntry.map(EnchantedItemInUse::itemStack).orElse(ItemStack.EMPTY);
        if (!itemstack.isEmpty() && itemstack.getItem().components().has(DataComponents.MAX_DAMAGE)) {
            ExperienceOrb orb = EntityType.EXPERIENCE_ORB.create(handle.level());
            orb.value = amount;
            orb.spawnReason = ExperienceOrb.SpawnReason.CUSTOM;
            orb.setPosRaw(handle.getX(), handle.getY(), handle.getZ());
            int possibleDurabilityFromXp = EnchantmentHelper.modifyDurabilityToRepairFromXp(handle.serverLevel(), itemstack, amount);
            int i = Math.min(possibleDurabilityFromXp, itemstack.getDamageValue());
            int consumedExperience = i * amount / possibleDurabilityFromXp;
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(handle, orb, itemstack, stackEntry.get().inSlot(), i, consumedExperience);
            i = event.getRepairAmount();
            orb.discard(EntityRemoveEvent.Cause.DESPAWN);
            if (!event.isCancelled()) {
                amount -= consumedExperience;
                itemstack.setDamageValue(itemstack.getDamageValue() - i);
            }
        }
        return amount;
    }

    public void giveExp(int exp, boolean applyMending) {
        if (applyMending) {
            exp = this.applyMending(exp);
        }
        this.getHandle().giveExperiencePoints(exp);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().giveExperienceLevels(levels);
    }

    public float getExp() {
        return this.getHandle().experienceProgress;
    }

    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().experienceProgress = exp;
        this.getHandle().lastSentExp = -1;
    }

    public int getLevel() {
        return this.getHandle().experienceLevel;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().experienceLevel = level;
        this.getHandle().lastSentExp = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().totalExperience;
    }

    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().totalExperience = exp;
    }

    public int calculateTotalExperiencePoints() {
        return this.calculateTotalExperiencePoints(this.getLevel()) + Math.round((float)this.getExperiencePointsNeededForNextLevel() * this.getExp());
    }

    public void setExperienceLevelAndProgress(int totalExperience) {
        Preconditions.checkArgument((totalExperience >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)totalExperience);
        int level = this.calculateLevelsForExperiencePoints(totalExperience);
        int remainingPoints = totalExperience - this.calculateTotalExperiencePoints(level);
        this.getHandle().experienceLevel = level;
        this.getHandle().experienceProgress = (float)remainingPoints / (float)this.getExperiencePointsNeededForNextLevel();
        this.getHandle().lastSentExp = -1;
    }

    public int getExperiencePointsNeededForNextLevel() {
        return this.getHandle().getXpNeededForNextLevel();
    }

    private int calculateTotalExperiencePoints(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    private int calculateLevelsForExperiencePoints(int points) {
        if (points <= 352) {
            return (int)Math.floor(Math.sqrt(points + 9) - 3.0);
        }
        if (points <= 1507) {
            return (int)Math.floor(8.1 + Math.sqrt(0.4 * ((double)points - 195.975)));
        }
        return (int)Math.floor(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)points - 752.9861111111111)));
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().connection == null) {
            return;
        }
        ClientboundSetExperiencePacket packet = new ClientboundSetExperiencePacket(progress, this.getTotalExperience(), level);
        this.getHandle().connection.send(packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Deprecated
    public void hidePlayer(org.bukkit.entity.Player player) {
        this.hideEntity0(null, (Entity)player);
    }

    public void hidePlayer(Plugin plugin, org.bukkit.entity.Player player) {
        this.hideEntity(plugin, (Entity)player);
    }

    public void hideEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (String)"Plugin (%s) cannot be disabled", (Object)plugin.getName());
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity hidden cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldHide = entity.isVisibleByDefault() ? this.addInvertedVisibility(plugin, entity) : this.removeInvertedVisibility(plugin, entity);
        if (shouldHide) {
            this.untrackAndHideEntity(entity);
        }
    }

    private boolean addInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins != null) {
            invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return false;
        }
        invertedPlugins = new HashSet<WeakReference<Plugin>>();
        invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.invertedVisibilityEntities.put(entity.getUniqueId(), invertedPlugins);
        return true;
    }

    private void untrackAndHideEntity(Entity entity) {
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        this.unregisterEntity(other);
        this.server.getPluginManager().callEvent((Event)new PlayerHideEntityEvent((org.bukkit.entity.Player)this, entity));
    }

    private void unregisterEntity(net.minecraft.world.entity.Entity other) {
        ChunkMap tracker = ((ServerLevel)this.getHandle().level()).getChunkSource().chunkMap;
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(other.getId());
        if (entry != null) {
            entry.removePlayer(this.getHandle());
        }
        if (other instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().connection.send(new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.getUUID())));
            }
        }
    }

    void resetAndHideEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.untrackAndHideEntity(entity);
        }
    }

    @Deprecated
    public void showPlayer(org.bukkit.entity.Player player) {
        this.showEntity0(null, (Entity)player);
    }

    public void showPlayer(Plugin plugin, org.bukkit.entity.Player player) {
        this.showEntity(plugin, (Entity)player);
    }

    public void showEntity(Plugin plugin, Entity entity) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity show cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldShow = entity.isVisibleByDefault() ? this.removeInvertedVisibility(plugin, entity) : this.addInvertedVisibility(plugin, entity);
        if (shouldShow) {
            this.trackAndShowEntity(entity);
        }
    }

    private boolean removeInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins == null) {
            return false;
        }
        invertedPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!invertedPlugins.isEmpty()) {
            return false;
        }
        this.invertedVisibilityEntities.remove(entity.getUniqueId());
        return true;
    }

    private void trackAndShowEntity(Entity entity) {
        this.trackAndShowEntity(entity, null);
    }

    private void trackAndShowEntity(Entity entity, @Nullable UUID uuidOverride) {
        ChunkMap.TrackedEntity entry;
        ChunkMap tracker = ((ServerLevel)this.getHandle().level()).getChunkSource().chunkMap;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        if (other instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)other;
            UUID original = null;
            if (uuidOverride != null) {
                original = otherPlayer.getUUID();
                otherPlayer.setUUID(uuidOverride);
            }
            this.getHandle().connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(otherPlayer), this.getHandle()));
            if (original != null) {
                otherPlayer.setUUID(original);
            }
        }
        if ((entry = (ChunkMap.TrackedEntity)tracker.entityMap.get(other.getId())) != null && !entry.seenBy.contains(this.getHandle().connection)) {
            entry.updatePlayer(this.getHandle());
        }
        this.server.getPluginManager().callEvent((Event)new PlayerShowEntityEvent((org.bukkit.entity.Player)this, entity));
    }

    public void setPlayerProfile(PlayerProfile profile) {
        CraftPlayer bukkitPlayer;
        ServerPlayer self = this.getHandle();
        GameProfile gameProfile = CraftPlayerProfile.asAuthlibCopy(profile);
        if (!self.sentListPacket) {
            self.gameProfile = gameProfile;
            return;
        }
        List<ServerPlayer> players = this.server.getServer().getPlayerList().players;
        for (ServerPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee(this)) continue;
            bukkitPlayer.unregisterEntity(self);
        }
        self.gameProfile = gameProfile;
        for (ServerPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee(this)) continue;
            bukkitPlayer.trackAndShowEntity(self.getBukkitEntity(), gameProfile.getId());
        }
        this.refreshPlayer();
    }

    void resetAndShowEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.trackAndShowEntity(entity);
        }
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this).clone();
    }

    private void refreshPlayer() {
        ServerPlayer handle = this.getHandle();
        Location loc = this.getLocation();
        ServerGamePacketListenerImpl connection = handle.connection;
        ServerLevel worldserver = handle.serverLevel();
        connection.send(new ClientboundRespawnPacket(handle.createCommonSpawnInfo(worldserver), 3));
        handle.onUpdateAbilities();
        connection.internalTeleport(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), Collections.emptySet());
        PlayerList playerList = handle.server.getPlayerList();
        playerList.sendPlayerPermissionLevel(handle, false);
        playerList.sendLevelInfo(handle, worldserver);
        playerList.sendAllPlayerInfo(handle);
        connection.send(new ClientboundSetExperiencePacket(handle.experienceProgress, handle.totalExperience, handle.experienceLevel));
        for (MobEffectInstance mobEffect : handle.getActiveEffects()) {
            connection.send(new ClientboundUpdateMobEffectPacket(handle.getId(), mobEffect, false));
        }
    }

    public void onEntityRemove(net.minecraft.world.entity.Entity entity) {
        this.invertedVisibilityEntities.remove(entity.getUUID());
    }

    public boolean canSee(org.bukkit.entity.Player player) {
        return this.canSee((Entity)player);
    }

    public boolean canSee(Entity entity) {
        return this.equals(entity) || entity.isVisibleByDefault() ^ this.invertedVisibilityEntities.containsKey(entity.getUniqueId());
    }

    public boolean canSeePlayer(UUID uuid) {
        org.bukkit.entity.Player entity = this.getServer().getPlayer(uuid);
        return entity != null ? this.canSee((Entity)entity) : false;
    }

    public boolean isListed(org.bukkit.entity.Player other) {
        return !this.unlistedEntities.contains(other.getUniqueId());
    }

    public boolean unlistPlayer(@NotNull org.bukkit.entity.Player other) {
        Preconditions.checkNotNull((Object)other, (Object)"hidden entity cannot be null");
        if (this.getHandle().connection == null) {
            return false;
        }
        if (!this.canSee(other)) {
            return false;
        }
        if (this.unlistedEntities.add(other.getUniqueId())) {
            this.getHandle().connection.send(ClientboundPlayerInfoUpdatePacket.updateListed(other.getUniqueId(), false));
            return true;
        }
        return false;
    }

    public boolean listPlayer(@NotNull org.bukkit.entity.Player other) {
        Preconditions.checkNotNull((Object)other, (Object)"hidden entity cannot be null");
        if (this.getHandle().connection == null) {
            return false;
        }
        if (!this.canSee(other)) {
            throw new IllegalStateException("Player cannot see other player");
        }
        if (this.unlistedEntities.remove(other.getUniqueId())) {
            this.getHandle().connection.send(ClientboundPlayerInfoUpdatePacket.updateListed(other.getUniqueId(), true));
            return true;
        }
        return false;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public org.bukkit.entity.Player getPlayer() {
        return this;
    }

    @Override
    public ServerPlayer getHandle() {
        return (ServerPlayer)this.entity;
    }

    public void setHandle(ServerPlayer entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public long getLastLogin() {
        return this.getHandle().loginTime;
    }

    public long getLastSeen() {
        return this.isOnline() ? System.currentTimeMillis() : this.lastSaveTime;
    }

    public void readExtraData(CompoundTag nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.contains("bukkit")) {
            CompoundTag data = nbttagcompound.getCompound("bukkit");
            if (data.contains("firstPlayed")) {
                this.firstPlayed = data.getLong("firstPlayed");
                this.lastPlayed = data.getLong("lastPlayed");
            }
            if (data.contains("newExp")) {
                ServerPlayer handle = this.getHandle();
                handle.newExp = data.getInt("newExp");
                handle.newTotalExp = data.getInt("newTotalExp");
                handle.newLevel = data.getInt("newLevel");
                handle.expToDrop = data.getInt("expToDrop");
                handle.keepLevel = data.getBoolean("keepLevel");
            }
        }
    }

    public void setExtraData(CompoundTag nbttagcompound) {
        this.lastSaveTime = System.currentTimeMillis();
        if (!nbttagcompound.contains("bukkit")) {
            nbttagcompound.put("bukkit", new CompoundTag());
        }
        CompoundTag data = nbttagcompound.getCompound("bukkit");
        ServerPlayer handle = this.getHandle();
        data.putInt("newExp", handle.newExp);
        data.putInt("newTotalExp", handle.newTotalExp);
        data.putInt("newLevel", handle.newLevel);
        data.putInt("expToDrop", handle.expToDrop);
        data.putBoolean("keepLevel", handle.keepLevel);
        data.putLong("firstPlayed", this.getFirstPlayed());
        data.putLong("lastPlayed", System.currentTimeMillis());
        data.putString("lastKnownName", handle.getScoreboardName());
        if (!nbttagcompound.contains("Paper")) {
            nbttagcompound.put("Paper", new CompoundTag());
        }
        CompoundTag paper = nbttagcompound.getCompound("Paper");
        paper.putLong("LastLogin", handle.loginTime);
        paper.putLong("LastSeen", System.currentTimeMillis());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().connection == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            ResourceLocation id = ResourceLocation.parse(StandardMessenger.validateAndCorrectChannel((String)channel));
            this.sendCustomPayload(id, message);
        }
    }

    private void sendCustomPayload(ResourceLocation id, byte[] message) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(new DiscardedPayload(id, Unpooled.wrappedBuffer((byte[])message)));
        this.getHandle().connection.send(packet);
    }

    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    public void setResourcePack(String url) {
        this.setResourcePack(url, null);
    }

    public void setResourcePack(String url, byte[] hash) {
        this.setResourcePack(url, hash, false);
    }

    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, null, force);
    }

    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, prompt, force);
    }

    public void setResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack ID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new ClientboundResourcePackPushPacket(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), true);
    }

    public void addResourcePack(UUID id, String url, byte[] hash, String prompt, boolean force) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        String hashStr = "";
        if (hash != null) {
            Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0, (String)"Resource pack hash should be 20 bytes long but was %s", (int)hash.length);
            hashStr = BaseEncoding.base16().lowerCase().encode(hash);
        }
        this.handlePushResourcePack(new ClientboundResourcePackPushPacket(id, url, hashStr, force, CraftChatMessage.fromStringOrOptional(prompt, true)), false);
    }

    public void setResourcePack(UUID uuid, String url, byte[] hashBytes, Component prompt, boolean force) {
        String hash;
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Resource pack UUID cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Resource pack URL cannot be null");
        if (hashBytes != null) {
            Preconditions.checkArgument((hashBytes.length == 20 ? 1 : 0) != 0, (Object)("Resource pack hash should be 20 bytes long but was " + hashBytes.length));
            hash = BaseEncoding.base16().lowerCase().encode(hashBytes);
        } else {
            hash = "";
        }
        this.getHandle().connection.send(new ClientboundResourcePackPopPacket(Optional.empty()));
        this.getHandle().connection.send(new ClientboundResourcePackPushPacket(uuid, url, hash, force, Optional.ofNullable(prompt).map(PaperAdventure::asVanilla)));
    }

    void sendBundle(List<? extends Packet<? extends ClientCommonPacketListener>> packet) {
        this.getHandle().connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)packet));
    }

    public void sendResourcePacks(ResourcePackRequest request) {
        if (this.getHandle().connection == null) {
            return;
        }
        ArrayList<ClientboundResourcePackPushPacket> packs = new ArrayList<ClientboundResourcePackPushPacket>(request.packs().size());
        if (request.replace()) {
            this.clearResourcePacks();
        }
        net.minecraft.network.chat.Component prompt = PaperAdventure.asVanilla(request.prompt());
        Iterator iter = request.packs().iterator();
        while (iter.hasNext()) {
            ResourcePackInfo pack = (ResourcePackInfo)iter.next();
            packs.add(new ClientboundResourcePackPushPacket(pack.id(), pack.uri().toASCIIString(), pack.hash(), request.required(), iter.hasNext() ? Optional.empty() : Optional.ofNullable(prompt)));
            if (request.callback() == ResourcePackCallback.noOp()) continue;
            this.getHandle().connection.packCallbacks.put(pack.id(), request.callback());
        }
        this.sendBundle(packs);
        super.sendResourcePacks(request);
    }

    public void removeResourcePacks(UUID id, UUID ... others) {
        if (this.getHandle().connection == null) {
            return;
        }
        this.sendBundle(MonkeyBars.nonEmptyArrayToList(pack -> new ClientboundResourcePackPopPacket(Optional.of(pack)), (Object)id, (Object[])others));
    }

    public void clearResourcePacks() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundResourcePackPopPacket(Optional.empty()));
    }

    public PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        return this.resourcePackStatus;
    }

    public void removeResourcePack(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Resource pack id cannot be null");
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundResourcePackPopPacket(Optional.of(id)));
    }

    public void removeResourcePacks() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundResourcePackPopPacket(Optional.empty()));
    }

    private void handlePushResourcePack(ClientboundResourcePackPushPacket resourcePackPushPacket, boolean resetBeforePush) {
        if (this.getHandle().connection == null) {
            return;
        }
        if (resetBeforePush) {
            this.removeResourcePacks();
        }
        this.getHandle().connection.send(resourcePackPushPacket);
    }

    public void addChannel(String channel) {
        Preconditions.checkState((DISABLE_CHANNEL_LIMIT || this.channels.size() < 128 ? 1 : 0) != 0, (Object)"Cannot register channel. Too many channels registered!");
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((org.bukkit.entity.Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel((String)channel))) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((org.bukkit.entity.Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().connection == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.sendCustomPayload(ResourceLocation.withDefaultNamespace("register"), stream.toByteArray());
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        AbstractContainerMenu container = this.getHandle().containerMenu;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.setData(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().getAbilities().flying;
    }

    public void setFlying(boolean value) {
        boolean needsUpdate;
        boolean bl = needsUpdate = this.getHandle().getAbilities().flying != value;
        if (!this.getAllowFlight()) {
            Preconditions.checkArgument((!value ? 1 : 0) != 0, (Object)"Player is not allowed to fly (check #getAllowFlight())");
        }
        this.getHandle().getAbilities().flying = value;
        if (needsUpdate) {
            this.getHandle().onUpdateAbilities();
        }
    }

    public boolean getAllowFlight() {
        return this.getHandle().getAbilities().mayfly;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().getAbilities().flying = false;
        }
        this.getHandle().getAbilities().mayfly = value;
        this.getHandle().onUpdateAbilities();
    }

    public void setFlyingFallDamage(@NotNull TriState flyingFallDamage) {
        this.getHandle().flyingFallDamage = flyingFallDamage;
    }

    @NotNull
    public TriState hasFlyingFallDamage() {
        return this.getHandle().flyingFallDamage;
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().spawnInvulnerableTime > 0) {
            return Math.max(this.getHandle().spawnInvulnerableTime, this.getHandle().invulnerableTime);
        }
        return this.getHandle().invulnerableTime;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        super.setNoDamageTicks(ticks);
        this.getHandle().spawnInvulnerableTime = ticks;
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        ServerPlayer player = this.getHandle();
        player.getAbilities().flyingSpeed = value / 2.0f;
        player.onUpdateAbilities();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        ServerPlayer player = this.getHandle();
        player.getAbilities().walkingSpeed = value / 2.0f;
        player.onUpdateAbilities();
        this.getHandle().getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(player.getAbilities().walkingSpeed);
    }

    public float getFlySpeed() {
        return this.getHandle().getAbilities().flyingSpeed * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().getAbilities().walkingSpeed * 2.0f;
    }

    private void validateSpeed(float value) {
        Preconditions.checkArgument((value <= 1.0f && value >= -1.0f ? 1 : 0) != 0, (String)"Speed value (%s) need to be between -1f and 1f", (Object)Float.valueOf(value));
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, amount);
        this.getHandle().resetSentInfo();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().resetSentInfo();
    }

    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Preconditions.checkArgument((scoreboard != null ? 1 : 0) != 0, (Object)"Scoreboard cannot be null");
        Preconditions.checkState((this.getHandle().connection != null ? 1 : 0) != 0, (Object)"Cannot set scoreboard yet (invalid player connection)");
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    public void setHealthScale(double value) {
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0, (String)"Health value (%s) must be greater than 0", (Object)value);
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        if (Double.isNaN(health)) {
            return;
        }
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        AttributeMap attributemapserver = this.getHandle().getAttributes();
        Collection<AttributeInstance> set = attributemapserver.getSyncableAttributes();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().connection != null) {
            this.getHandle().connection.send(new ClientboundUpdateAttributesPacket(this.getHandle().getId(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().getEntityData().set(net.minecraft.world.entity.LivingEntity.DATA_HEALTH_ID, Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturation) {
        this.getHandle().connection.send(new ClientboundSetHealthPacket((float)health, foodLevel, saturation));
    }

    public void sendHealthUpdate() {
        FoodData foodData = this.getHandle().getFoodData();
        ClientboundSetHealthPacket packet = new ClientboundSetHealthPacket(this.getScaledHealth(), foodData.getFoodLevel(), foodData.getSaturationLevel());
        if (this.getHandle().queueHealthUpdatePacket) {
            this.getHandle().queuedHealthUpdatePacket = packet;
        } else {
            this.getHandle().connection.send(packet);
        }
    }

    public void injectScaledMaxHealth(Collection<AttributeInstance> collection, boolean force) {
        double healthMod;
        if (!this.scaledHealth && !force) {
            return;
        }
        for (AttributeInstance genericInstance : collection) {
            if (genericInstance.getAttribute() != Attributes.MAX_HEALTH) continue;
            collection.remove(genericInstance);
            break;
        }
        AttributeInstance dummy = new AttributeInstance(Attributes.MAX_HEALTH, attribute -> {});
        double d = healthMod = this.scaledHealth ? this.healthScale : this.getMaxHealth();
        if (healthMod >= 3.4028234663852886E38 || healthMod <= 0.0) {
            healthMod = 20.0;
            this.getServer().getLogger().warning(this.getName() + " tried to crash the server with a large health attribute");
        }
        dummy.setBaseValue(healthMod);
        collection.add(dummy);
    }

    public Entity getSpectatorTarget() {
        net.minecraft.world.entity.Entity followed = this.getHandle().getCamera();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().setCamera(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.getHandle().connection.send(times);
        if (title != null) {
            ClientboundSetTitleTextPacket packetTitle = new ClientboundSetTitleTextPacket(CraftChatMessage.fromString(title)[0]);
            this.getHandle().connection.send(packetTitle);
        }
        if (subtitle != null) {
            ClientboundSetSubtitleTextPacket packetSubtitle = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromString(subtitle)[0]);
            this.getHandle().connection.send(packetSubtitle);
        }
    }

    public void resetTitle() {
        ClientboundClearTitlesPacket packetReset = new ClientboundClearTitlesPacket(true);
        this.getHandle().connection.send(packetReset);
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        ClientboundLevelParticlesPacket packetplayoutworldparticles = new ClientboundLevelParticlesPacket(CraftParticle.createParticleParam(particle, data), force, x, y, z, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().connection.send(packetplayoutworldparticles);
    }

    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        PlayerAdvancements data = this.getHandle().getAdvancements();
        AdvancementProgress progress = data.getOrStartProgress(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public int getClientViewDistance() {
        return this.getHandle().requestedViewDistance() == 0 ? Bukkit.getViewDistance() : this.getHandle().requestedViewDistance();
    }

    public Locale locale() {
        return this.getHandle().adventure$locale;
    }

    public int getPing() {
        return this.getHandle().connection.latency();
    }

    public String getLocale() {
        String locale = this.getHandle().language;
        return locale != null ? locale : "en_us";
    }

    public void setAffectsSpawning(boolean affects) {
        this.getHandle().affectsSpawning = affects;
    }

    public boolean getAffectsSpawning() {
        return this.getHandle().affectsSpawning;
    }

    public void updateCommands() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().server.getCommands().sendCommands(this.getHandle());
    }

    public void openBook(org.bukkit.inventory.ItemStack book) {
        Preconditions.checkArgument((book != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        Preconditions.checkArgument((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"ItemStack Material (%s) must be Material.WRITTEN_BOOK", (Object)book.getType());
        org.bukkit.inventory.ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().openItemGui(CraftItemStack.asNMSCopy(book), InteractionHand.MAIN_HAND);
        this.getInventory().setItemInMainHand(hand);
    }

    public void openSign(Sign sign) {
        this.openSign(sign, Side.FRONT);
    }

    @Override
    public void openSign(@NotNull Sign sign, @NotNull Side side) {
        CraftSign.openSign(sign, this, side);
    }

    public void showDemoScreen() {
        if (this.getHandle().connection == null) {
            return;
        }
        this.getHandle().connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.DEMO_EVENT, 0.0f));
    }

    public boolean isAllowingServerListings() {
        return this.getHandle().allowsListing();
    }

    public Component displayName() {
        return this.getHandle().adventure$displayName;
    }

    public void displayName(Component displayName) {
        this.getHandle().adventure$displayName = displayName != null ? displayName : Component.text((String)this.getName());
        this.getHandle().displayName = null;
    }

    public void deleteMessage(SignedMessage.Signature signature) {
        if (this.getHandle().connection == null) {
            return;
        }
        MessageSignature sig = new MessageSignature(signature.bytes());
        this.getHandle().connection.send(new ClientboundDeleteChatPacket(new MessageSignature.Packed(sig)));
    }

    private ChatType.Bound toHandle(ChatType.Bound boundChatType) {
        Registry<ChatType> chatTypeRegistry = this.getHandle().level().registryAccess().registryOrThrow(Registries.CHAT_TYPE);
        return new ChatType.Bound(chatTypeRegistry.getHolderOrThrow(ResourceKey.create(Registries.CHAT_TYPE, PaperAdventure.asVanilla(boundChatType.type().key()))), PaperAdventure.asVanilla(boundChatType.name()), Optional.ofNullable(PaperAdventure.asVanilla(boundChatType.target())));
    }

    public void sendMessage(Component message, ChatType.Bound boundChatType) {
        if (this.getHandle().connection == null) {
            return;
        }
        net.minecraft.network.chat.Component component = PaperAdventure.asVanilla(message);
        this.getHandle().sendChatMessage(new OutgoingChatMessage.Disguised(component), this.getHandle().isTextFilteringEnabled(), this.toHandle(boundChatType));
    }

    public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
        Component message;
        if (this.getHandle().connection == null) {
            return;
        }
        if (signedMessage instanceof PlayerChatMessage.AdventureView) {
            PlayerChatMessage.AdventureView view = (PlayerChatMessage.AdventureView)signedMessage;
            this.getHandle().sendChatMessage(OutgoingChatMessage.create(view.playerChatMessage()), this.getHandle().isTextFilteringEnabled(), this.toHandle(boundChatType));
            return;
        }
        Object object = message = signedMessage.unsignedContent() == null ? Component.text((String)signedMessage.message()) : signedMessage.unsignedContent();
        if (signedMessage.isSystem()) {
            this.sendMessage(message, boundChatType);
        } else {
            super.sendMessage(signedMessage, boundChatType);
        }
    }

    @Deprecated(forRemoval=true)
    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.getHandle().connection == null) {
            return;
        }
        Registry<ChatType> chatTypeRegistry = this.getHandle().level().registryAccess().registryOrThrow(Registries.CHAT_TYPE);
        this.getHandle().connection.send(new ClientboundSystemChatPacket(message, false));
    }

    public void sendActionBar(Component message) {
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket(PaperAdventure.asVanillaNullToEmpty(message));
        this.getHandle().connection.send(packet);
    }

    public void sendPlayerListHeader(Component header) {
        this.playerListHeader = header;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListFooter(Component footer) {
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.playerListHeader = header;
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    private void adventure$sendPlayerListHeaderAndFooter() {
        ServerGamePacketListenerImpl connection = this.getHandle().connection;
        if (connection == null) {
            return;
        }
        ClientboundTabListPacket packet = new ClientboundTabListPacket(PaperAdventure.asVanillaNullToEmpty(this.playerListHeader), PaperAdventure.asVanillaNullToEmpty(this.playerListFooter));
        connection.send(packet);
    }

    public void showTitle(net.kyori.adventure.title.Title title) {
        ServerGamePacketListenerImpl connection = this.getHandle().connection;
        Title.Times times = title.times();
        if (times != null) {
            connection.send(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        }
        ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket(PaperAdventure.asVanilla(title.subtitle()));
        connection.send(sp);
        ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket(PaperAdventure.asVanilla(title.title()));
        connection.send(tp);
    }

    public <T> void sendTitlePart(TitlePart<T> part, T value) {
        Objects.requireNonNull(part, "part");
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket(PaperAdventure.asVanilla((Component)value));
            this.getHandle().connection.send(tp);
        } else if (part == TitlePart.SUBTITLE) {
            ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket(PaperAdventure.asVanilla((Component)value));
            this.getHandle().connection.send(sp);
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.getHandle().connection.send(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart");
        }
    }

    private static int ticks(Duration duration) {
        if (duration == null) {
            return -1;
        }
        return (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.getHandle().connection.send(new ClientboundClearTitlesPacket(false));
    }

    @NotNull
    public Iterable<? extends BossBar> activeBossBars() {
        if (this.activeBossBars != null) {
            return Collections.unmodifiableSet(this.activeBossBars);
        }
        return Set.of();
    }

    public void showBossBar(BossBar bar) {
        ((BossBarImplementationImpl)BossBarImplementation.get((BossBar)bar, BossBarImplementationImpl.class)).playerShow(this);
        if (this.activeBossBars == null) {
            this.activeBossBars = new HashSet<BossBar>();
        }
        this.activeBossBars.add(bar);
    }

    public void hideBossBar(BossBar bar) {
        ((BossBarImplementationImpl)BossBarImplementation.get((BossBar)bar, BossBarImplementationImpl.class)).playerHide(this);
        if (this.activeBossBars != null) {
            this.activeBossBars.remove(bar);
            if (this.activeBossBars.isEmpty()) {
                this.activeBossBars = null;
            }
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        Vec3 pos = this.getHandle().position();
        this.playSound(sound, pos.x, pos.y, pos.z);
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x, double y, double z) {
        this.getHandle().connection.send(PaperAdventure.asSoundPacket(sound, x, y, z, sound.seed().orElseGet(this.getHandle().getRandom()::nextLong), null));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        net.minecraft.world.entity.Entity entity;
        if (emitter == Sound.Emitter.self()) {
            entity = this.getHandle();
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            entity = craftEntity.getHandle();
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + String.valueOf(emitter));
        }
        this.getHandle().connection.send(PaperAdventure.asSoundPacket(sound, entity, sound.seed().orElseGet(this.getHandle().getRandom()::nextLong), null));
    }

    public void stopSound(SoundStop stop) {
        this.getHandle().connection.send(new ClientboundStopSoundPacket(PaperAdventure.asVanillaNullable(stop.sound()), PaperAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(Book book) {
        Locale locale = this.getHandle().adventure$locale;
        ItemStack item = PaperAdventure.asItemStack(book, locale);
        ServerPlayer player = this.getHandle();
        ServerGamePacketListenerImpl connection = player.connection;
        Inventory inventory = player.getInventory();
        int slot = inventory.items.size() + inventory.selected;
        int stateId = this.getHandle().containerMenu.getStateId();
        connection.send(new ClientboundContainerSetSlotPacket(0, stateId, slot, item));
        connection.send(new ClientboundOpenBookPacket(InteractionHand.MAIN_HAND));
        connection.send(new ClientboundContainerSetSlotPacket(0, stateId, slot, inventory.getSelected()));
    }

    @Override
    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.DISPLAY_NAME, this::displayName).withDynamic(Identity.NAME, this::getName).withDynamic(Identity.UUID, this::getUniqueId).withStatic(PermissionChecker.POINTER, arg_0 -> ((CraftPlayer)this).permissionValue(arg_0)).withDynamic(Identity.LOCALE, this::locale).build();
        }
        return this.adventure$pointers;
    }

    public float getCooldownPeriod() {
        return this.getHandle().getCurrentItemAttackStrengthDelay();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        return this.getHandle().getAttackStrengthScale(adjustTicks);
    }

    public void resetCooldown() {
        this.getHandle().resetAttackStrengthTicker();
    }

    public String getClientBrandName() {
        return this.getHandle().clientBrandName;
    }

    public void showElderGuardian(boolean silent) {
        if (this.getHandle().connection != null) {
            this.getHandle().connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.GUARDIAN_ELDER_EFFECT, silent ? 0.0f : 1.0f));
        }
    }

    public int getWardenWarningCooldown() {
        return this.getHandle().wardenSpawnTracker.cooldownTicks;
    }

    public void setWardenWarningCooldown(int cooldown) {
        this.getHandle().wardenSpawnTracker.cooldownTicks = Math.max(cooldown, 0);
    }

    public int getWardenTimeSinceLastWarning() {
        return this.getHandle().wardenSpawnTracker.ticksSinceLastWarning;
    }

    public void setWardenTimeSinceLastWarning(int time) {
        this.getHandle().wardenSpawnTracker.ticksSinceLastWarning = time;
    }

    public int getWardenWarningLevel() {
        return this.getHandle().wardenSpawnTracker.getWarningLevel();
    }

    public void setWardenWarningLevel(int warningLevel) {
        this.getHandle().wardenSpawnTracker.setWarningLevel(warningLevel);
    }

    public void increaseWardenWarningLevel() {
        this.getHandle().wardenSpawnTracker.increaseWarningLevel();
    }

    public Duration getIdleDuration() {
        return Duration.ofMillis(Util.getMillis() - this.getHandle().getLastActionTime());
    }

    public void resetIdleDuration() {
        this.getHandle().resetLastActionTime();
    }

    public Set<Long> getSentChunkKeys() {
        AsyncCatcher.catchOp("accessing sent chunks");
        return LongSets.unmodifiable((LongSet)this.getHandle().moonrise$getChunkLoader().getSentChunksRaw().clone());
    }

    public Set<Chunk> getSentChunks() {
        AsyncCatcher.catchOp("accessing sent chunks");
        LongOpenHashSet rawChunkKeys = this.getHandle().moonrise$getChunkLoader().getSentChunksRaw();
        ObjectOpenHashSet chunks = new ObjectOpenHashSet(rawChunkKeys.size());
        World world = this.getWorld();
        LongIterator iter = this.getHandle().moonrise$getChunkLoader().getSentChunksRaw().longIterator();
        while (iter.hasNext()) {
            chunks.add((Object)world.getChunkAt(iter.nextLong(), false));
        }
        return ObjectSets.unmodifiable((ObjectSet)chunks);
    }

    public boolean isChunkSent(long chunkKey) {
        AsyncCatcher.catchOp("accessing sent chunks");
        return this.getHandle().moonrise$getChunkLoader().getSentChunksRaw().contains(chunkKey);
    }

    public Player.Spigot spigot() {
        return this.spigot;
    }

    public int getViewDistance() {
        return ChunkSystem.getLoadViewDistance(this.getHandle()) - 1;
    }

    public void setViewDistance(int viewDistance) {
        this.getHandle().moonrise$getViewDistanceHolder().setLoadViewDistance(viewDistance + 1);
    }

    public int getSimulationDistance() {
        return ChunkSystem.getTickViewDistance(this.getHandle());
    }

    public void setSimulationDistance(int simulationDistance) {
        this.getHandle().moonrise$getViewDistanceHolder().setTickViewDistance(simulationDistance);
    }

    public int getSendViewDistance() {
        return ChunkSystem.getSendViewDistance(this.getHandle());
    }

    public void setSendViewDistance(int viewDistance) {
        this.getHandle().moonrise$getViewDistanceHolder().setSendViewDistance(viewDistance);
    }

    public void sendEntityEffect(EntityEffect effect, Entity target) {
        if (this.getHandle().connection == null || !effect.isApplicableTo(target)) {
            return;
        }
        this.getHandle().connection.send(new ClientboundEntityEventPacket(((CraftEntity)target).getHandle(), effect.getData()));
    }

    public boolean simplifyContainerDesyncCheck() {
        return this.simplifyContainerDesyncCheck;
    }

    public void setSimplifyContainerDesyncCheck(boolean simplifyContainerDesyncCheck) {
        this.simplifyContainerDesyncCheck = simplifyContainerDesyncCheck;
    }

    public record CookieFuture(ResourceLocation key, CompletableFuture<byte[]> future) {
    }

    public static interface TransferCookieConnection {
        public boolean isTransferred();

        public ConnectionProtocol getProtocol();

        public void sendPacket(Packet<?> var1);

        public void kickPlayer(net.minecraft.network.chat.Component var1, PlayerKickEvent.Cause var2);
    }

    private record ChunkSectionChanges(ShortSet positions, List<BlockState> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<BlockState>());
        }
    }
}

