/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.Shulker;
import org.bukkit.DyeColor;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEnemy;
import org.bukkit.craftbukkit.entity.CraftGolem;

public class CraftShulker
extends CraftGolem
implements org.bukkit.entity.Shulker,
CraftEnemy {
    public CraftShulker(CraftServer server, Shulker entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftShulker";
    }

    @Override
    public Shulker getHandle() {
        return (Shulker)this.entity;
    }

    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)this.getHandle().getEntityData().get(Shulker.DATA_COLOR_ID));
    }

    public void setColor(DyeColor color) {
        this.getHandle().getEntityData().set(Shulker.DATA_COLOR_ID, color == null ? (byte)16 : (byte)color.getWoolData());
    }

    public float getPeek() {
        return (float)this.getHandle().getRawPeekAmount() / 100.0f;
    }

    public void setPeek(float value) {
        Preconditions.checkArgument((value >= 0.0f && value <= 1.0f ? 1 : 0) != 0, (Object)"value needs to be in between or equal to 0 and 1");
        this.getHandle().setRawPeekAmount((int)(value * 100.0f));
    }

    public BlockFace getAttachedFace() {
        return CraftBlock.notchToBlockFace(this.getHandle().getAttachFace());
    }

    public void setAttachedFace(BlockFace face) {
        Preconditions.checkNotNull((Object)face, (Object)"face cannot be null");
        Preconditions.checkArgument((boolean)face.isCartesian(), (String)"%s is not a valid block face to attach a shulker to, a cartesian block face is expected", (Object)face);
        this.getHandle().setAttachFace(CraftBlock.blockFaceToNotch(face));
    }
}

