/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftThrowableProjectile;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.SplashPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class CraftThrownPotion
extends CraftThrowableProjectile
implements org.bukkit.entity.ThrownPotion,
SplashPotion,
LingeringPotion {
    public CraftThrownPotion(CraftServer server, ThrownPotion entity) {
        super(server, entity);
    }

    public Collection<PotionEffect> getEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffectInstance effect : this.getHandle().getItem().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).getAllEffects()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().getItem());
    }

    @Override
    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        PotionMeta meta = item.getType() == Material.LINGERING_POTION || item.getType() == Material.SPLASH_POTION ? null : this.getPotionMeta();
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item));
        if (meta != null) {
            this.setPotionMeta(meta);
        }
    }

    public PotionMeta getPotionMeta() {
        return (PotionMeta)CraftItemStack.getItemMeta(this.getHandle().getItem(), (ItemType)ItemType.SPLASH_POTION);
    }

    public void setPotionMeta(PotionMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().getItem();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().setItem(item);
    }

    public void splash() {
        this.getHandle().splash(null);
    }

    @Override
    public ThrownPotion getHandle() {
        return (ThrownPotion)this.entity;
    }
}

