/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.LevelAccessor;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;

public class CraftBlockInventoryHolder
implements BlockInventoryHolder {
    private final Block block;
    private final Inventory inventory;

    public CraftBlockInventoryHolder(LevelAccessor world, BlockPos pos, Container inv) {
        this.block = CraftBlock.at(world, pos);
        this.inventory = new CraftInventory(inv);
    }

    public CraftBlockInventoryHolder(ContainerLevelAccess levelAccess, Inventory inventory) {
        Preconditions.checkArgument((boolean)levelAccess.isBlock());
        this.block = CraftBlock.at(levelAccess.getWorld(), levelAccess.getPosition());
        this.inventory = inventory;
    }

    public Block getBlock() {
        return this.block;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

