/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import org.bukkit.Material;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CraftInventoryPlayer
extends CraftInventory
implements PlayerInventory,
EntityEquipment {
    public CraftInventoryPlayer(Inventory inventory) {
        super(inventory);
    }

    @Override
    public Inventory getInventory() {
        return (Inventory)this.inventory;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.asCraftMirror(this.getInventory().items);
    }

    public ItemStack getItemInMainHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().getSelected());
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItem(this.getHeldItemSlot(), item);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setItemInMainHand(item);
    }

    public ItemStack getItemInOffHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().offhand.get(0));
    }

    public void setItemInOffHand(ItemStack item) {
        ItemStack[] extra = this.getExtraContents();
        extra[0] = item;
        this.setExtraContents(extra);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setItemInOffHand(item);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < 0 || index > 40) {
            throw new ArrayIndexOutOfBoundsException("Index must be between 0 and 40");
        }
        super.setItem(index, item);
        if (this.getHolder() == null) {
            return;
        }
        ServerPlayer player = ((CraftPlayer)this.getHolder()).getHandle();
        if (player.connection == null) {
            return;
        }
        if (index < Inventory.getSelectionSize()) {
            index += 36;
        } else if (index > 39) {
            index += 5;
        } else if (index > 35) {
            index = 8 - (index - 36);
        }
        player.connection.send(new ClientboundContainerSetSlotPacket(player.inventoryMenu.containerId, player.inventoryMenu.incrementStateId(), index, CraftItemStack.asNMSCopy(item)));
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            case BODY: {
                throw new IllegalArgumentException("BODY is not valid for players!");
            }
            default: {
                throw new IllegalArgumentException("Not implemented. This is a bug");
            }
        }
    }

    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        this.setItem(slot, item);
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                return this.getItemInMainHand();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
            case FEET: {
                return Objects.requireNonNullElseGet(this.getBoots(), () -> new ItemStack(Material.AIR));
            }
            case LEGS: {
                return Objects.requireNonNullElseGet(this.getLeggings(), () -> new ItemStack(Material.AIR));
            }
            case CHEST: {
                return Objects.requireNonNullElseGet(this.getChestplate(), () -> new ItemStack(Material.AIR));
            }
            case HEAD: {
                return Objects.requireNonNullElseGet(this.getHelmet(), () -> new ItemStack(Material.AIR));
            }
            case BODY: {
                throw new IllegalArgumentException("BODY is not valid for players!");
            }
        }
        throw new IllegalArgumentException("Not implemented. This is a bug");
    }

    public int getHeldItemSlot() {
        return this.getInventory().selected;
    }

    public void setHeldItemSlot(int slot) {
        Preconditions.checkArgument((slot >= 0 && slot < Inventory.getSelectionSize() ? 1 : 0) != 0, (String)"Slot (%s) is not between 0 and %s inclusive", (int)slot, (int)(Inventory.getSelectionSize() - 1));
        this.getInventory().selected = slot;
        ((CraftPlayer)this.getHolder()).getHandle().connection.send(new ClientboundSetCarriedItemPacket(slot));
    }

    public ItemStack getHelmet() {
        return this.getItem(this.getSize() - 2);
    }

    public ItemStack getChestplate() {
        return this.getItem(this.getSize() - 3);
    }

    public ItemStack getLeggings() {
        return this.getItem(this.getSize() - 4);
    }

    public ItemStack getBoots() {
        return this.getItem(this.getSize() - 5);
    }

    public void setHelmet(ItemStack helmet) {
        this.setItem(this.getSize() - 2, helmet);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setHelmet(helmet);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setItem(this.getSize() - 3, chestplate);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setChestplate(chestplate);
    }

    public void setLeggings(ItemStack leggings) {
        this.setItem(this.getSize() - 4, leggings);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setLeggings(leggings);
    }

    public void setBoots(ItemStack boots) {
        this.setItem(this.getSize() - 5, boots);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setBoots(boots);
    }

    public ItemStack[] getArmorContents() {
        return this.asCraftMirror(this.getInventory().armor);
    }

    private void setSlots(ItemStack[] items, int baseSlot, int length) {
        if (items == null) {
            items = new ItemStack[length];
        }
        Preconditions.checkArgument((items.length <= length ? 1 : 0) != 0, (String)"items.length must be <= %s", (int)length);
        for (int i = 0; i < length; ++i) {
            if (i >= items.length) {
                this.setItem(baseSlot + i, null);
                continue;
            }
            this.setItem(baseSlot + i, items[i]);
        }
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setSlots(items, 0, this.getInventory().items.size());
    }

    public void setArmorContents(ItemStack[] items) {
        this.setSlots(items, this.getInventory().items.size(), this.getInventory().armor.size());
    }

    public ItemStack[] getExtraContents() {
        return this.asCraftMirror(this.getInventory().offhand);
    }

    public void setExtraContents(ItemStack[] items) {
        this.setSlots(items, this.getInventory().items.size() + this.getInventory().armor.size(), this.getInventory().offhand.size());
    }

    public HumanEntity getHolder() {
        return (HumanEntity)this.inventory.getOwner();
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return 1.0f;
    }

    public void setItemInMainHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getItemInOffHandDropChance() {
        return 1.0f;
    }

    public void setItemInOffHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getHelmetDropChance() {
        return 1.0f;
    }

    public void setHelmetDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getChestplateDropChance() {
        return 1.0f;
    }

    public void setChestplateDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getLeggingsDropChance() {
        return 1.0f;
    }

    public void setLeggingsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getBootsDropChance() {
        return 1.0f;
    }

    public void setBootsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    public float getDropChance(EquipmentSlot slot) {
        return 1.0f;
    }

    public void setDropChance(EquipmentSlot slot, float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }
}

