/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.bukkit.craftbukkit.inventory.CraftMerchantRecipe;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.MerchantRecipe;

public interface CraftMerchant
extends org.bukkit.inventory.Merchant {
    public Merchant getMerchant();

    default public List<MerchantRecipe> getRecipes() {
        return List.copyOf(Lists.transform((List)this.getMerchant().getOffers(), (Function)new Function<MerchantOffer, MerchantRecipe>(this){

            public MerchantRecipe apply(MerchantOffer recipe) {
                return recipe.asBukkit();
            }
        }));
    }

    default public void setRecipes(List<MerchantRecipe> recipes) {
        MerchantOffers recipesList = this.getMerchant().getOffers();
        recipesList.clear();
        for (MerchantRecipe recipe : recipes) {
            recipesList.add(CraftMerchantRecipe.fromBukkit(recipe).toMinecraft());
        }
    }

    default public MerchantRecipe getRecipe(int i) {
        return ((MerchantOffer)this.getMerchant().getOffers().get(i)).asBukkit();
    }

    default public void setRecipe(int i, MerchantRecipe merchantRecipe) {
        this.getMerchant().getOffers().set(i, CraftMerchantRecipe.fromBukkit(merchantRecipe).toMinecraft());
    }

    default public int getRecipeCount() {
        return this.getMerchant().getOffers().size();
    }

    default public boolean isTrading() {
        return this.getTrader() != null;
    }

    default public HumanEntity getTrader() {
        Player eh = this.getMerchant().getTradingPlayer();
        return eh == null ? null : eh.getBukkitEntity();
    }
}

