/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.potion;

import com.google.common.base.Preconditions;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.potion.CraftPotionEffectTypeCategory;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionEffectTypeCategory;
import org.jetbrains.annotations.NotNull;

public class CraftPotionEffectType
extends PotionEffectType
implements Handleable<MobEffect>,
PaperFeatureDependent {
    private final NamespacedKey key;
    private final MobEffect handle;
    private final int id;

    public static PotionEffectType minecraftHolderToBukkit(Holder<MobEffect> minecraft) {
        return CraftPotionEffectType.minecraftToBukkit(minecraft.value());
    }

    public static PotionEffectType minecraftToBukkit(MobEffect minecraft) {
        return (PotionEffectType)CraftRegistry.minecraftToBukkit(minecraft, Registries.MOB_EFFECT, Registry.EFFECT);
    }

    public static MobEffect bukkitToMinecraft(PotionEffectType bukkit) {
        return (MobEffect)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<MobEffect> bukkitToMinecraftHolder(PotionEffectType bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.MOB_EFFECT);
    }

    public CraftPotionEffectType(NamespacedKey key, MobEffect handle) {
        this.key = key;
        this.handle = handle;
        this.id = CraftRegistry.getMinecraftRegistry(Registries.MOB_EFFECT).getId(handle) + 1;
    }

    @Override
    public MobEffect getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public double getDurationModifier() {
        return 1.0;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return switch (this.getId()) {
            case 1 -> "SPEED";
            case 2 -> "SLOW";
            case 3 -> "FAST_DIGGING";
            case 4 -> "SLOW_DIGGING";
            case 5 -> "INCREASE_DAMAGE";
            case 6 -> "HEAL";
            case 7 -> "HARM";
            case 8 -> "JUMP";
            case 9 -> "CONFUSION";
            case 10 -> "REGENERATION";
            case 11 -> "DAMAGE_RESISTANCE";
            case 12 -> "FIRE_RESISTANCE";
            case 13 -> "WATER_BREATHING";
            case 14 -> "INVISIBILITY";
            case 15 -> "BLINDNESS";
            case 16 -> "NIGHT_VISION";
            case 17 -> "HUNGER";
            case 18 -> "WEAKNESS";
            case 19 -> "POISON";
            case 20 -> "WITHER";
            case 21 -> "HEALTH_BOOST";
            case 22 -> "ABSORPTION";
            case 23 -> "SATURATION";
            case 24 -> "GLOWING";
            case 25 -> "LEVITATION";
            case 26 -> "LUCK";
            case 27 -> "UNLUCK";
            case 28 -> "SLOW_FALLING";
            case 29 -> "CONDUIT_POWER";
            case 30 -> "DOLPHINS_GRACE";
            case 31 -> "BAD_OMEN";
            case 32 -> "HERO_OF_THE_VILLAGE";
            case 33 -> "DARKNESS";
            default -> this.getKey().toString();
        };
    }

    @NotNull
    public PotionEffect createEffect(int duration, int amplifier) {
        return new PotionEffect((PotionEffectType)this, this.isInstant() ? 1 : (int)((double)duration * this.getDurationModifier()), amplifier);
    }

    public boolean isInstant() {
        return this.handle.isInstantenous();
    }

    public PotionEffectTypeCategory getCategory() {
        return CraftPotionEffectTypeCategory.minecraftToBukkit(this.handle.getCategory());
    }

    public Color getColor() {
        return Color.fromRGB((int)this.handle.getColor());
    }

    @NotNull
    public String getTranslationKey() {
        return this.handle.getDescriptionId();
    }

    public Map<Attribute, AttributeModifier> getEffectAttributes() {
        HashMap attributeMap = new HashMap();
        this.handle.attributeModifiers.forEach((attribute, attributeModifier) -> attributeMap.put(CraftAttribute.minecraftHolderToBukkit(attribute), CraftAttributeInstance.convert(attributeModifier.create(0))));
        return Map.copyOf(attributeMap);
    }

    public double getAttributeModifierAmount(Attribute attribute, int effectAmplifier) {
        Preconditions.checkArgument((effectAmplifier >= 0 ? 1 : 0) != 0, (Object)"effectAmplifier must be greater than or equal to 0");
        Holder<net.minecraft.world.entity.ai.attributes.Attribute> nmsAttribute = CraftAttribute.bukkitToMinecraftHolder(attribute);
        Preconditions.checkArgument((boolean)this.handle.attributeModifiers.containsKey(nmsAttribute), (Object)(String.valueOf(attribute) + " is not present on " + String.valueOf(this.getKey())));
        return this.handle.attributeModifiers.get(nmsAttribute).create(effectAmplifier).amount();
    }

    public PotionEffectType.Category getEffectCategory() {
        return CraftPotionEffectType.fromNMS(this.handle.getCategory());
    }

    public String translationKey() {
        return this.handle.getDescriptionId();
    }

    public static PotionEffectType.Category fromNMS(MobEffectCategory mobEffectInfo) {
        return switch (mobEffectInfo) {
            default -> throw new MatchException(null, null);
            case MobEffectCategory.BENEFICIAL -> PotionEffectType.Category.BENEFICIAL;
            case MobEffectCategory.HARMFUL -> PotionEffectType.Category.HARMFUL;
            case MobEffectCategory.NEUTRAL -> PotionEffectType.Category.NEUTRAL;
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PotionEffectType)) {
            return false;
        }
        return this.getKey().equals((Object)((PotionEffectType)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftPotionEffectType[" + String.valueOf(this.getKey()) + "]";
    }
}

