/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import co.aikar.timings.TimingsExport;
import com.destroystokyo.paper.PaperVersionFetcher;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.attribute.UnmodifiableAttributeMap;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.inventory.tooltip.TooltipContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.PaperLifecycleEventManager;
import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.NamedRegistryKeySetImpl;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftRegionAccessor;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.damage.CraftDamageSourceBuilder;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.CraftLegacy;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.Commodore;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final CraftMagicNumbers INSTANCE = new CraftMagicNumbers();
    public static final boolean DISABLE_OLD_API_SUPPORT = Boolean.getBoolean("paper.disableOldApiSupport");
    private final Commodore commodore = new Commodore();
    private static final Map<Block, Material> BLOCK_MATERIAL = new HashMap<Block, Material>();
    private static final Map<Item, Material> ITEM_MATERIAL = new HashMap<Item, Material>();
    private static final Map<Material, Item> MATERIAL_ITEM = new HashMap<Material, Item>();
    private static final Map<Material, Block> MATERIAL_BLOCK = new HashMap<Material, Block>();

    private CraftMagicNumbers() {
    }

    public ComponentFlattener componentFlattener() {
        return PaperAdventure.FLATTENER;
    }

    public GsonComponentSerializer colorDownsamplingGsonComponentSerializer() {
        return GsonComponentSerializer.colorDownsamplingGson();
    }

    public GsonComponentSerializer gsonComponentSerializer() {
        return GsonComponentSerializer.gson();
    }

    public PlainComponentSerializer plainComponentSerializer() {
        return PaperAdventure.PLAIN;
    }

    public PlainTextComponentSerializer plainTextSerializer() {
        return PlainTextComponentSerializer.plainText();
    }

    public LegacyComponentSerializer legacyComponentSerializer() {
        return LegacyComponentSerializer.legacySection();
    }

    public Component resolveWithContext(Component component, CommandSender context, Entity scoreboardSubject, boolean bypassPermissions) throws IOException {
        return PaperAdventure.resolveWithContext(component, context, scoreboardSubject, bypassPermissions);
    }

    public static BlockState getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static BlockState getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(BlockState data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.getBlock())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static Item getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(Item item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(Block block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(Item item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Item getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static Block getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static ResourceLocation key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    public void reportTimings() {
        TimingsExport.reportTimings();
    }

    public static byte toLegacyData(BlockState data) {
        return CraftLegacy.toLegacyData(data);
    }

    public Commodore getCommodore() {
        return this.commodore;
    }

    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic<StringTag> name = new Dynamic<StringTag>(NbtOps.INSTANCE, StringTag.valueOf("minecraft:" + material.toLowerCase(Locale.ROOT)));
        if (name.equals((Object)(converted = DataFixers.getDataFixer().update(References.ITEM_NAME, name, version, this.getDataVersion())))) {
            converted = DataFixers.getDataFixer().update(References.BLOCK_NAME, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    public String getMappingsVersion() {
        return "7092ff1ff9352ad7e2260dc150e6a3ec";
    }

    public int getDataVersion() {
        return SharedConstants.getCurrentVersion().getDataVersion().getVersion();
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.applyComponents(new ItemParser(Commands.createValidationContext(MinecraftServer.getDefaultRegistryAccess())).parse(new StringReader(arguments)).components());
        }
        catch (CommandSyntaxException ex) {
            LogUtils.getClassLogger().error("Exception modifying ItemStack", new Throwable(ex));
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().getWorldPath(LevelResource.DATAPACK_DIR).toFile(), "bukkit");
    }

    public org.bukkit.advancement.Advancement loadAdvancement(NamespacedKey key, String advancement) {
        Preconditions.checkArgument((Bukkit.getAdvancement((NamespacedKey)key) == null ? 1 : 0) != 0, (String)"Advancement %s already exists", (Object)key);
        ResourceLocation minecraftkey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = (JsonElement)ServerAdvancementManager.GSON.fromJson(advancement, JsonElement.class);
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext(JsonOps.INSTANCE);
        Advancement nms = (Advancement)Advancement.CODEC.parse(ops, (Object)jsonelement).getOrThrow(JsonParseException::new);
        if (nms != null) {
            org.bukkit.advancement.Advancement bukkit;
            AdvancementNode root;
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            mapBuilder.putAll(MinecraftServer.getServer().getAdvancements().advancements);
            AdvancementHolder holder = new AdvancementHolder(minecraftkey, nms);
            mapBuilder.put((Object)minecraftkey, (Object)holder);
            MinecraftServer.getServer().getAdvancements().advancements = mapBuilder.build();
            AdvancementTree tree = MinecraftServer.getServer().getAdvancements().tree();
            tree.addAll(List.of(holder));
            AdvancementNode node = tree.get(minecraftkey);
            if (node != null && (root = node.root()).holder().value().display().isPresent()) {
                TreeNodePosition.run(root);
            }
            if ((bukkit = Bukkit.getAdvancement((NamespacedKey)key)) != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + String.valueOf(key), ex);
                }
                MinecraftServer.getServer().getPlayerList().getPlayers().forEach(player -> {
                    player.getAdvancements().reload(MinecraftServer.getServer().getAdvancements());
                    player.getAdvancements().flushDirty((ServerPlayer)player);
                });
                return bukkit;
            }
        }
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(pdf.getAPIVersion());
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        if (toCheck.isNewerThan(ApiVersion.CURRENT)) {
            throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
        }
        if (toCheck.isOlderThan(minimumVersion)) {
            throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
        if (!DISABLE_OLD_API_SUPPORT && toCheck.isOlderThan(ApiVersion.FLATTENING)) {
            CraftLegacy.init();
        }
        if (toCheck == ApiVersion.NONE) {
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        if (DISABLE_OLD_API_SUPPORT) {
            return ReflectionRemapper.processClass(clazz);
        }
        try {
            clazz = this.commodore.convert(clazz, pdf.getName(), ApiVersion.getOrCreateVersion(pdf.getAPIVersion()), ((CraftServer)Bukkit.getServer()).activeCompatibilities);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        ItemType item = material.asItemType();
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)(String.valueOf(material) + " is not an item and does not have default attributes"));
        return item.getDefaultAttributeModifiers(slot);
    }

    public CreativeCategory getCreativeCategory(Material material) {
        return material.getCreativeCategory();
    }

    public String getBlockTranslationKey(Material material) {
        return material.getBlockTranslationKey();
    }

    public String getItemTranslationKey(Material material) {
        return material.getItemTranslationKey();
    }

    public String getTranslationKey(org.bukkit.entity.EntityType entityType) {
        Preconditions.checkArgument((entityType.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)entityType);
        return EntityType.byString(entityType.getName()).map(EntityType::getDescriptionId).orElseThrow();
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.getItem().getDescriptionId(nmsItemStack);
    }

    public boolean isSupportedApiVersion(String apiVersion) {
        if (apiVersion == null) {
            return false;
        }
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(apiVersion);
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        return !toCheck.isNewerThan(ApiVersion.CURRENT) && !toCheck.isOlderThan(minimumVersion);
    }

    public String getTranslationKey(Attribute attribute) {
        return CraftAttribute.bukkitToMinecraft(attribute).getDescriptionId();
    }

    public PotionType.InternalPotionData getInternalPotionData(NamespacedKey namespacedKey) {
        Potion potionRegistry = (Potion)CraftRegistry.getMinecraftRegistry(Registries.POTION).getOptional(CraftNamespacedKey.toMinecraft(namespacedKey)).orElseThrow();
        return new CraftPotionType(namespacedKey, potionRegistry);
    }

    public DamageEffect getDamageEffect(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        return CraftDamageEffect.getById(key);
    }

    public DamageSource.Builder createDamageSourceBuilder(DamageType damageType) {
        return new CraftDamageSourceBuilder(damageType);
    }

    public String getTimingsServerName() {
        return GlobalConfiguration.get().timings.serverName;
    }

    public VersionFetcher getVersionFetcher() {
        return new PaperVersionFetcher();
    }

    public byte[] serializeItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"null cannot be serialized");
        Preconditions.checkArgument((item.getType() != Material.AIR ? 1 : 0) != 0, (Object)"air cannot be serialized");
        return this.serializeNbtToBytes((CompoundTag)(item instanceof CraftItemStack ? ((CraftItemStack)item).handle : CraftItemStack.asNMSCopy(item)).save(MinecraftServer.getServer().registryAccess()));
    }

    public ItemStack deserializeItem(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        CompoundTag compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.getInt("DataVersion");
        compound = MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, compound, dataVersion, this.getDataVersion());
        return CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.parse(MinecraftServer.getServer().registryAccess(), compound).orElseThrow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject serializeItemAsJson(ItemStack itemStack) {
        JsonObject item;
        Preconditions.checkNotNull((Object)itemStack, (Object)"Cannot serialize empty ItemStack");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot serialize empty ItemStack");
        RegistryAccess.Frozen reg = MinecraftServer.getServer().registryAccess();
        RegistryOps ops = reg.createSerializationContext(JsonOps.INSTANCE);
        CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(true);
        try {
            item = ((JsonElement)net.minecraft.world.item.ItemStack.CODEC.encodeStart(ops, (Object)CraftItemStack.unwrap(itemStack)).getOrThrow()).getAsJsonObject();
        }
        finally {
            CustomData.SERIALIZE_CUSTOM_AS_SNBT.set(false);
        }
        item.addProperty("DataVersion", (Number)this.getDataVersion());
        return item;
    }

    public ItemStack deserializeItemFromJson(JsonObject data) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        int dataVersion = data.get("DataVersion").getAsInt();
        int currentVersion = INSTANCE.getDataVersion();
        data = MCDataConverter.convertJson(MCTypeRegistry.ITEM_STACK, data, false, dataVersion, currentVersion);
        RegistryOps ops = MinecraftServer.getServer().registryAccess().createSerializationContext(JsonOps.INSTANCE);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse(ops, (Object)data).getOrThrow(IllegalArgumentException::new));
    }

    public byte[] serializeEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"null cannot be serialized");
        Preconditions.checkArgument((boolean)(entity instanceof CraftEntity), (Object)"only CraftEntities can be serialized");
        CompoundTag compound = new CompoundTag();
        ((CraftEntity)entity).getHandle().serializeEntity(compound);
        return this.serializeNbtToBytes(compound);
    }

    public Entity deserializeEntity(byte[] data, World world, boolean preserveUUID) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        CompoundTag compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.getInt("DataVersion");
        compound = MCDataConverter.convertTag(MCTypeRegistry.ENTITY, compound, dataVersion, this.getDataVersion());
        if (!preserveUUID) {
            compound.remove("UUID");
        }
        return EntityType.create(compound, ((CraftWorld)world).getHandle()).orElseThrow(() -> new IllegalArgumentException("An ID was not found for the data. Did you downgrade?")).getBukkitEntity();
    }

    private byte[] serializeNbtToBytes(CompoundTag compound) {
        compound.putInt("DataVersion", this.getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NbtIo.writeCompressed(compound, outputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }

    private CompoundTag deserializeNbtFromBytes(byte[] data) {
        CompoundTag compound;
        try {
            compound = NbtIo.readCompressed(new ByteArrayInputStream(data), NbtAccounter.unlimitedHeap());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int dataVersion = compound.getInt("DataVersion");
        Preconditions.checkArgument((dataVersion <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        return compound;
    }

    public int nextEntityId() {
        return net.minecraft.world.entity.Entity.nextEntityId();
    }

    public String getMainLevelName() {
        return ((DedicatedServer)MinecraftServer.getServer()).getProperties().levelName;
    }

    public int getProtocolVersion() {
        return SharedConstants.getCurrentVersion().getProtocolVersion();
    }

    public boolean isValidRepairItemStack(ItemStack itemToBeRepaired, ItemStack repairMaterial) {
        if (!itemToBeRepaired.getType().isItem() || !repairMaterial.getType().isItem()) {
            return false;
        }
        return CraftMagicNumbers.getItem(itemToBeRepaired.getType()).isValidRepairItem(CraftItemStack.asNMSCopy(itemToBeRepaired), CraftItemStack.asNMSCopy(repairMaterial));
    }

    public boolean hasDefaultEntityAttributes(NamespacedKey bukkitEntityKey) {
        return DefaultAttributes.hasSupplier(BuiltInRegistries.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft(bukkitEntityKey)));
    }

    public Attributable getDefaultEntityAttributes(NamespacedKey bukkitEntityKey) {
        Preconditions.checkArgument((boolean)this.hasDefaultEntityAttributes(bukkitEntityKey), (Object)(String.valueOf(bukkitEntityKey) + " doesn't have default attributes"));
        AttributeSupplier supplier = DefaultAttributes.getSupplier(BuiltInRegistries.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft(bukkitEntityKey)));
        return new UnmodifiableAttributeMap(supplier);
    }

    public NamespacedKey getBiomeKey(RegionAccessor accessor, int x, int y, int z) {
        CraftRegionAccessor cra = (CraftRegionAccessor)accessor;
        return CraftNamespacedKey.fromMinecraft(cra.getHandle().registryAccess().registryOrThrow(Registries.BIOME).getKey(cra.getHandle().getBiome(new BlockPos(x, y, z)).value()));
    }

    public void setBiomeKey(RegionAccessor accessor, int x, int y, int z, NamespacedKey biomeKey) {
        CraftRegionAccessor cra = (CraftRegionAccessor)accessor;
        Holder.Reference<Biome> biomeBase = cra.getHandle().registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(ResourceKey.create(Registries.BIOME, CraftNamespacedKey.toMinecraft(biomeKey)));
        cra.setBiome(x, y, z, biomeBase);
    }

    public String getStatisticCriteriaKey(Statistic statistic) {
        if (statistic.getType() != Statistic.Type.UNTYPED) {
            return "minecraft.custom:minecraft." + statistic.getKey().getKey();
        }
        return CraftStatistic.getNMSStatistic(statistic).getName();
    }

    public List<Component> computeTooltipLines(ItemStack itemStack, TooltipContext tooltipContext, Player player) {
        TooltipFlag.Default flag;
        Preconditions.checkArgument((tooltipContext != null ? 1 : 0) != 0, (Object)"tooltipContext cannot be null");
        TooltipFlag.Default default_ = flag = tooltipContext.isAdvanced() ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        if (tooltipContext.isCreative()) {
            flag = flag.asCreative();
        }
        List<net.minecraft.network.chat.Component> lines = CraftItemStack.asNMSCopy(itemStack).getTooltipLines(Item.TooltipContext.of(player == null ? MinecraftServer.getServer().registryAccess() : ((CraftPlayer)player).getHandle().level().registryAccess()), player == null ? null : ((CraftPlayer)player).getHandle(), flag);
        return lines.stream().map(PaperAdventure::asAdventure).toList();
    }

    public String get(Class<?> aClass, String s) {
        if (aClass == Enchantment.class) {
            return FieldRename.convertEnchantmentName(ApiVersion.CURRENT, s);
        }
        return s;
    }

    public <B extends Keyed> B get(Registry<B> registry, NamespacedKey namespacedKey) {
        return CraftRegistry.get(registry, namespacedKey, ApiVersion.CURRENT);
    }

    public Color getSpawnEggLayerColor(org.bukkit.entity.EntityType entityType, int layer) {
        EntityType<?> nmsType = CraftEntityType.bukkitToMinecraft(entityType);
        SpawnEggItem eggItem = SpawnEggItem.byId(nmsType);
        return eggItem == null ? null : Color.fromRGB((int)eggItem.getColor(layer));
    }

    public LifecycleEventManager<Plugin> createPluginLifecycleEventManager(JavaPlugin plugin, BooleanSupplier registrationCheck) {
        return new PaperLifecycleEventManager<JavaPlugin>(plugin, registrationCheck);
    }

    public <A extends Keyed, M> Tag<A> getTag(TagKey<A> tagKey) {
        if (tagKey.registryKey() != RegistryKey.ENTITY_TYPE && tagKey.registryKey() != RegistryKey.FLUID) {
            throw new UnsupportedOperationException(String.valueOf(tagKey.registryKey()) + " doesn't have tags");
        }
        ResourceKey nmsKey = PaperRegistries.registryToNms(tagKey.registryKey());
        net.minecraft.core.Registry nmsRegistry = CraftRegistry.getMinecraftRegistry().registryOrThrow(nmsKey);
        return nmsRegistry.getTag(PaperRegistries.toNms(tagKey)).map(named -> new NamedRegistryKeySetImpl(tagKey, named)).orElse(null);
    }

    public ItemStack createEmptyStack() {
        return CraftItemStack.asCraftMirror(null);
    }

    static {
        for (Block block2 : BuiltInRegistries.BLOCK) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)BuiltInRegistries.BLOCK.getKey(block2).getPath().toUpperCase(Locale.ROOT)));
        }
        for (Item item2 : BuiltInRegistries.ITEM) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)BuiltInRegistries.ITEM.getKey(item2).getPath().toUpperCase(Locale.ROOT)));
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            ResourceLocation key = CraftMagicNumbers.key(material);
            BuiltInRegistries.ITEM.getOptional(key).ifPresent(item -> MATERIAL_ITEM.put(material, (Item)item));
            BuiltInRegistries.BLOCK.getOptional(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (Block)block));
        }
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

