/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.AsyncCatcher;

public class ServerShutdownThread
extends Thread {
    private final MinecraftServer server;

    public ServerShutdownThread(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        try {
            this.server.safeShutdown(false, false);
            for (int i = 1000; i > 0 && !this.server.hasStopped(); i -= 100) {
                Thread.sleep(100L);
            }
            if (this.server.hasStopped()) {
                while (!this.server.hasFullyShutdown) {
                    Thread.sleep(1000L);
                }
                return;
            }
            AsyncCatcher.enabled = false;
            this.server.forceTicks = true;
            this.server.close();
            while (!this.server.hasFullyShutdown) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            LogManager.shutdown();
        }
    }
}

