/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.enums.MoveType;
import org.mvplugins.multiverse.portals.event.MVPortalEvent;
import org.mvplugins.multiverse.portals.listeners.PlayerListenerHelper;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public class MVPPlayerMoveListener
implements Listener {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;
    private final PlayerListenerHelper helper;
    private final PortalManager portalManager;
    private final WorldManager worldManager;
    private final MVEconomist economist;

    @Inject
    MVPPlayerMoveListener(@NotNull MultiversePortals plugin, @NotNull PortalsConfig portalsConfig, @NotNull PlayerListenerHelper helper, @NotNull PortalManager portalManager, @NotNull WorldManager worldManager, @NotNull MVEconomist economist) {
        this.plugin = plugin;
        this.portalsConfig = portalsConfig;
        this.helper = helper;
        this.portalManager = portalManager;
        this.worldManager = worldManager;
        this.economist = economist;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void blockFromTo(BlockFromToEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock() == null || event.getToBlock() == null) {
            return;
        }
        if (this.portalManager.isPortal(event.getToBlock().getLocation())) {
            event.setCancelled(true);
            return;
        }
        if (this.portalManager.isPortal(event.getBlock().getLocation()) && this.portalsConfig.getBucketFilling()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player p = event.getPlayer();
        Location loc = p.getLocation();
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        ps.setStaleLocation(loc, MoveType.PLAYER_MOVE);
        if (ps.isStaleLocation()) {
            return;
        }
        MVPortal portal = ps.getStandingInPortal();
        if (portal != null && (!this.portalsConfig.getNetherAnimation() || portal.isLegacyPortal()) && ps.doTeleportPlayer(MoveType.PLAYER_MOVE) && !ps.showDebugInfo()) {
            DestinationInstance<?, ?> d = portal.getDestination();
            if (d == null) {
                MVPLogging.fine("Invalid Destination!", new Object[0]);
                return;
            }
            p.setFallDistance(0.0f);
            Location destLocation = (Location)d.getLocation((Entity)p).getOrNull();
            if (destLocation == null) {
                MVPLogging.fine("Unable to teleport player because destination is null!", new Object[0]);
                return;
            }
            if (!this.worldManager.isLoadedWorld(destLocation.getWorld())) {
                MVPLogging.fine("Unable to teleport player because the destination world is not managed by Multiverse!", new Object[0]);
                return;
            }
            if (!portal.isFrameValid(loc)) {
                p.sendMessage("This portal's frame is made of an " + String.valueOf(ChatColor.RED) + "incorrect material. You should exit it now.");
                return;
            }
            if (ps.checkAndSendCooldownMessage()) {
                return;
            }
            if (this.portalsConfig.getEnforcePortalAccess() && !event.getPlayer().hasPermission(portal.getPermission())) {
                this.helper.stateFailure(p.getDisplayName(), portal.getName());
                return;
            }
            double price = portal.getPrice();
            Material currency = portal.getCurrency();
            if (price != 0.0 && !p.hasPermission(portal.getExempt())) {
                if (price < 0.0 || this.economist.isPlayerWealthyEnough(p, price, currency)) {
                    MVPortalEvent portalEvent = new MVPortalEvent(d, event.getPlayer(), portal);
                    this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                    if (!portalEvent.isCancelled()) {
                        if (price < 0.0) {
                            this.economist.deposit(p, -price, currency);
                        } else {
                            this.economist.withdraw(p, price, currency);
                        }
                        p.sendMessage(String.format("You have %s %s for using %s.", price > 0.0 ? "been charged" : "earned", this.economist.formatPrice(price, currency), portal.getName()));
                        this.helper.performTeleport(event.getPlayer(), event.getTo(), ps, d, portal.getCheckDestinationSafety());
                    }
                } else {
                    p.sendMessage(this.economist.getNSFMessage(currency, "You need " + this.economist.formatPrice(price, currency) + " to enter the " + portal.getName() + " portal."));
                }
            } else {
                MVPortalEvent portalEvent = new MVPortalEvent(d, event.getPlayer(), portal);
                this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                if (!portalEvent.isCancelled()) {
                    this.helper.performTeleport(event.getPlayer(), event.getTo(), ps, d, portal.getCheckDestinationSafety());
                }
            }
        }
    }
}

