/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util;

import ch.ethz.globis.phtree.util.Bits;

public class BitsInt {
    static final int UNIT_3 = 5;
    static final int UNIT_BITS = 32;
    private static final int UNIT_0x1F = 31;
    private static final long UNIT_0xFF = 0xFFFFFFFFL;
    private static final long UNIT_0xFF00 = -4294967296L;
    private static final int BYTES_PER_UNIT = 4;
    static int statACreate = 0;
    static int statAExpand = 0;
    static int statATrim = 0;
    static int statOldRightShift = 0;
    static int statOldRightShiftTime = 0;

    public static long readArray(int[] ba, int offsetBit, int entryLen) {
        int pA = offsetBit >>> 5;
        long ret = (long)ba[pA] & 0xFFFFFFFFL;
        int semiLocalEnd = (offsetBit & 0x1F) + entryLen;
        if (semiLocalEnd <= 32) {
            ret >>>= 32 - semiLocalEnd;
        } else {
            ret <<= 32;
            ret |= (long)ba[pA + 1] & 0xFFFFFFFFL;
            if ((semiLocalEnd -= 32) <= 32) {
                ret >>>= 32 - semiLocalEnd;
            } else {
                int buf = ba[pA + 2] >>> 32 - (semiLocalEnd -= 32);
                ret <<= semiLocalEnd;
                ret |= (long)buf & 0xFFFFFFFFL;
            }
        }
        return ret &= -1L << entryLen ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void writeArray(int[] ba, int offsetBit, int entryLen, long val) {
        int bitsToWrite;
        int pA = offsetBit >>> 5;
        int startBit = 32 - (offsetBit & 0x1F);
        for (int bitsWritten = 0; bitsWritten < entryLen; bitsWritten += bitsToWrite) {
            long eraseMask = (1L << startBit) - 1L;
            bitsToWrite = startBit;
            if (bitsWritten + bitsToWrite > entryLen) {
                int bitsToIgnore = bitsWritten + startBit - entryLen;
                long mask2 = (1L << bitsToIgnore) - 1L;
                eraseMask &= mask2 ^ 0xFFFFFFFFFFFFFFFFL;
                bitsToWrite -= bitsToIgnore;
            }
            int n = pA;
            ba[n] = (int)((long)ba[n] & (eraseMask ^ 0xFFFFFFFFFFFFFFFFL));
            int toShift = entryLen - (bitsWritten + startBit);
            long infTemp = toShift > 0 ? val >>> toShift : val << -toShift;
            long maskToCutOfHeadingBits = (1L << startBit) - 1L;
            int n2 = pA++;
            ba[n2] = (int)((long)ba[n2] | (infTemp &= maskToCutOfHeadingBits));
            startBit = 32;
        }
    }

    public static void insertBits1(int[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        ++statOldRightShift;
        long t1 = System.currentTimeMillis();
        int bitsToShift = ba.length * 32 - start - nBits;
        for (int i = 0; i < bitsToShift; ++i) {
            int srcBit = ba.length * 32 - nBits - i - 1;
            int trgBit = ba.length * 32 - i - 1;
            BitsInt.setBit(ba, trgBit, BitsInt.getBit(ba, srcBit));
        }
        long t2 = System.currentTimeMillis();
        statOldRightShiftTime = (int)((long)statOldRightShiftTime + (t2 - t1));
    }

    public static void insertBits(int[] ba, int start, int nBits) {
        int i;
        if (nBits == 0 || start + nBits >= ba.length * 32) {
            return;
        }
        int srcByteStart = start >>> 5;
        int srcLocalStart = start & 0x1F;
        int dstByteStart = start + nBits >>> 5;
        int dstLocalStart = start + nBits & 0x1F;
        int localShift = nBits & 0x1F;
        int nBytesShift = nBits >>> 5;
        if (localShift > 0) {
            for (i = ba.length - 1; i > dstByteStart; --i) {
                ba[i] = ba[i - nBytesShift] >>> localShift | ba[i - nBytesShift - 1] << -localShift;
            }
        } else {
            for (i = ba.length - 1; i > dstByteStart; --i) {
                ba[i] = ba[i - nBytesShift];
            }
        }
        int mask0 = (int)(0xFFFFFFFFL >>> dstLocalStart);
        if (dstLocalStart < srcLocalStart) {
            int buf1 = ba[srcByteStart + 1];
            ba[dstByteStart] = ba[dstByteStart] & ~mask0 | Integer.rotateRight(ba[srcByteStart], localShift) & mask0;
            int mask1 = mask0 >>> -srcLocalStart;
            ba[dstByteStart] = ba[dstByteStart] & ~mask1 | buf1 >>> localShift & mask1;
        } else {
            ba[dstByteStart] = ba[dstByteStart] & ~mask0 | Integer.rotateRight(ba[srcByteStart], localShift) & mask0;
        }
    }

    public static void insertBits0(int[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        ++statOldRightShift;
        long t1 = System.currentTimeMillis();
        int nBytes = (int)Math.ceil((double)nBits / 32.0);
        int startByte = start >> 5;
        int bytesToCopy = ba.length - (startByte + nBytes);
        int tmp = ba[ba.length - nBytes];
        if (bytesToCopy != 0) {
            System.arraycopy(ba, startByte, ba, startByte + nBytes, bytesToCopy);
            int nBitsToMoveLeft = nBytes * 32 - nBits;
            BitsInt.removeBits(ba, start + nBits, nBitsToMoveLeft);
            int offs = 32 - nBitsToMoveLeft;
            BitsInt.copyBitsLeft(new int[]{tmp}, 0, ba, (ba.length - 1) * 32 + offs, nBitsToMoveLeft);
        } else {
            int offsTmp = start & 0x1F;
            if (start + nBits < ba.length * 32) {
                int offsTrg = start + nBits & 0x1F;
                int len = 32 - offsTrg;
                BitsInt.copyBitsLeft(new int[]{tmp}, offsTmp, ba, (ba.length - 1) * 32 + offsTrg, len);
            }
        }
        long t2 = System.currentTimeMillis();
        statOldRightShiftTime = (int)((long)statOldRightShiftTime + (t2 - t1));
    }

    public static void removeBits0(int[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        BitsInt.copyBitsLeft(ba, start + nBits, ba, start, ba.length * 32 - start - nBits);
    }

    public static void removeBits(int[] ba, int start, int nBits) {
        if (nBits == 0 || start + nBits >= ba.length * 32) {
            return;
        }
        int srcByteStart = start + nBits >>> 5;
        int srcLocalStart = start + nBits & 0x1F;
        int dstByteStart = start >>> 5;
        int dstLocalStart = start & 0x1F;
        int localShift = nBits & 0x1F;
        int mask0 = (int)(0xFFFFFFFFL >>> dstLocalStart);
        if (dstLocalStart <= srcLocalStart) {
            ba[dstByteStart] = (ba[dstByteStart] & ~mask0 | Integer.rotateLeft(ba[srcByteStart], localShift) & mask0) & (int)(0xFFFFFFFFL << localShift);
        } else {
            ba[dstByteStart] = ba[dstByteStart] & ~mask0 | Integer.rotateLeft(ba[srcByteStart], localShift) & mask0;
            ba[++dstByteStart] = ba[srcByteStart] << localShift;
            int n = dstByteStart;
            ba[n] = (int)((long)ba[n] & 0xFFFFFFFFL << 32 - dstLocalStart);
        }
        if (localShift > 0) {
            for (int i = srcByteStart + 1; i < ba.length; ++i) {
                int n = dstByteStart++;
                ba[n] = ba[n] | ba[i] >>> -localShift;
                ba[dstByteStart] = ba[i] << localShift;
            }
        } else {
            for (int i = srcByteStart + 1; i < ba.length; ++i) {
                ba[++dstByteStart] = ba[i] << localShift;
            }
        }
    }

    public static void copyBitsLeft1(int[] src, int posSrc, int[] dst, int posDst, int len) {
        if (len == 0) {
            return;
        }
        if (posSrc < posDst) {
            BitsInt.copyBitsLeft1(src, posSrc, dst, posDst, len);
            return;
        }
        int srcByteStart = posSrc >>> 5;
        int srcByteEnd = posSrc + len - 1 >>> 5;
        int srcLocalStart = posSrc & 0x1F;
        int dstByteStart = posDst >>> 5;
        int dstLocalStart = posDst & 0x1F;
        int localShift = posSrc - posDst & 0x1F;
        int mask0 = (int)(0xFFFFFFFFL >>> dstLocalStart);
        int buf0 = src[srcByteStart];
        if (dstLocalStart <= srcLocalStart) {
            if (dstLocalStart + len < 32) {
                throw new UnsupportedOperationException();
            }
            int n = dstByteStart;
            dst[n] = dst[n] & ~mask0;
            int n2 = dstByteStart;
            dst[n2] = dst[n2] | Integer.rotateLeft(buf0, localShift) & mask0;
            int n3 = dstByteStart;
            dst[n3] = (int)((long)dst[n3] & 0xFFFFFFFFL << localShift);
        } else {
            int n = dstByteStart;
            dst[n] = dst[n] & ~mask0;
            int n4 = dstByteStart++;
            dst[n4] = dst[n4] | Integer.rotateLeft(buf0, localShift) & mask0;
            dst[dstByteStart] = buf0 << localShift;
            int n5 = dstByteStart;
            dst[n5] = (int)((long)dst[n5] & 0xFFFFFFFFL << 32 - dstLocalStart);
        }
        if (srcByteEnd > srcByteStart) {
            int rMask = (int)(0xFFFFFFFFL << localShift);
            for (int i = srcByteStart + 1; i < srcByteEnd; ++i) {
                int n = dstByteStart++;
                dst[n] = dst[n] | Integer.rotateLeft(src[i], localShift) & ~rMask;
                dst[dstByteStart] = src[i] << localShift & rMask;
            }
            int srcLocalEnd = srcLocalStart + len & 0x1F;
            int dstLocalEnd = dstLocalStart + len & 0x1F;
            int buf1 = src[srcByteEnd];
            if (srcLocalEnd <= dstLocalEnd) {
                int leftMask = (int)(dstLocalEnd == 0 ? 0xFFFFFFFFL : 0xFFFFFFFFL >>> dstLocalEnd ^ 0xFFFFFFFFFFFFFFFFL);
                int rightMask = (int)(0xFFFFFFFFL >>> dstLocalEnd - srcLocalEnd);
                int maskPost = leftMask & rightMask;
                if (localShift == 0) {
                    // empty if block
                }
                int n = ++dstByteStart;
                dst[n] = dst[n] & ~maskPost;
                int n6 = dstByteStart;
                dst[n6] = dst[n6] | Integer.rotateLeft(buf1, localShift) & maskPost;
                int n7 = dstByteStart;
                dst[n7] = (int)((long)dst[n7] & 0xFFFFFFFFL << localShift);
            } else {
                int leftMask = (int)(0xFFFFFFFFL >>> dstLocalEnd ^ 0xFFFFFFFFFFFFFFFFL);
                int rightMask = (int)(0xFFFFFFFFL >>> dstLocalEnd - srcLocalEnd + 32);
                int shifted = Integer.rotateLeft(buf1, localShift);
                int n = dstByteStart;
                dst[n] = dst[n] & ~rightMask;
                int n8 = dstByteStart++;
                dst[n8] = dst[n8] | shifted & rightMask;
                int n9 = dstByteStart;
                dst[n9] = dst[n9] & ~leftMask;
                int n10 = dstByteStart;
                dst[n10] = dst[n10] | shifted & leftMask;
            }
        }
    }

    public static void copyBitsLeft(int[] src, int posSrc, int[] trg, int posTrg, int len) {
        if (len == 0) {
            return;
        }
        long buf = 0L;
        int psA = posSrc >>> 5;
        int startBitS = 32 - (posSrc & 0x1F);
        int ptA = posTrg >>> 5;
        int startBitT_lr = posTrg & 0x1F;
        int startBitT = 32 - (posTrg & 0x1F);
        int bitsInBuffer = 0;
        int bitsToCopy = len;
        int bitsRead = 0;
        int bitsWritten = 0;
        if (startBitS != 32) {
            long mask = (1L << startBitS) - 1L;
            buf |= (long)src[psA] & mask;
            bitsInBuffer = startBitS;
            bitsRead = startBitS;
            ++psA;
            if (bitsRead > bitsToCopy) {
                buf >>>= bitsRead - bitsToCopy;
                bitsRead = bitsToCopy;
                bitsInBuffer = bitsToCopy;
            }
        }
        long eraseMask = (1L << startBitT) - 1L;
        eraseMask ^= 0xFFFFFFFFFFFFFFFFL;
        int bitsToWriteThisRound = startBitT < len ? startBitT : len;
        boolean readingFinished = false;
        boolean writingFinished = false;
        while (!readingFinished || !writingFinished) {
            if (bitsRead < bitsToCopy) {
                buf <<= 32;
                buf |= (long)src[psA] & 0xFFFFFFFFL;
                bitsInBuffer += 32;
                if ((bitsRead += 32) >= bitsToCopy) {
                    readingFinished = true;
                    if (bitsRead > bitsToCopy) {
                        int d = bitsRead - bitsToCopy;
                        buf >>>= d;
                        bitsRead -= d;
                        bitsInBuffer -= d;
                    }
                }
            } else {
                readingFinished = true;
            }
            if (startBitT_lr + bitsInBuffer < 32) break;
            long buf2 = buf;
            buf2 >>>= bitsInBuffer - bitsToWriteThisRound;
            if (bitsToWriteThisRound > bitsInBuffer) {
                buf2 = buf << bitsToWriteThisRound - bitsInBuffer;
                eraseMask = ~(-1 << bitsToWriteThisRound - bitsInBuffer);
            }
            int n = ptA;
            trg[n] = (int)((long)trg[n] & eraseMask);
            startBitT = 32;
            int n2 = ptA++;
            trg[n2] = (int)((long)trg[n2] | (buf2 &= 0xFFFFFFFFL));
            eraseMask = 0L;
            bitsWritten += bitsToWriteThisRound;
            bitsToWriteThisRound = 32;
            if ((bitsInBuffer -= bitsToWriteThisRound) > 32) {
                buf2 = buf;
                buf2 >>>= bitsInBuffer - bitsToWriteThisRound;
                int n3 = ptA;
                trg[n3] = (int)((long)trg[n3] & eraseMask);
                int n4 = ptA;
                trg[n4] = (int)((long)trg[n4] | (buf2 &= 0xFFFFFFFFL));
                bitsWritten += bitsToWriteThisRound;
                bitsInBuffer -= bitsToWriteThisRound;
            }
            ++psA;
            ++ptA;
            if (bitsToCopy - bitsWritten > 32) continue;
            writingFinished = true;
        }
        if (bitsWritten < bitsToCopy) {
            int bitsToWrite = bitsToCopy - bitsWritten;
            if (bitsWritten == 0) {
                eraseMask = 0xFFFFFFFFL >>> bitsToWrite | 0xFFFFFFFF00000000L;
                eraseMask >>>= 32 - startBitT;
                buf <<= startBitT - bitsToWrite;
            } else {
                eraseMask = 0xFFFFFFFFL >>> bitsToWrite;
                buf <<= 32 - bitsToWrite;
            }
            int n = ptA;
            trg[n] = (int)((long)trg[n] & eraseMask);
            int n5 = ptA;
            trg[n5] = (int)((long)trg[n5] | buf);
        }
    }

    public static boolean getBit(int[] ba, int posBit) {
        int pA = posBit >>> 5;
        return ((long)ba[pA] & 1L << 31 - (posBit &= 0x1F)) != 0L;
    }

    public static void setBit(int[] ba, int posBit, boolean b) {
        int pA = posBit >>> 5;
        posBit &= 0x1F;
        if (b) {
            int n = pA;
            ba[n] = (int)((long)ba[n] | 1L << 31 - posBit);
        } else {
            int n = pA;
            ba[n] = (int)((long)ba[n] & (1L << 31 - posBit ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static int binarySearch(int[] ba, int startBit, int nEntries, long key, int keyWidth, int valueWidth) {
        int entryWidth = keyWidth + valueWidth;
        int min = 0;
        int max = nEntries - 1;
        while (min <= max) {
            int mid = min + max >>> 1;
            long midKey = BitsInt.readArray(ba, mid * entryWidth + startBit, keyWidth);
            if (midKey < key) {
                min = mid + 1;
                continue;
            }
            if (midKey > key) {
                max = mid - 1;
                continue;
            }
            return mid;
        }
        return -(min + 1);
    }

    public static int calcArraySize(int nBits) {
        int arraySize = nBits + 63 >>> 6;
        return arraySize <<= 1;
    }

    public static int[] arrayExpand(int[] oldA, int newSizeBits) {
        int[] newA = new int[BitsInt.calcArraySize(newSizeBits)];
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    public static int[] arrayCreate(int nBits) {
        int[] newA = new int[BitsInt.calcArraySize(nBits)];
        return newA;
    }

    public static int[] arrayEnsureSize(int[] oldA, int requiredBits) {
        if (BitsInt.isCapacitySufficient(oldA, requiredBits)) {
            return oldA;
        }
        return BitsInt.arrayExpand(oldA, requiredBits);
    }

    public static boolean isCapacitySufficient(int[] a, int requiredBits) {
        return a.length * 32 >= requiredBits;
    }

    public static int[] arrayTrim(int[] oldA, int requiredBits) {
        int reqSize = BitsInt.calcArraySize(requiredBits);
        if (oldA.length == reqSize) {
            return oldA;
        }
        int[] newA = new int[reqSize];
        System.arraycopy(oldA, 0, newA, 0, reqSize);
        return newA;
    }

    public static int arraySizeInByte(int[] ba) {
        return ba.length * 4;
    }

    public static int arraySizeInByte(int arrayLength) {
        return arrayLength * 4;
    }

    public static String toBinary(long l) {
        return BitsInt.toBinary(l, 32);
    }

    public static String toBinary(long l, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEPTH; ++i) {
            long mask = 1L << (int)((long)(DEPTH - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if ((i + 1) % 8 == 0 && i + 1 < DEPTH) {
                sb.append('.');
            }
            mask >>>= 1;
        }
        return sb.toString();
    }

    public static String toBinary(long[] la) {
        return BitsInt.toBinary(la, 64);
    }

    public static String toBinary(long[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (long l : la) {
            sb.append(BitsInt.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(int[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = la;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            sb.append(BitsInt.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(int[] ba) {
        StringBuilder sb = new StringBuilder();
        for (int l : ba) {
            sb.append(BitsInt.toBinary(l, 32));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getStats() {
        return "Array create: " + Bits.statACreate + "  exp:" + Bits.statAExpand + "  trm:" + Bits.statATrim + "  oldRS:" + Bits.statOldRightShift + " / " + Bits.statOldRightShiftTime;
    }
}

