/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class JmxTools {
    private static final MBeanServer SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final String[] POOL_NAMES;
    private static long totalDiff;
    private static long totalTime;

    public static void reset() {
        totalDiff = 0L;
        totalTime = 0L;
    }

    public static long getDiff() {
        return totalDiff;
    }

    public static long getTime() {
        return totalTime;
    }

    public static void gc() {
        long td2;
        long td1;
        int n = 0;
        int nMin = 2;
        do {
            JmxTools.sleep();
            td1 = totalDiff;
            long tt1 = totalTime;
            long ts1 = System.currentTimeMillis();
            System.gc();
            long ts2 = System.currentTimeMillis();
            JmxTools.sleep();
            td2 = totalDiff;
            long tt2 = totalTime;
            System.out.println("GC: " + td1 / 1024L / 1024L + "MB -> " + td2 / 1024L / 1024L + "MB  tGC=" + (tt2 - tt1) + "  tSys=" + (ts2 - ts1));
        } while ((Math.abs(td1 - td2) > 0x300000L || ++n < nMin) && n < 5);
    }

    private static void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void startUp() {
        NotificationListener l = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                GarbageCollectorMXBean b = (GarbageCollectorMXBean)handback;
                JmxTools.processNotification(b.getObjectName());
            }
        };
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            try {
                SERVER.addNotificationListener(b.getObjectName(), l, null, (Object)b);
            }
            catch (InstanceNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        JmxTools.gc();
        JmxTools.reset();
    }

    private static void processNotification(ObjectName name) {
        CompositeData cd;
        try {
            cd = (CompositeData)SERVER.getAttribute(name, "LastGcInfo");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        String[] keys = new String[]{"GcThreadCount", "duration", "id", "startTime", "endTime"};
        Object[] mix = cd.getAll(keys);
        MemInfo mi = new MemInfo((Integer)mix[0], (Long)mix[1], (Long)mix[2], (Long)mix[3], (Long)mix[4]);
        String KEY_BEFORE = "memoryUsageBeforeGc";
        String KEY_AFTER = "memoryUsageAfterGc";
        TabularData tdBefore = (TabularData)cd.get(KEY_BEFORE);
        TabularData tdAfter = (TabularData)cd.get(KEY_AFTER);
        for (String mpName : POOL_NAMES) {
            CompositeData cdBefore = tdBefore.get(new Object[]{mpName});
            MemoryUsage muBefore = MemoryUsage.from((CompositeData)cdBefore.get("value"));
            CompositeData cdAfter = tdAfter.get(new Object[]{mpName});
            MemoryUsage muAfter = MemoryUsage.from((CompositeData)cdAfter.get("value"));
            long diff = muAfter.getUsed() - muBefore.getUsed();
            mi.addDiff(diff);
        }
        totalDiff += mi.diff;
        totalTime += mi.duration;
    }

    /*
     * Could not resolve type clashes
     */
    public static void gcCheck() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> names = server.queryNames(null, null);
            for (ObjectName name : names) {
                if (!name.toString().contains("GarbageCollector")) continue;
                System.out.println(name);
                String[] info = server.getMBeanInfo(name);
                for (MBeanFeatureInfo ai : info.getAttributes()) {
                    System.out.println("AI: " + ai.getName() + "  --  " + ai.getDescription());
                }
                for (MBeanFeatureInfo ai : info.getNotifications()) {
                    System.out.println("NI: " + ai.getName() + "  --  " + ai.getDescription());
                }
                for (MBeanFeatureInfo ai : info.getOperations()) {
                    System.out.println("OI: " + ai.getName() + "  --  " + ai.getDescription());
                }
                System.out.println("ColC: " + server.getAttribute(name, "CollectionCount"));
                System.out.println("ColT: " + server.getAttribute(name, "CollectionTime"));
                System.out.println("LGCI: " + server.getAttribute(name, "LastGcInfo"));
                CompositeData cd = (CompositeData)server.getAttribute(name, "LastGcInfo");
                System.out.println("cds: " + cd.getClass().getName() + " " + cd.getCompositeType());
                String[] keys = new String[]{"GcThreadCount", "duration", "endTime", "id", "memoryUsageAfterGc", "memoryUsageBeforeGc", "startTime"};
                for (String s1 : keys) {
                    Object o = cd.get(s1);
                    if (!(o instanceof TabularData)) {
                        System.out.println(" " + s1 + " -> " + o);
                    }
                    if (!(o instanceof TabularData)) continue;
                    TabularData td = (TabularData)o;
                    System.out.println("TD: " + s1);
                    Collection<?> c = td.values();
                    for (CompositeData cd2 : c) {
                        String[] key3 = new String[]{"committed", "init", "max", "used"};
                        System.out.println("222- \"key\" -> " + cd2.get("key"));
                        for (String s3 : key3) {
                            CompositeData cd3 = (CompositeData)cd2.get("value");
                            System.out.println("         " + s3 + " -> " + cd3.get(s3));
                        }
                    }
                }
                for (Object v : cd.values()) {
                    System.out.println("v=(" + v.getClass().getName() + ")" + v);
                }
            }
            for (MemoryManagerMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
                System.out.println("GC-Bean: " + b.getName() + "   c=" + b.getCollectionCount() + "  t=" + b.getCollectionTime());
            }
            for (MemoryManagerMXBean b : ManagementFactory.getMemoryManagerMXBeans()) {
                System.out.println("MM-Bean: " + b.getName());
                for (String string : b.getMemoryPoolNames()) {
                }
            }
            MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
            System.out.println("M-Bean: pfc=" + mb.getObjectPendingFinalizationCount() + "  heap=" + mb.getHeapMemoryUsage() + "  non-heap=" + mb.getNonHeapMemoryUsage());
            for (MemoryPoolMXBean b : ManagementFactory.getMemoryPoolMXBeans()) {
                System.out.println("MP-Bean: " + b.getName() + "  " + (Object)((Object)b.getType()) + "  peak=" + b.getPeakUsage());
                for (String n : b.getMemoryManagerNames()) {
                    System.out.println("MP-MM: " + n);
                }
            }
        }
        catch (InstanceNotFoundException | ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
    }

    private static void print(TabularData td, Object o, String prefix) {
        if (prefix.length() > 10) {
            System.out.println("ABORTING!");
            return;
        }
        prefix = prefix + " ";
        if (o instanceof String) {
            System.out.println(prefix + o);
            JmxTools.print(td, td.get(new Object[]{o}), prefix + "+");
            return;
        }
        if (o instanceof CompositeData) {
            CompositeData cd = (CompositeData)o;
            System.out.println(prefix + "CD: " + cd.getCompositeType());
            for (Object v : cd.values()) {
                JmxTools.print(td, v, prefix);
            }
            return;
        }
        if (o instanceof Collection) {
            System.out.println(prefix + "Collection: " + o.getClass().getName());
            for (Object v : (Collection)o) {
                JmxTools.print(td, v, prefix);
            }
            return;
        }
        if (o instanceof Long) {
            System.out.println(prefix + "Long: " + o);
            return;
        }
        System.out.println("Not supported: " + o.getClass());
    }

    static {
        List<MemoryPoolMXBean> pList = ManagementFactory.getMemoryPoolMXBeans();
        POOL_NAMES = new String[pList.size()];
        int i = 0;
        for (MemoryPoolMXBean b : pList) {
            JmxTools.POOL_NAMES[i++] = b.getName();
        }
    }

    private static class MemInfo {
        final int gcThreadCount;
        final long duration;
        final long id;
        final long startTime;
        final long endTime;
        long diff;

        public MemInfo(int gcThreadCount, long duration, long id, long startTime, long endTime) {
            this.gcThreadCount = gcThreadCount;
            this.duration = duration;
            this.id = id;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public void addDiff(long l) {
            this.diff += l;
        }

        public String toString() {
            return "threads=" + this.gcThreadCount + "  id=" + this.id + "  dur=" + this.duration + "  diff=" + this.diff;
        }
    }
}

