/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util;

import ch.ethz.globis.phtree.PhTreeHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class Refs {
    private static final Object[] EMPTY_REF_ARRAY = new Object[0];
    private static final ArrayPool POOL = new ArrayPool(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE);

    private Refs() {
    }

    public static int calcArraySize(int nObjects) {
        int arraySize = nObjects + PhTreeHelper.ALLOC_BATCH_REF;
        int size = PhTreeHelper.ALLOC_BATCH_SIZE * 2;
        arraySize = arraySize / size * size;
        return arraySize;
    }

    public static <T> T[] arrayExpand(T[] oldA, int newSize) {
        T[] newA = Refs.arrayCreate(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        POOL.offer(oldA);
        return newA;
    }

    public static <T> T[] arrayExpandPrecise(T[] oldA, int newSize) {
        Object[] newA = POOL.getArray(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        POOL.offer(oldA);
        return newA;
    }

    public static <T> T[] arrayCreate(int size) {
        return POOL.getArray(Refs.calcArraySize(size));
    }

    @Deprecated
    public static <T> T[] arrayEnsureSize(T[] oldA, int requiredSize) {
        if (Refs.isCapacitySufficient(oldA, requiredSize)) {
            return oldA;
        }
        return Refs.arrayExpand(oldA, requiredSize);
    }

    public static <T> T[] arrayReplace(T[] oldA, T[] newA) {
        if (oldA != null) {
            POOL.offer(oldA);
        }
        return newA;
    }

    public static <T> T[] arrayClone(T[] oldA) {
        T[] newA = Refs.arrayCreate(oldA.length);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    private static <T> boolean isCapacitySufficient(T[] a, int requiredSize) {
        return a.length >= requiredSize;
    }

    @Deprecated
    public static <T> T[] arrayTrim(T[] oldA, int requiredSize) {
        int reqSize = Refs.calcArraySize(requiredSize);
        if (oldA.length == reqSize) {
            return oldA;
        }
        Object[] newA = POOL.getArray(reqSize);
        System.arraycopy(oldA, 0, newA, 0, reqSize);
        POOL.offer(oldA);
        return newA;
    }

    @Deprecated
    public static <T> void insertAtPos(T[] values, int pos, T value) {
        Refs.copyRight(values, pos, values, pos + 1, values.length - pos - 1);
        values[pos] = value;
    }

    public static <T> T[] insertSpaceAtPos(T[] values, int pos, int requiredSize) {
        T[] dst = values;
        if (requiredSize > values.length) {
            dst = Refs.arrayCreate(requiredSize);
            Refs.copyRight(values, 0, dst, 0, pos);
        }
        Refs.copyRight(values, pos, dst, pos + 1, requiredSize - 1 - pos);
        return dst;
    }

    @Deprecated
    public static <T> void removeAtPos(T[] values, int pos) {
        if (pos < values.length - 1) {
            Refs.copyLeft(values, pos + 1, values, pos, values.length - pos - 1);
        }
    }

    public static <T> T[] removeSpaceAtPos(T[] values, int pos, int requiredSize) {
        int reqSize = Refs.calcArraySize(requiredSize);
        Object[] dst = values;
        if (reqSize < values.length) {
            dst = POOL.getArray(reqSize);
            Refs.copyLeft(values, 0, dst, 0, pos);
        }
        Refs.copyLeft(values, pos + 1, dst, pos, requiredSize - pos);
        return dst;
    }

    private static <T> void copyLeft(T[] src, int srcPos, T[] dst, int dstPos, int len) {
        if (len >= 7) {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        } else {
            for (int i = 0; i < len; ++i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        }
    }

    private static <T> void copyRight(T[] src, int srcPos, T[] dst, int dstPos, int len) {
        if (len >= 7) {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        } else {
            for (int i = len - 1; i >= 0; --i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        }
    }

    public static <T> void write(T[] a, ObjectOutput out) throws IOException {
        out.writeInt(a.length);
        for (int i = 0; i < a.length; ++i) {
            out.writeObject(a[i]);
        }
    }

    public static <T> T[] read(ObjectInput in) throws IOException {
        int size = in.readInt();
        Object[] ret = POOL.getArray(size);
        try {
            for (int i = 0; i < size; ++i) {
                ret[i] = in.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return ret;
    }

    private static class ArrayPool {
        private final int maxArraySize;
        private final int maxArrayCount;
        Object[][][] pool;
        int[] poolSize;

        ArrayPool(int maxArraySize, int maxArrayCount) {
            this.maxArraySize = maxArraySize;
            this.maxArrayCount = maxArrayCount;
            this.pool = new Object[maxArraySize + 1][maxArrayCount][];
            this.poolSize = new int[maxArraySize + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object[] getArray(int size) {
            if (size == 0) {
                return EMPTY_REF_ARRAY;
            }
            if (size > this.maxArraySize || !PhTreeHelper.ARRAY_POOLING) {
                return new Object[size];
            }
            ArrayPool arrayPool = this;
            synchronized (arrayPool) {
                int ps = this.poolSize[size];
                if (ps > 0) {
                    int n = size;
                    this.poolSize[n] = this.poolSize[n] - 1;
                    Object[] ret = this.pool[size][ps - 1];
                    this.pool[size][ps - 1] = null;
                    return ret;
                }
            }
            return new Object[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(Object[] a) {
            int size = a.length;
            if (size == 0 || size > this.maxArraySize || !PhTreeHelper.ARRAY_POOLING) {
                return;
            }
            ArrayPool arrayPool = this;
            synchronized (arrayPool) {
                int ps = this.poolSize[size];
                if (ps < this.maxArrayCount) {
                    Arrays.fill(a, null);
                    this.pool[size][ps] = a;
                    int n = size;
                    this.poolSize[n] = this.poolSize[n] + 1;
                }
            }
        }
    }
}

