/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.util.unsynced;

import ch.ethz.globis.phtree.PhTreeHelper;
import java.util.Arrays;

public class LongArrayArrayPool {
    private static final long[][] EMPTY_REF_ARRAY = new long[0][];
    private final int maxArraySize;
    private final int maxArrayCount;
    private long[][][][] pool;
    private int[] poolSize;

    public static LongArrayArrayPool create() {
        if (PhTreeHelper.ARRAY_POOLING) {
            return new LongArrayArrayPool(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE);
        }
        return new LongArrayArrayPool(0, 0);
    }

    private LongArrayArrayPool(int maxArraySize, int maxArrayCount) {
        this.maxArraySize = maxArraySize;
        this.maxArrayCount = maxArrayCount;
        this.pool = new long[maxArraySize + 1][maxArrayCount][][];
        this.poolSize = new int[maxArraySize + 1];
    }

    private long[][] getArray(int size) {
        if (size == 0) {
            return EMPTY_REF_ARRAY;
        }
        if (size > this.maxArraySize) {
            return new long[size][];
        }
        int ps = this.poolSize[size];
        if (ps > 0) {
            int n = size;
            this.poolSize[n] = this.poolSize[n] - 1;
            long[][] ret = this.pool[size][ps - 1];
            this.pool[size][ps - 1] = null;
            return ret;
        }
        return new long[size][];
    }

    private void offer(long[][] a) {
        int size = a.length;
        if (size == 0 || size > this.maxArraySize) {
            return;
        }
        int ps = this.poolSize[size];
        if (ps < this.maxArrayCount) {
            Arrays.fill((Object[])a, null);
            this.pool[size][ps] = a;
            int n = size;
            this.poolSize[n] = this.poolSize[n] + 1;
        }
    }

    public int calcArraySize(int nObjects) {
        int arraySize = nObjects + PhTreeHelper.ALLOC_BATCH_REF;
        int size = PhTreeHelper.ALLOC_BATCH_SIZE * 2;
        arraySize = arraySize / size * size;
        return arraySize;
    }

    public long[][] arrayExpand(long[][] oldA, int newSize) {
        long[][] newA = this.arrayCreate(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        this.offer(oldA);
        return newA;
    }

    public long[][] arrayCreate(int size) {
        return this.getArray(this.calcArraySize(size));
    }

    public long[][] arrayReplace(long[][] oldA, long[][] newA) {
        if (oldA != null) {
            this.offer(oldA);
        }
        return newA;
    }

    public void arrayDiscard(long[][] oldA) {
        if (oldA != null) {
            this.offer(oldA);
        }
    }

    public long[][] arrayClone(long[][] oldA) {
        long[][] newA = this.arrayCreate(oldA.length);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }
}

