/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v11;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilterDistance;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.v11.Node;
import ch.ethz.globis.phtree.v11.NodeIteratorFullNoGC;
import ch.ethz.globis.phtree.v11.NodeIteratorListReuse;
import ch.ethz.globis.phtree.v11.PhResultList;
import ch.ethz.globis.phtree.v11.PhTree11;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class PhQueryKnnMbbPPList<T>
implements PhTree.PhKnnQuery<T> {
    private final int dims;
    private int nMin;
    private PhTree11<T> pht;
    private PhDistance distance;
    private int currentPos = -1;
    private final long[] mbbMin;
    private final long[] mbbMax;
    private final NodeIteratorListReuse<T, PhEntryDist<T>> iter;
    private final PhFilterDistance checker;
    private final KnnResultList results;
    private final NodeIteratorFullNoGC<T> ni;
    private final long[] niBuffer;

    public PhQueryKnnMbbPPList(PhTree11<T> pht) {
        this.dims = pht.getDim();
        this.mbbMin = new long[this.dims];
        this.mbbMax = new long[this.dims];
        this.pht = pht;
        this.checker = new PhFilterDistance();
        this.results = new KnnResultList(this.dims);
        this.iter = new NodeIteratorListReuse(this.dims, this.results);
        this.niBuffer = new long[this.dims];
        this.ni = new NodeIteratorFullNoGC(this.dims, this.niBuffer);
    }

    @Override
    public long[] nextKey() {
        return ((PhEntry)this.nextEntryReuse()).getKey();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return new PhEntryDist(this.nextEntryReuse());
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        if (this.currentPos >= this.results.size()) {
            throw new NoSuchElementException();
        }
        return this.results.get(this.currentPos++);
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.results.size();
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int nMin, PhDistance dist, long ... center) {
        this.distance = dist == null ? this.distance : dist;
        this.nMin = nMin;
        if (nMin > 0) {
            this.results.reset(nMin, center);
            this.nearestNeighbourBinarySearch(center, nMin);
        } else {
            this.results.clear();
        }
        this.currentPos = 0;
        return this;
    }

    private double estimateDistance(long[] key, Node node) {
        Object v = node.doIfMatching(key, true, null, null, null, this.pht);
        if (v == null) {
            return this.getDistanceToClosest(key, node);
        }
        if (v instanceof Node) {
            return this.estimateDistance(key, (Node)v);
        }
        if (this.nMin == 1) {
            return 0.0;
        }
        return this.getDistanceToClosest(key, node);
    }

    private double getDistanceToClosest(long[] key, Node node) {
        if (node.getPostLen() <= 52) {
            return this.calcDiagonal(key, node);
        }
        long mask = -1L << node.getPostLen() + 1;
        for (int i = 0; i < this.dims; ++i) {
            this.niBuffer[i] = key[i] & mask;
        }
        PhEntry<Object> result = new PhEntry<Object>(this.niBuffer, null);
        this.ni.init(node, null);
        while (this.ni.increment(result)) {
            if (result.hasNodeInternal()) {
                this.ni.init((Node)result.getNodeInternal(), null);
                continue;
            }
            if (this.nMin > 1 && Arrays.equals(key, result.getKey())) continue;
            double dist = this.distance.dist(key, this.niBuffer);
            if (dist > 0.0) {
                return dist;
            }
            return this.calcDiagonal(key, node);
        }
        throw new IllegalStateException();
    }

    private double calcDiagonal(long[] key, Node node) {
        long[] min = new long[this.dims];
        long[] max = new long[this.dims];
        long mask = -1L << node.getPostLen() + 1;
        long mask1111 = mask ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = 0; i < this.dims; ++i) {
            min[i] = key[i] & mask;
            max[i] = key[i] & mask | mask1111;
        }
        double diagonal = this.distance.dist(min, max);
        if (diagonal <= 0.0 || Double.isNaN(diagonal)) {
            return 1.0;
        }
        return diagonal * 0.5;
    }

    private void nearestNeighbourBinarySearch(long[] val, int nMin) {
        if (nMin == 1 && this.pht.contains(val)) {
            PhEntryDist<T> e = this.results.getFreeEntry();
            e.setCopyKey(val, this.pht.get(val), 0.0);
            this.checker.set(val, this.distance, Double.MAX_VALUE);
            this.results.phOffer(e);
            return;
        }
        if (this.pht.size() <= nMin) {
            PhTree.PhExtent<T> itEx = this.pht.queryExtent();
            while (itEx.hasNext()) {
                Object e = itEx.nextEntryReuse();
                PhEntryDist<Object> e2 = this.results.getFreeEntry();
                e2.set(e, this.distance.dist(val, ((PhEntry)e).getKey()));
                this.checker.set(val, this.distance, Double.MAX_VALUE);
                this.results.phOffer(e2);
            }
            return;
        }
        double estimatedDist = this.estimateDistance(val, this.pht.getRoot());
        while (!this.findNeighbours(estimatedDist, nMin, val)) {
            estimatedDist *= 10.0;
        }
    }

    private final boolean findNeighbours(double maxDist, int nMin, long[] val) {
        this.results.maxDistance = maxDist;
        this.checker.set(val, this.distance, maxDist);
        this.distance.toMBB(maxDist, val, this.mbbMin, this.mbbMax);
        this.iter.resetAndRun(this.pht.getRoot(), this.mbbMin, this.mbbMax, Integer.MAX_VALUE);
        return this.results.size() >= nMin;
    }

    private class KnnResultList
    extends PhResultList<T, PhEntryDist<T>> {
        private PhEntryDist<T>[] data;
        private PhEntryDist<T> free;
        private double[] distData;
        private int size = 0;
        private double maxDistance = Double.MAX_VALUE;
        private final int dims;
        private long[] center;

        KnnResultList(int dims) {
            this.free = new PhEntryDist<Object>(new long[dims], null, -1.0);
            this.dims = dims;
        }

        private PhEntryDist<T> createEntry() {
            return new PhEntryDist<Object>(new long[this.dims], null, 1.0);
        }

        void reset(int newSize, long[] center) {
            this.size = 0;
            this.center = center;
            this.maxDistance = Double.MAX_VALUE;
            if (this.data == null) {
                this.data = new PhEntryDist[newSize];
                this.distData = new double[newSize];
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = this.createEntry();
                }
            }
            if (newSize != this.data.length) {
                int len = this.data.length;
                this.data = Arrays.copyOf(this.data, newSize);
                this.distData = new double[newSize];
                for (int i = len; i < newSize; ++i) {
                    this.data[i] = this.createEntry();
                }
            }
        }

        PhEntryDist<T> getFreeEntry() {
            PhEntryDist ret = this.free;
            this.free = null;
            return ret;
        }

        @Override
        void phReturnTemp(PhEntry<T> entry) {
            if (this.free == null) {
                this.free = (PhEntryDist)entry;
            }
        }

        @Override
        void phOffer(PhEntry<T> entry) {
            PhEntryDist e = (PhEntryDist)entry;
            double d = PhQueryKnnMbbPPList.this.distance.dist(this.center, e.getKey());
            e.setDist(d);
            if (d < this.maxDistance || d <= this.maxDistance && this.size < this.data.length) {
                boolean needsAdjustment = this.internalAdd(e);
                if (needsAdjustment) {
                    double oldMaxD = this.maxDistance;
                    this.maxDistance = this.distData[this.size - 1];
                    PhQueryKnnMbbPPList.this.checker.setMaxDist(this.maxDistance);
                    if (this.dims < 6 || this.data.length > 1 || oldMaxD / this.maxDistance > 1.1) {
                        PhQueryKnnMbbPPList.this.distance.toMBB(this.maxDistance, this.center, PhQueryKnnMbbPPList.this.mbbMin, PhQueryKnnMbbPPList.this.mbbMax);
                    }
                }
                if (this.free == e) {
                    this.free = this.createEntry();
                }
            } else {
                this.free = e;
            }
        }

        private boolean internalAdd(PhEntryDist<T> e) {
            if (this.size == 0) {
                this.free = this.data[this.size];
                this.data[this.size] = e;
                this.distData[this.size] = e.dist();
                ++this.size;
                return this.size == this.data.length;
            }
            if (e.dist() > this.distData[this.size - 1] && this.size == this.distData.length) {
                throw new UnsupportedOperationException(e.dist() + " > " + this.distData[this.size - 1]);
            }
            if (this.size == this.data.length) {
                for (int i = this.size - 1; i >= -1; --i) {
                    if (i != -1 && !(this.distData[i] < e.dist())) continue;
                    this.free = this.data[this.size - 1];
                    for (int j = this.size - 2; j >= i + 1; --j) {
                        this.data[j + 1] = this.data[j];
                        this.distData[j + 1] = this.distData[j];
                    }
                    this.data[i + 1] = e;
                    this.distData[i + 1] = e.dist();
                    return true;
                }
            } else {
                for (int i = this.size - 1; i >= -1; --i) {
                    if (i != -1 && !(this.distData[i] < e.dist())) continue;
                    this.free = this.data[this.size];
                    for (int j = this.size - 1; j >= i + 1; --j) {
                        this.data[j + 1] = this.data[j];
                        this.distData[j + 1] = this.distData[j];
                    }
                    this.data[i + 1] = e;
                    this.distData[i + 1] = e.dist();
                    ++this.size;
                    return this.size == this.data.length;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public PhEntryDist<T> get(int index) {
            if (index < 0 || index >= this.size) {
                throw new NoSuchElementException();
            }
            return this.data[index];
        }

        @Override
        PhEntryDist<T> phGetTempEntry() {
            return this.free;
        }

        @Override
        boolean phIsPrefixValid(long[] prefix, int bitsToIgnore) {
            long maskMin = -1L << bitsToIgnore;
            long maskMax = maskMin ^ 0xFFFFFFFFFFFFFFFFL;
            long[] buf = new long[prefix.length];
            for (int i = 0; i < buf.length; ++i) {
                long min = prefix[i] & maskMin;
                long max = prefix[i] | maskMax;
                buf[i] = min > this.center[i] ? min : (max < this.center[i] ? max : this.center[i]);
            }
            return PhQueryKnnMbbPPList.this.distance.dist(this.center, buf) <= this.maxDistance;
        }
    }
}

