/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v11.nt;

import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.v11.nt.NtNode;

public class NtNodePool {
    private static final NtNode<?>[] POOL = new NtNode[PhTreeHelper.MAX_OBJECT_POOL_SIZE];
    private static int poolSize;
    private static int activeNodes;

    private NtNodePool() {
    }

    static synchronized NtNode<?> getNode() {
        ++activeNodes;
        if (poolSize == 0) {
            return NtNode.createEmptyNode();
        }
        return POOL[--poolSize];
    }

    public static synchronized void offer(NtNode<?> node) {
        --activeNodes;
        if (poolSize < POOL.length) {
            NtNodePool.POOL[NtNodePool.poolSize++] = node;
        }
    }

    public static int getActiveNodes() {
        return activeNodes;
    }

    static {
        activeNodes = 0;
    }
}

