/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceL;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhFilterDistance;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeConfig;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import ch.ethz.globis.phtree.util.unsynced.LongArrayPool;
import ch.ethz.globis.phtree.util.unsynced.ObjectArrayPool;
import ch.ethz.globis.phtree.util.unsynced.ObjectPool;
import ch.ethz.globis.phtree.v13.Bits;
import ch.ethz.globis.phtree.v13.Node;
import ch.ethz.globis.phtree.v13.NodeIteratorListReuse;
import ch.ethz.globis.phtree.v13.PhIteratorFullNoGC;
import ch.ethz.globis.phtree.v13.PhIteratorKnn;
import ch.ethz.globis.phtree.v13.PhIteratorNoGC;
import ch.ethz.globis.phtree.v13.PhResultList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PhTree13<T>
implements PhTree<T> {
    public static final boolean HCI_ENABLED = true;
    static final boolean AHC_ENABLED = true;
    public static final int LHC_BINARY_SEARCH_THRESHOLD = 50;
    static final int DEPTH_64 = 64;
    private static final int NO_INSERT_REQUIRED = Integer.MAX_VALUE;
    private final int dims;
    private int nEntries = 0;
    private Node root = null;
    private final ObjectPool<Node> nodePool;
    private final ObjectArrayPool<Object> refPool;
    private final LongArrayPool bitPool;

    Node getRoot() {
        return this.root;
    }

    public PhTree13(int dim) {
        this.dims = dim;
        this.nodePool = ObjectPool.create(Node::createEmpty);
        this.refPool = ObjectArrayPool.create();
        this.bitPool = LongArrayPool.create();
        PhTreeHelper.debugCheck();
    }

    public PhTree13(PhTreeConfig cnf) {
        this(cnf.getDimActual());
        if (cnf.getConcurrencyType() != 0) {
            throw new UnsupportedOperationException("type= " + cnf.getConcurrencyType());
        }
    }

    void increaseNrEntries() {
        ++this.nEntries;
    }

    void decreaseNrEntries() {
        --this.nEntries;
    }

    @Override
    public int size() {
        return this.nEntries;
    }

    @Override
    public PhTreeStats getStats() {
        return this.getStats(0, this.getRoot(), new PhTreeStats(64));
    }

    private PhTreeStats getStats(int currentDepth, Node node, PhTreeStats stats) {
        ++stats.nNodes;
        if (node.isAHC()) {
            ++stats.nAHC;
        }
        int n = node.getInfixLen();
        stats.infixHist[n] = stats.infixHist[n] + 1;
        int n2 = currentDepth;
        stats.nodeDepthHist[n2] = stats.nodeDepthHist[n2] + 1;
        int size = node.getEntryCount();
        int n3 = 32 - Integer.numberOfLeadingZeros(size);
        stats.nodeSizeLogHist[n3] = stats.nodeSizeLogHist[n3] + 1;
        stats.q_totalDepth += (currentDepth += node.getInfixLen());
        for (Object o : node.values()) {
            if (o instanceof Node) {
                this.getStats(currentDepth + 1, (Node)o, stats);
                continue;
            }
            if (o == null) continue;
            int n4 = currentDepth;
            stats.q_nPostFixN[n4] = stats.q_nPostFixN[n4] + 1;
        }
        int REF = 4;
        stats.size += (long)PhTreeHelper.align8(31);
        int nChildren = node.getEntryCount();
        stats.size += (long)(16 + PhTreeHelper.align8(Bits.arraySizeInByte(node.ba())));
        stats.size = stats.size + (node.values() != null ? (long)(16 + PhTreeHelper.align8(node.values().length * 4)) : 0L);
        if (nChildren == 1 && node != this.getRoot() && this.nEntries > 1) {
            System.err.println("WARNING: found lonely node...");
        }
        if (nChildren == 0 && node != this.getRoot()) {
            System.err.println("WARNING: found ZOMBIE node...");
        }
        if (this.dims <= 31 && (long)node.getEntryCount() > 1L << this.dims) {
            System.err.println("WARNING: Over-populated node found: ec=" + node.getEntryCount());
        }
        int baS = node.calcArraySizeTotalBits(node.getEntryCount(), this.dims);
        if ((baS = Bits.calcArraySize(baS)) < node.ba().length) {
            System.err.println("Array too large: " + node.ba().length + " - " + baS + " = " + (node.ba().length - baS));
        }
        stats.nTotalChildren += nChildren;
        return stats;
    }

    @Override
    public T put(long[] key, T value) {
        Object nonNullValue;
        Object object = nonNullValue = value == null ? PhTreeHelper.NULL : value;
        if (this.getRoot() == null) {
            this.insertRoot(key, nonNullValue);
            return null;
        }
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doInsertIfMatching(key, nonNullValue, this);
        }
        return (T)o;
    }

    private void insertRoot(long[] key, Object value) {
        this.root = Node.createNode(this.dims, 0, 63, this);
        long pos = PhTreeHelper.posInArray(key, this.root.getPostLen());
        this.root.addPostPIN(pos, -1, key, value, this);
        this.increaseNrEntries();
    }

    @Override
    public boolean contains(long ... key) {
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, null, this);
        }
        return o != null;
    }

    @Override
    public T get(long ... key) {
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, null, this);
        }
        return (T)(o == PhTreeHelper.NULL ? null : o);
    }

    @Override
    public T remove(long ... key) {
        Object o = this.getRoot();
        Node parentNode = null;
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, false, parentNode, null, null, this);
            parentNode = currentNode;
        }
        return (T)o;
    }

    @Override
    public T update(long[] oldKey, long[] newKey) {
        Node value;
        Node[] stack = new Node[64];
        int stackSize = 0;
        Object o = this.getRoot();
        Node parentNode = null;
        int[] insertRequired = new int[]{Integer.MAX_VALUE};
        while (o instanceof Node) {
            Node currentNode = o;
            stack[stackSize++] = currentNode;
            o = currentNode.doIfMatching(oldKey, false, parentNode, newKey, insertRequired, this);
            parentNode = currentNode;
        }
        Node node = value = o == PhTreeHelper.NULL ? null : o;
        if (insertRequired[0] != Integer.MAX_VALUE) {
            if (stack[stackSize - 1].getEntryCount() == 0 && stackSize > 1) {
                --stackSize;
            }
            while (stackSize > 0) {
                if (stack[--stackSize].getPostLen() + 1 < insertRequired[0]) continue;
                o = stack[stackSize];
                while (o instanceof Node) {
                    Node currentNode = (Node)o;
                    o = currentNode.doInsertIfMatching(newKey, value, this);
                }
                insertRequired[0] = Integer.MAX_VALUE;
                break;
            }
        }
        return (T)value;
    }

    @Override
    public T getOrDefault(long[] key, T defaultValue) {
        T e = this.get(key);
        return e == null ? defaultValue : e;
    }

    @Override
    public T putIfAbsent(long[] key, T value) {
        if (this.getRoot() == null) {
            this.insertRoot(key, PhTreeHelper.maskNull(value));
            return null;
        }
        T o = this.get(key);
        if (o == null) {
            this.put(key, value);
        }
        return o;
    }

    @Override
    public boolean remove(long[] key, T value) {
        boolean[] o = new boolean[1];
        this.computeIfPresent(key, (longs, t) -> {
            o[0] = Objects.equals(t, value);
            return o[0] ? null : t;
        });
        return o[0];
    }

    @Override
    public boolean replace(long[] key, T oldValue, T newValue) {
        if (this.getRoot() == null) {
            return false;
        }
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, null, this);
        }
        if (o != null && Objects.equals(o, oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public T replace(long[] key, T value) {
        if (this.getRoot() == null) {
            return null;
        }
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, null, this);
        }
        if (o != null) {
            this.put(key, value);
            return PhTreeHelper.unmaskNull(o);
        }
        return null;
    }

    @Override
    public T computeIfAbsent(long[] key, Function<long[], ? extends T> mappingFunction) {
        if (this.getRoot() == null) {
            T newValue = mappingFunction.apply(key);
            if (newValue != null) {
                this.insertRoot(key, PhTreeHelper.maskNull(newValue));
            }
            return newValue;
        }
        T currentValue = this.get(key);
        if (currentValue == null) {
            T newValue = mappingFunction.apply(key);
            if (newValue != null) {
                this.put(key, newValue);
            }
            return newValue;
        }
        return currentValue;
    }

    @Override
    public T computeIfPresent(long[] key, BiFunction<long[], ? super T, ? extends T> remappingFunction) {
        if (this.getRoot() == null) {
            return null;
        }
        Object o = this.getRoot();
        Node parentNode = null;
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doCompute(key, false, parentNode, this, remappingFunction);
            parentNode = currentNode;
        }
        return (T)o;
    }

    @Override
    public T compute(long[] key, BiFunction<long[], ? super T, ? extends T> remappingFunction) {
        if (this.getRoot() == null) {
            T newValue = remappingFunction.apply(key, null);
            if (newValue != null) {
                this.insertRoot(key, PhTreeHelper.maskNull(newValue));
            }
            return newValue;
        }
        Object o = this.getRoot();
        Node parentNode = null;
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doCompute(key, true, parentNode, this, remappingFunction);
            parentNode = currentNode;
        }
        return (T)o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " AHC/LHC=" + 2.0 + " AHC-on=" + true + " HCI-on=" + true + " NtLimit=NT_DISABLED DEBUG=" + false;
    }

    @Override
    public String toStringPlain() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringPlain(sb, this.getRoot(), new long[this.dims]);
        }
        return sb.toString();
    }

    private void toStringPlain(StringBuilderLn sb, Node node, long[] key) {
        int i = 0;
        while ((long)i < 1L << this.dims) {
            Object o = node.getEntry(i, key);
            if (o != null) {
                if (o instanceof Node) {
                    this.toStringPlain(sb, (Node)o, key);
                } else {
                    sb.append(Bits.toBinary(key, 64));
                    sb.appendLn("  v=" + o);
                }
            }
            ++i;
        }
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringTree(sb, 0, this.getRoot(), new long[this.dims], true);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, int currentDepth, Node node, long[] key, boolean printValue) {
        int i;
        String ind = "*";
        for (i = 0; i < currentDepth; ++i) {
            ind = ind + "-";
        }
        sb.append(ind + "il=" + node.getInfixLen() + " pl=" + node.getPostLen() + " ec=" + node.getEntryCount() + " inf=[");
        if (node.getInfixLen() > 0) {
            long mask = -1L << node.getInfixLen();
            mask ^= 0xFFFFFFFFFFFFFFFFL;
            mask <<= node.getPostLen() + 1;
            for (int i2 = 0; i2 < this.dims; ++i2) {
                sb.append(Bits.toBinary(key[i2] & mask) + ",");
            }
        }
        currentDepth += node.getInfixLen();
        sb.appendLn("]  " + node);
        i = 0;
        while ((long)i < 1L << this.dims) {
            Object o = node.getEntry(i, key);
            if (o != null) {
                if (o instanceof Node) {
                    sb.appendLn(ind + "# " + i + "  +");
                    this.toStringTree(sb, currentDepth + 1, (Node)o, key, printValue);
                } else {
                    sb.append(ind + Bits.toBinary(key, 64));
                    sb.append("  hcPos=" + i);
                    if (printValue) {
                        sb.append("  v=" + o);
                    }
                    sb.appendLn("");
                }
            }
            ++i;
        }
    }

    @Override
    public PhTree.PhExtent<T> queryExtent() {
        return new PhIteratorFullNoGC(this, null).reset();
    }

    @Override
    public PhTree.PhQuery<T> query(long[] min, long[] max) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        PhIteratorNoGC q = new PhIteratorNoGC(this, null);
        q.reset(min, max);
        return q;
    }

    @Override
    public PhTree.PhQuery<T> query(long[] min, long[] max, PhFilter filter) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        PhIteratorNoGC q = new PhIteratorNoGC(this, filter);
        q.reset(min, max);
        return q;
    }

    @Override
    public List<PhEntry<T>> queryAll(long[] min, long[] max) {
        return this.queryAll(min, max, Integer.MAX_VALUE, null, PhMapper.PVENTRY());
    }

    @Override
    public <R> List<R> queryAll(long[] min, long[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        if (this.getRoot() == null) {
            return new ArrayList();
        }
        PhResultList.MappingResultList<T, R> list = new PhResultList.MappingResultList<T, R>(null, mapper, () -> new PhEntry<Object>(new long[this.dims], null));
        NodeIteratorListReuse<T, R> it = new NodeIteratorListReuse<T, R>(this.dims, list);
        return it.resetAndRun(this.getRoot(), min, max, maxResults);
    }

    @Override
    public int getDim() {
        return this.dims;
    }

    @Override
    public int getBitDepth() {
        return 64;
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, long ... v) {
        return new PhIteratorKnn(this, nMin, v, PhDistanceL.THIS);
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, PhDistance dist, PhFilter dimsFilter, long ... center) {
        return new PhIteratorKnn(this, nMin, center, dist);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, long ... center) {
        return this.rangeQuery(dist, null, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, PhDistance optionalDist, long ... center) {
        PhFilterDistance filter = new PhFilterDistance();
        if (optionalDist == null) {
            optionalDist = PhDistanceL.THIS;
        }
        filter.set(center, optionalDist, dist);
        PhIteratorNoGC q = new PhIteratorNoGC(this, filter);
        PhRangeQuery qr = new PhRangeQuery(q, this, optionalDist, filter);
        qr.reset(dist, center);
        return qr;
    }

    @Override
    public void clear() {
        this.root = null;
        this.nEntries = 0;
    }

    static long inc(long v, long min, long max) {
        long r = v | max ^ 0xFFFFFFFFFFFFFFFFL;
        return ++r & max | min;
    }

    ObjectPool<Node> nodePool() {
        return this.nodePool;
    }

    ObjectArrayPool<Object> objPool() {
        return this.refPool;
    }

    LongArrayPool longPool() {
        return this.bitPool;
    }
}

