/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v8;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.v8.Bits;
import ch.ethz.globis.phtree.v8.Node;
import ch.ethz.globis.phtree.v8.PhTree8;
import org.zoodb.index.critbit.CritBit64;

public class NodeIteratorNoGC<T> {
    private static final long FINISHED = Long.MAX_VALUE;
    private final int DIM;
    private boolean isPostHC;
    private boolean isPostNI;
    private boolean isSubHC;
    private int postLen;
    private long next = -1L;
    private long nextPost = -1L;
    private long nextSub = -1L;
    private Node<T> nextSubNode;
    private Node<T> node;
    private int currentOffsetPostKey;
    private int currentOffsetPostVal;
    private int currentOffsetSub;
    private CritBit64.QueryIteratorMask<PhTree8.NodeEntry<T>> niIterator;
    private int nMaxPost;
    private int nMaxSub;
    private int nPostsFound = 0;
    private int posSubLHC = -1;
    private int postEntryLen;
    private final long[] valTemplate;
    private long maskLower;
    private long maskUpper;
    private long[] rangeMin;
    private long[] rangeMax;
    private boolean usePostHcIncrementer;
    private boolean useSubHcIncrementer;
    private boolean useNiHcIncrementer;
    private boolean isPostFinished;
    private boolean isSubFinished;
    private PhFilter checker;
    private final PhEntry<T> nextPost1;
    private final PhEntry<T> nextPost2;
    private boolean isNextPost1free;

    public NodeIteratorNoGC(int DIM, long[] valTemplate) {
        this.DIM = DIM;
        this.valTemplate = valTemplate;
        this.nextPost1 = new PhEntry<Object>(new long[DIM], null);
        this.nextPost2 = new PhEntry<Object>(new long[DIM], null);
    }

    private void reinit(Node<T> node, long[] rangeMin, long[] rangeMax, long lower, long upper, PhFilter checker) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.next = -1L;
        this.nextPost = -1L;
        this.nextSub = -1L;
        this.nextSubNode = null;
        this.currentOffsetPostKey = 0;
        this.currentOffsetPostVal = 0;
        this.currentOffsetSub = 0;
        this.nPostsFound = 0;
        this.posSubLHC = -1;
        this.checker = checker;
        this.node = node;
        this.isPostHC = node.isPostHC();
        this.isPostNI = node.isPostNI();
        this.isSubHC = node.isSubHC();
        this.postLen = node.getPostLen();
        this.nMaxPost = node.getPostCount();
        this.nMaxSub = node.getSubCount();
        this.isPostFinished = this.nMaxPost <= 0;
        boolean bl = this.isSubFinished = this.nMaxSub <= 0;
        if (this.isPostFinished) {
            this.nextPost = Long.MAX_VALUE;
        }
        if (this.isSubFinished) {
            this.nextSub = Long.MAX_VALUE;
        }
        this.maskLower = lower;
        this.maskUpper = upper;
        this.currentOffsetSub = node.getBitPos_SubNodeIndex(this.DIM);
        if (this.isPostNI) {
            this.postEntryLen = -1;
        } else {
            this.currentOffsetPostKey = node.getBitPos_PostIndex(this.DIM);
            if (this.isPostHC) {
                this.postEntryLen = this.DIM * this.postLen;
                this.currentOffsetPostVal = this.currentOffsetPostKey + (1 << this.DIM) * 1;
            } else {
                this.postEntryLen = Node.PIK_WIDTH(this.DIM) + this.DIM * this.postLen;
                this.currentOffsetPostVal = this.currentOffsetPostKey + Node.PIK_WIDTH(this.DIM);
            }
        }
        this.useSubHcIncrementer = false;
        this.usePostHcIncrementer = false;
        this.useNiHcIncrementer = false;
        if (this.DIM > 3) {
            long maxHcAddr = -1L << this.DIM ^ 0xFFFFFFFFFFFFFFFFL;
            int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
            long nPossibleMatch = 1L << this.DIM - nSetFilterBits;
            if (this.isPostNI) {
                int logNChild;
                boolean useHcIncrementer;
                int nChild = node.ind().size();
                boolean bl2 = useHcIncrementer = (double)nChild > (double)nPossibleMatch * (double)(logNChild = 64 - Long.numberOfLeadingZeros(nChild)) * 2.0;
                this.useNiHcIncrementer = useHcIncrementer && this.DIM < 50;
            } else {
                if (this.isPostHC) {
                    this.usePostHcIncrementer = nPossibleMatch < maxHcAddr;
                } else {
                    int logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxPost) + 1;
                    boolean bl3 = this.usePostHcIncrementer = (double)this.nMaxPost > (double)nPossibleMatch * (double)logNPost;
                }
                if (this.isSubHC) {
                    this.useSubHcIncrementer = nPossibleMatch < maxHcAddr;
                } else {
                    int logNSub = 64 - Long.numberOfLeadingZeros(this.nMaxSub) + 1;
                    boolean bl4 = this.useSubHcIncrementer = (double)this.nMaxSub > (double)nPossibleMatch * (double)logNSub;
                }
            }
        }
        if (this.isPostNI && !this.useNiHcIncrementer) {
            if (this.niIterator == null) {
                this.niIterator = new CritBit64.QueryIteratorMask();
            }
            this.niIterator.reset(node.ind(), this.maskLower, this.maskUpper);
        }
    }

    boolean hasNext() {
        return !this.isPostFinished || !this.isSubFinished;
    }

    boolean increment() {
        this.next = this.getNext(this.isNextPost1free ? this.nextPost1 : this.nextPost2);
        return this.next != Long.MAX_VALUE;
    }

    long getCurrentPos() {
        return this.isPostNI ? this.next : this.nextSub;
    }

    PhEntry<T> getCurrentPost() {
        return this.isNextPost1free ? this.nextPost2 : this.nextPost1;
    }

    boolean isNextSub() {
        return this.isPostNI ? this.nextSubNode != null : this.next == this.nextSub;
    }

    private boolean readValue(long pos, int offsPostKey, PhEntry<T> result) {
        long[] key = result.getKey();
        System.arraycopy(this.valTemplate, 0, key, 0, this.DIM);
        PhTreeHelper.applyHcPos(pos, this.postLen, key);
        if (!this.node.getPostPOB(offsPostKey, pos, result, this.rangeMin, this.rangeMax)) {
            return false;
        }
        if (this.checker != null && !this.checker.isValid(key)) {
            return false;
        }
        this.isNextPost1free = !this.isNextPost1free;
        return true;
    }

    private boolean readValue(long pos, PhTree8.NodeEntry<T> e, PhEntry<T> result) {
        long mask = this.postLen < 63 ? -1L << this.postLen + 1 : 0L;
        long[] eKey = e.getKey();
        PhTreeHelper.applyHcPos(pos, this.postLen, eKey);
        for (int i = 0; i < eKey.length; ++i) {
            int n = i;
            eKey[n] = eKey[n] | this.valTemplate[i] & mask;
            if (eKey[i] >= this.rangeMin[i] && eKey[i] <= this.rangeMax[i]) continue;
            return false;
        }
        if (this.checker != null && !this.checker.isValid(eKey)) {
            return false;
        }
        System.arraycopy(eKey, 0, result.getKey(), 0, this.DIM);
        result.setValue(e.getValue());
        this.nextSubNode = null;
        this.isNextPost1free = !this.isNextPost1free;
        return true;
    }

    private long getNextPostHCI(long currentPos, PhEntry<T> result) {
        int pob;
        do {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
                continue;
            }
            if ((currentPos = PhTree8.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower) continue;
            this.isPostFinished = true;
            return Long.MAX_VALUE;
        } while (this.isPostNI || (pob = this.node.getPostOffsetBits(currentPos, this.DIM)) < 0 || !this.readValue(currentPos, pob, result));
        return currentPos;
    }

    private long getNextSubHCI(long currentPos) {
        int subNodePos;
        while (true) {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
            } else if ((currentPos = PhTree8.inc(currentPos, this.maskLower, this.maskUpper)) <= this.maskLower) {
                this.isSubFinished = true;
                return Long.MAX_VALUE;
            }
            if (this.isSubHC) {
                if (this.node.subNRef((int)currentPos) == null) continue;
                this.posSubLHC = (int)currentPos;
                this.nextSubNode = this.node.subNRef((int)currentPos);
                return currentPos;
            }
            int subOffsBits = this.currentOffsetSub;
            subNodePos = Bits.binarySearch(this.node.ba, subOffsBits, this.nMaxSub, (int)currentPos, Node.SIK_WIDTH(this.DIM), 0);
            if (subNodePos >= 0) break;
        }
        this.posSubLHC = subNodePos;
        this.nextSubNode = this.node.subNRef(subNodePos);
        return currentPos;
    }

    private long getNext(PhEntry<T> result) {
        if (this.node.isPostNI()) {
            this.niFindNext(result);
            return this.next;
        }
        if (!this.isPostFinished && this.nextPost == this.next) {
            if (this.usePostHcIncrementer) {
                this.nextPost = this.getNextPostHCI(this.nextPost, result);
            } else if (this.isPostHC) {
                this.getNextPostAHC(result);
            } else {
                this.getNextPostLHC(result);
            }
        }
        if (!this.isSubFinished && this.nextSub == this.next) {
            if (this.useSubHcIncrementer) {
                this.nextSub = this.getNextSubHCI(this.nextSub);
            } else if (this.isSubHC) {
                this.getNextSubAHC();
            } else {
                this.getNextSubLHC();
            }
        }
        return this.nextSub < this.nextPost ? this.nextSub : this.nextPost;
    }

    private void getNextPostAHC(PhEntry<T> result) {
        long currentPos = this.nextPost;
        while (!this.isPostFinished) {
            if (currentPos >= 0L) {
                ++currentPos;
            } else {
                currentPos = this.maskLower;
                this.currentOffsetPostKey = (int)((long)this.currentOffsetPostKey + this.maskLower * 1L);
            }
            if (currentPos >= (long)(1 << this.DIM)) {
                this.isPostFinished = true;
                this.nextPost = Long.MAX_VALUE;
                break;
            }
            boolean bit = Bits.getBit(this.node.ba, this.currentOffsetPostKey);
            ++this.currentOffsetPostKey;
            if (!bit) continue;
            if (!this.checkHcPos(currentPos)) {
                if (currentPos <= this.maskUpper) continue;
                this.isPostFinished = true;
                this.nextPost = Long.MAX_VALUE;
                break;
            }
            int offs = (int)((long)this.currentOffsetPostVal + currentPos * (long)this.postEntryLen);
            if (!this.readValue(currentPos, offs, result)) continue;
            this.nextPost = currentPos;
            break;
        }
    }

    private void getNextPostLHC(PhEntry<T> result) {
        while (!this.isPostFinished) {
            if (++this.nPostsFound > this.nMaxPost) {
                this.isPostFinished = true;
                this.nextPost = Long.MAX_VALUE;
                break;
            }
            int offs = this.currentOffsetPostKey;
            long currentPos = Bits.readArray(this.node.ba, offs, Node.PIK_WIDTH(this.DIM));
            this.currentOffsetPostKey += this.postEntryLen;
            if (!this.checkHcPos(currentPos)) {
                if (currentPos <= this.maskUpper) continue;
                this.isPostFinished = true;
                this.nextPost = Long.MAX_VALUE;
                break;
            }
            if (!this.readValue(currentPos, offs + Node.PIK_WIDTH(this.DIM), result)) continue;
            this.nextPost = currentPos;
            break;
        }
    }

    private void getNextSubAHC() {
        int currentPos = (int)this.nextSub;
        int maxPos = 1 << this.DIM;
        while (!this.isSubFinished) {
            currentPos = currentPos < 0 ? (int)this.maskLower : ++currentPos;
            if (currentPos >= maxPos) {
                this.isSubFinished = true;
                this.nextSub = Long.MAX_VALUE;
                break;
            }
            if (this.node.subNRef(currentPos) == null) continue;
            if (!this.checkHcPos(currentPos)) {
                if ((long)currentPos <= this.maskUpper) continue;
                this.isSubFinished = true;
                this.nextSub = Long.MAX_VALUE;
                break;
            }
            this.nextSub = currentPos;
            this.nextSubNode = this.node.subNRef(currentPos);
            break;
        }
    }

    private void getNextSubLHC() {
        while (!this.isSubFinished) {
            if (this.posSubLHC + 1 >= this.nMaxSub) {
                this.isSubFinished = true;
                this.nextSub = Long.MAX_VALUE;
                break;
            }
            long currentPos = Bits.readArray(this.node.ba, this.currentOffsetSub, Node.SIK_WIDTH(this.DIM));
            this.currentOffsetSub += Node.SIK_WIDTH(this.DIM);
            ++this.posSubLHC;
            if (!this.checkHcPos(currentPos)) {
                if (currentPos <= this.maskUpper) continue;
                this.isSubFinished = true;
                this.nextSub = Long.MAX_VALUE;
                break;
            }
            this.nextSub = currentPos;
            this.nextSubNode = this.node.subNRef(this.posSubLHC);
            break;
        }
    }

    private void niFindNext(PhEntry<T> result) {
        if (!this.useNiHcIncrementer) {
            while (this.niIterator.hasNext()) {
                CritBit64.Entry<PhTree8.NodeEntry<T>> e = this.niIterator.nextEntry();
                this.next = e.key();
                this.nextSubNode = e.value().node;
                if (this.nextSubNode == null && !this.readValue(e.key(), e.value(), result)) continue;
                return;
            }
            this.next = Long.MAX_VALUE;
            return;
        }
        long currentPos = this.next;
        while (currentPos == -1L || currentPos < this.maskUpper) {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
            } else if ((currentPos = PhTree8.inc(currentPos, this.maskLower, this.maskUpper)) <= this.maskLower) break;
            PhTree8.NodeEntry<T> e = this.node.niGet(currentPos);
            if (e == null) continue;
            this.next = currentPos;
            this.nextSubNode = e.node;
            if (e.node != null) {
                return;
            }
            if (!this.readValue(currentPos, e, result)) continue;
            return;
        }
        this.next = Long.MAX_VALUE;
    }

    private boolean checkHcPos(long pos) {
        return ((pos | this.maskLower) & this.maskUpper) == pos;
    }

    public Node<T> getCurrentSubNode() {
        return this.nextSubNode;
    }

    public Node<T> node() {
        return this.node;
    }

    void init(long[] rangeMin, long[] rangeMax, long[] valTemplate, Node<T> node, PhFilter checker) {
        long maskHcBit = 1L << node.getPostLen();
        long maskVT = -1L << node.getPostLen();
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (int i = 0; i < valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (valTemplate[i] | maskHcBit) & maskVT;
                if (rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (int i = 0; i < valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        this.reinit(node, rangeMin, rangeMax, lowerLimit, upperLimit, checker);
    }
}

