/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.platform.bukkit;

import java.util.Collection;
import java.util.function.Supplier;
import me.lucko.luckperms.lib.adventure.platform.bukkit.CraftBukkitFacet;
import me.lucko.luckperms.lib.adventure.platform.bukkit.MinecraftReflection;
import me.lucko.luckperms.lib.adventure.platform.bukkit.SpigotFacet;
import me.lucko.luckperms.lib.adventure.platform.facet.Facet;
import me.lucko.luckperms.lib.adventure.platform.facet.FacetComponentFlattener;
import me.lucko.luckperms.lib.adventure.text.flattener.ComponentFlattener;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.json.JSONOptions;
import me.lucko.luckperms.lib.adventure.text.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import me.lucko.luckperms.lib.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.lucko.luckperms.lib.adventure.util.option.OptionState;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public final class BukkitComponentSerializer {
    private static final boolean IS_1_13 = MinecraftReflection.findEnum(Material.class, "BLUE_ICE") != null;
    private static final boolean IS_1_16 = MinecraftReflection.findEnum(Material.class, "NETHERITE_PICKAXE") != null;
    private static final Collection<FacetComponentFlattener.Translator<Server>> TRANSLATORS = Facet.of((Supplier[])new Supplier[]{SpigotFacet.Translator::new, CraftBukkitFacet.Translator::new});
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private static final GsonComponentSerializer GSON_SERIALIZER;
    static final ComponentFlattener FLATTENER;

    private BukkitComponentSerializer() {
    }

    @NotNull
    public static LegacyComponentSerializer legacy() {
        return LEGACY_SERIALIZER;
    }

    @NotNull
    public static GsonComponentSerializer gson() {
        return GSON_SERIALIZER;
    }

    static {
        FLATTENER = FacetComponentFlattener.get((Object)Bukkit.getServer(), TRANSLATORS);
        GSON_SERIALIZER = IS_1_13 ? GsonComponentSerializer.builder().options((OptionState)JSONOptions.byDataVersion().at(Bukkit.getUnsafe().getDataVersion())).build() : GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options((OptionState)JSONOptions.byDataVersion().at(0)).build();
        LEGACY_SERIALIZER = IS_1_16 ? LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().flattener(FLATTENER).build() : LegacyComponentSerializer.builder().character('\u00a7').flattener(FLATTENER).build();
    }
}

