/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.Arrays;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class AddWorldsCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    AddWorldsCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="add-worlds")
    @CommandPermission(value="multiverse.inventories.addworlds")
    @CommandCompletion(value="@worldGroups @mvworlds:multiple,scope=both")
    @Syntax(value="<group> <world[,extra]>")
    @Description(value="Adds a World to a World Group.")
    void onAddWorldCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Group you want to add the world to.") WorldGroup group, @Syntax(value="<world>") @Description(value="World name to add.") MultiverseWorld[] worlds) {
        List<String> worldNames = Arrays.stream(worlds).map(MultiverseWorld::getName).toList();
        String worldNamesString = String.join((CharSequence)", ", worldNames);
        if (!group.getWorlds().addAll(worldNames)) {
            issuer.sendError((MessageKeyProvider)MVInvi18n.ADDWORLD_WORLDALREADYEXISTS, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{world}").with((Object)worldNamesString)});
            return;
        }
        this.worldGroupManager.updateGroup(group);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.ADDWORLD_WORLDADDED, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{world}").with((Object)worldNamesString)});
    }
}

