/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.Map;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.ProfileCacheManager;
import org.mvplugins.multiverse.inventories.utils.benmanes.caffeine.cache.stats.CacheStats;

@Service
final class CacheCommand
extends InventoriesCommand {
    private final ProfileCacheManager ProfileCacheManager;

    @Inject
    CacheCommand(@NotNull ProfileCacheManager ProfileCacheManager2) {
        this.ProfileCacheManager = ProfileCacheManager2;
    }

    @Subcommand(value="cache stats")
    @CommandPermission(value="multiverse.inventories.cache.stats")
    void onCacheStatsCommand(MVCommandIssuer issuer) {
        Map<String, CacheStats> stats = this.ProfileCacheManager.getCacheStats();
        for (Map.Entry<String, CacheStats> entry : stats.entrySet()) {
            issuer.sendMessage("Cache: " + entry.getKey());
            issuer.sendMessage("  hits count: " + entry.getValue().hitCount());
            issuer.sendMessage("  misses count: " + entry.getValue().missCount());
            issuer.sendMessage("  loads count: " + entry.getValue().loadCount());
            issuer.sendMessage("  evictions: " + entry.getValue().evictionCount());
            issuer.sendMessage("  hit rate: " + entry.getValue().hitRate() * 100.0 + "%");
            issuer.sendMessage("  miss rate: " + entry.getValue().missRate() * 100.0 + "%");
            issuer.sendMessage("  avg load penalty: " + entry.getValue().averageLoadPenalty() / 1000000.0 + "ms");
            issuer.sendMessage("--------");
        }
    }

    @Subcommand(value="cache invalidate all")
    @CommandPermission(value="multiverse.inventories.cache.invalidate")
    void onCacheClearAllCommand(MVCommandIssuer issuer) {
        this.ProfileCacheManager.clearAllCache();
    }

    @Subcommand(value="cache invalidate player")
    @CommandPermission(value="multiverse.inventories.cache.invalidate")
    @CommandCompletion(value="@players")
    @Syntax(value="<player>")
    void onCacheClearProfileCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") Player player) {
        this.ProfileCacheManager.clearPlayerProfileCache(key -> key.getPlayerUUID().equals(player.getUniqueId()));
    }
}

