/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Contract;
import org.mvplugins.multiverse.inventories.dataimport.DataImportException;
import org.mvplugins.multiverse.inventories.dataimport.DataImporter;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Contract
public abstract class AbstractDataImporter
implements DataImporter {
    protected Plugin importer = null;

    protected abstract void doDataImport() throws DataImportException;

    @Override
    public boolean importData(boolean disableOnSuccess) {
        if (!this.isEnabled()) {
            InvLogging.severe("Data importer %s not enabled. No data is imported.", this.getPluginName());
            return false;
        }
        try {
            this.doDataImport();
        }
        catch (DataImportException e) {
            InvLogging.severe(e.getMessage(), new Object[0]);
            if (e.getCauseException() != null) {
                InvLogging.severe("Cause: %s", e.getCauseException().getMessage());
            }
            e.printStackTrace();
            return false;
        }
        InvLogging.info("Successfully imported data from %s!", this.getPluginName());
        if (disableOnSuccess) {
            InvLogging.info("Disabling %s...", this.getPluginName());
            Bukkit.getPluginManager().disablePlugin(this.importer);
        }
        return true;
    }

    @Override
    public boolean importData() {
        return this.importData(true);
    }

    @Override
    public boolean enable(Plugin importerPlugin) {
        if (this.isEnabled()) {
            return false;
        }
        if (!importerPlugin.getClass().equals(this.getPluginClass())) {
            InvLogging.warning("Plugin '%s' is not data importer for '%s'.", importerPlugin.getClass().getName(), this.getPluginName());
            return false;
        }
        try {
            this.importer = importerPlugin;
        }
        catch (ClassCastException | NoClassDefFoundError e) {
            InvLogging.warning("Error while enabling data importer for '%s'.", this.getPluginName());
            return false;
        }
        InvLogging.info("Successfully enabled data importer for '%s'.", this.getPluginName());
        return true;
    }

    @Override
    public boolean enable() {
        Plugin importerPlugin = Bukkit.getPluginManager().getPlugin(this.getPluginName());
        if (importerPlugin == null) {
            InvLogging.finer("Unable to get plugin '%s' for import hook.", this.getPluginName());
            return false;
        }
        return this.enable(importerPlugin);
    }

    @Override
    public boolean disable() {
        this.importer = null;
        InvLogging.info("Successfully disabled data importer for '%s'.", this.getPluginName());
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.importer != null;
    }

    @Override
    public Plugin getPlugin() {
        return this.importer;
    }
}

