/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport.perworldinventory;

import java.util.Objects;
import me.ebonjaeger.perworldinventory.PerWorldInventory;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.dataimport.AbstractDataImporter;
import org.mvplugins.multiverse.inventories.dataimport.DataImportException;
import org.mvplugins.multiverse.inventories.dataimport.perworldinventory.PwiImportHelper;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;

@Service
final class PerWorldInventoryImporter
extends AbstractDataImporter {
    private final InventoriesConfig inventoriesConfig;
    private final WorldManager worldManager;
    private final WorldGroupManager worldGroupManager;
    private final ProfileDataSource profileDataSource;

    @Inject
    PerWorldInventoryImporter(@NotNull InventoriesConfig inventoriesConfig, @NotNull WorldManager worldManager, @NotNull WorldGroupManager worldGroupManager, @NotNull ProfileDataSource profileDataSource) {
        this.inventoriesConfig = inventoriesConfig;
        this.worldManager = worldManager;
        this.worldGroupManager = worldGroupManager;
        this.profileDataSource = profileDataSource;
    }

    @Override
    protected void doDataImport() throws DataImportException {
        new PwiImportHelper(Objects.requireNonNull(((PerWorldInventory)this.importer).getApi()), this.inventoriesConfig, this.worldManager, this.worldGroupManager, this.profileDataSource).importData();
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "PerWorldInventory";
    }

    @NotNull
    public Class<PerWorldInventory> getPluginClass() {
        return PerWorldInventory.class;
    }
}

