/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.event.ShareHandlingEvent;
import org.mvplugins.multiverse.inventories.event.WriteOnlyShareHandlingEvent;
import org.mvplugins.multiverse.inventories.handleshare.ShareHandler;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;

public final class WriteOnlyShareHandler
extends ShareHandler {
    private final String worldName;
    private final ProfileType profileType;

    public WriteOnlyShareHandler(MultiverseInventories inventories, Player player) {
        this(inventories, player, player.getWorld().getName(), ProfileTypes.forPlayer(player));
    }

    public WriteOnlyShareHandler(MultiverseInventories inventories, Player player, String worldName, ProfileType profileType) {
        super(inventories, player);
        this.worldName = worldName;
        this.profileType = profileType;
    }

    @Override
    protected void prepareProfiles() {
        Shares sharesToWrite;
        List<WorldGroup> worldGroups = this.worldGroupManager.getGroupsForWorld(this.worldName);
        Shares unhandledShares = Sharables.enabledOf();
        for (WorldGroup worldGroup : worldGroups) {
            this.affectedProfiles.addWriteProfile(worldGroup.getGroupProfileContainer().getProfileKey(this.profileType, (OfflinePlayer)this.player), worldGroup.getApplicableShares());
            unhandledShares.removeAll(worldGroup.getApplicableShares());
        }
        Shares shares = sharesToWrite = this.inventoriesConfig.getAlwaysWriteWorldProfile() ? Sharables.enabled() : unhandledShares;
        if (!sharesToWrite.isEmpty()) {
            this.affectedProfiles.addWriteProfile(this.worldProfileContainerStore.getContainer(this.worldName).getProfileKey(this.profileType, (OfflinePlayer)this.player), sharesToWrite);
        }
    }

    @Override
    protected ShareHandlingEvent createEvent() {
        return new WriteOnlyShareHandlingEvent(this.player, this.affectedProfiles);
    }
}

