/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DiffAlgorithm;
import difflib.Patch;
import difflib.PatchFailedException;
import difflib.myers.MyersDiff;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffUtils {
    private static DiffAlgorithm defaultDiffAlgorithm = new MyersDiff();
    private static Pattern unifiedDiffChunkRe = Pattern.compile("@@\\s+-(?:(\\d+)(?:,(\\d+))?)\\s+\\+(?:(\\d+)(?:,(\\d+))?)\\s+@@");

    public static List<?> patch(List<?> original, Patch patch) throws PatchFailedException {
        return patch.applyTo(original);
    }

    public static Patch parseUnifiedDiff(List<String> diff) {
        boolean inPrelude = true;
        ArrayList<Object[]> rawChunk = new ArrayList<Object[]>();
        Patch patch = new Patch();
        int old_ln = 0;
        int old_n = 0;
        int new_ln = 0;
        int new_n = 0;
        String tag = "";
        String rest = "";
        for (String line : diff) {
            if (inPrelude) {
                if (!line.startsWith("+++")) continue;
                inPrelude = false;
                continue;
            }
            Matcher m = unifiedDiffChunkRe.matcher(line);
            if (m.find()) {
                if (rawChunk.size() != 0) {
                    ArrayList<String> oldChunkLines = new ArrayList<String>();
                    ArrayList<String> newChunkLines = new ArrayList<String>();
                    for (Object[] raw_line : rawChunk) {
                        tag = (String)raw_line[0];
                        rest = (String)raw_line[1];
                        if (tag.equals(" ") || tag.equals("-")) {
                            oldChunkLines.add(rest);
                        }
                        if (!tag.equals(" ") && !tag.equals("+")) continue;
                        newChunkLines.add(rest);
                    }
                    patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, old_n, oldChunkLines), new Chunk(new_ln - 1, new_n, newChunkLines)));
                    rawChunk.clear();
                }
                old_ln = m.group(1) == null ? 1 : Integer.parseInt(m.group(1));
                old_n = m.group(2) == null ? 1 : Integer.parseInt(m.group(2));
                new_ln = m.group(3) == null ? 1 : Integer.parseInt(m.group(3));
                new_n = m.group(4) == null ? 1 : Integer.parseInt(m.group(4));
                old_ln = Integer.parseInt(m.group(1));
                if (old_ln == 0) {
                    ++old_ln;
                }
                if (new_ln != 0) continue;
                ++new_ln;
                continue;
            }
            if (line.length() <= 0) continue;
            tag = line.substring(0, 1);
            rest = line.substring(1);
            if (!tag.equals(" ") && !tag.equals("+") && !tag.equals("-")) continue;
            rawChunk.add(new Object[]{tag, rest});
        }
        if (rawChunk.size() != 0) {
            ArrayList<String> oldChunkLines = new ArrayList<String>();
            ArrayList<String> newChunkLines = new ArrayList<String>();
            for (Object[] raw_line : rawChunk) {
                tag = (String)raw_line[0];
                rest = (String)raw_line[1];
                if (tag.equals(" ") || tag.equals("-")) {
                    oldChunkLines.add(rest);
                }
                if (!tag.equals(" ") && !tag.equals("+")) continue;
                newChunkLines.add(rest);
            }
            patch.addDelta(new ChangeDelta(new Chunk(old_ln - 1, old_n, oldChunkLines), new Chunk(new_ln - 1, new_n, newChunkLines)));
            rawChunk.clear();
        }
        return patch;
    }
}

