/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.lib.ObjectId;

public class PackStatistics {
    private Accumulator statistics;

    public PackStatistics(Accumulator accumulator) {
        this.statistics = accumulator;
    }

    public String getMessage() {
        return MessageFormat.format(JGitText.get().packWriterStatistics, this.statistics.totalObjects, this.statistics.totalDeltas, this.statistics.reusedObjects, this.statistics.reusedDeltas);
    }

    public static class Accumulator {
        public long advertised;
        public long wants;
        public long haves;
        public long notAdvertisedWants;
        public long timeNegotiating;
        public Set<ObjectId> interestingObjects;
        public Set<ObjectId> uninterestingObjects;
        public Set<ObjectId> clientShallowCommits;
        public List<CachedPack> reusedPacks;
        public Set<ObjectId> rootCommits;
        public int depth;
        public int deltaSearchNonEdgeObjects;
        public int deltasFound;
        public long totalObjects;
        public long bitmapIndexMisses;
        public long totalDeltas;
        public long reusedObjects;
        public long reusedDeltas;
        public long totalBytes;
        public long thinPackBytes;
        public long timeCounting;
        public long timeSearchingForReuse;
        public long timeSearchingForSizes;
        public long timeCompressing;
        public long timeWriting;
        public long reachabilityCheckDuration;
        public long treesTraversed;
        public long offloadedPackfiles;
        public long offloadedPackfileSize;
        public ObjectType.Accumulator[] objectTypes = new ObjectType.Accumulator[5];

        public Accumulator() {
            this.objectTypes[1] = new ObjectType.Accumulator();
            this.objectTypes[2] = new ObjectType.Accumulator();
            this.objectTypes[3] = new ObjectType.Accumulator();
            this.objectTypes[4] = new ObjectType.Accumulator();
        }
    }

    public static class ObjectType {

        public static class Accumulator {
            public long cntObjects;
            public long cntDeltas;
            public long reusedObjects;
            public long reusedDeltas;
            public long bytes;
            public long deltaBytes;
        }
    }
}

