/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.FetchRequest;
import org.eclipse.jgit.transport.FilterSpec;

public final class FetchV2Request
extends FetchRequest {
    private final List<ObjectId> peerHas;
    private final List<String> wantedRefs;
    private final boolean doneReceived;
    private final boolean waitForDone;
    private final List<String> serverOptions;
    private final boolean sidebandAll;
    private final List<String> packfileUriProtocols;

    FetchV2Request(List<ObjectId> peerHas, List<String> wantedRefs, Set<ObjectId> wantIds, Set<ObjectId> clientShallowCommits, int deepenSince, List<String> deepenNotRefs, int depth, FilterSpec filterSpec, boolean doneReceived, boolean waitForDone, Set<String> clientCapabilities, String agent, List<String> serverOptions, boolean sidebandAll, List<String> packfileUriProtocols) {
        super(wantIds, depth, clientShallowCommits, filterSpec, clientCapabilities, deepenSince, deepenNotRefs, agent);
        this.peerHas = Objects.requireNonNull(peerHas);
        this.wantedRefs = Objects.requireNonNull(wantedRefs);
        this.doneReceived = doneReceived;
        this.waitForDone = waitForDone;
        this.serverOptions = Objects.requireNonNull(serverOptions);
        this.sidebandAll = sidebandAll;
        this.packfileUriProtocols = packfileUriProtocols;
    }

    List<ObjectId> getPeerHas() {
        return this.peerHas;
    }

    public List<String> getWantedRefs() {
        return this.wantedRefs;
    }

    boolean wasDoneReceived() {
        return this.doneReceived;
    }

    boolean wasWaitForDoneReceived() {
        return this.waitForDone;
    }

    boolean getSidebandAll() {
        return this.sidebandAll;
    }

    List<String> getPackfileUriProtocols() {
        return this.packfileUriProtocols;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        final List<ObjectId> peerHas = new ArrayList<ObjectId>();
        final List<String> wantedRefs = new ArrayList<String>();
        final Set<ObjectId> wantIds = new HashSet<ObjectId>();
        final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        final List<String> deepenNotRefs = new ArrayList<String>();
        final Set<String> clientCapabilities = new HashSet<String>();
        int depth;
        int deepenSince;
        FilterSpec filterSpec = FilterSpec.NO_FILTER;
        boolean doneReceived;
        boolean waitForDone;
        String agent;
        final List<String> serverOptions = new ArrayList<String>();
        boolean sidebandAll;
        final List<String> packfileUriProtocols = new ArrayList<String>();

        private Builder() {
        }

        Builder addPeerHas(ObjectId objectId) {
            this.peerHas.add(objectId);
            return this;
        }

        Builder addWantedRef(String refName) {
            this.wantedRefs.add(refName);
            return this;
        }

        Builder addClientCapability(String clientCapability) {
            this.clientCapabilities.add(clientCapability);
            return this;
        }

        Builder addWantId(ObjectId wantId) {
            this.wantIds.add(wantId);
            return this;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        int getDepth() {
            return this.depth;
        }

        boolean hasDeepenNotRefs() {
            return !this.deepenNotRefs.isEmpty();
        }

        Builder addDeepenNotRef(String deepenNotRef) {
            this.deepenNotRefs.add(deepenNotRef);
            return this;
        }

        Builder setDeepenSince(int value) {
            this.deepenSince = value;
            return this;
        }

        int getDeepenSince() {
            return this.deepenSince;
        }

        Builder setFilterSpec(FilterSpec filter) {
            this.filterSpec = Objects.requireNonNull(filter);
            return this;
        }

        Builder setDoneReceived() {
            this.doneReceived = true;
            return this;
        }

        Builder setWaitForDone() {
            this.waitForDone = true;
            return this;
        }

        Builder setAgent(String agentValue) {
            this.agent = agentValue;
            return this;
        }

        Builder addServerOption(String value) {
            this.serverOptions.add(value);
            return this;
        }

        Builder setSidebandAll(boolean value) {
            this.sidebandAll = value;
            return this;
        }

        Builder addPackfileUriProtocol(String value) {
            this.packfileUriProtocols.add(value);
            return this;
        }

        FetchV2Request build() {
            return new FetchV2Request(this.peerHas, this.wantedRefs, this.wantIds, this.clientShallowCommits, this.deepenSince, this.deepenNotRefs, this.depth, this.filterSpec, this.doneReceived, this.waitForDone, this.clientCapabilities, this.agent, Collections.unmodifiableList(this.serverOptions), this.sidebandAll, Collections.unmodifiableList(this.packfileUriProtocols));
        }
    }
}

