/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public class IO {
    public static final byte[] readFully(File path) throws FileNotFoundException, IOException {
        return IO.readFully(path, Integer.MAX_VALUE);
    }

    public static final byte[] readSome(File path, int limit) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SilentFileInputStream in = new SilentFileInputStream(path);){
            int n;
            byte[] buf = new byte[limit];
            int cnt = 0;
            while ((n = in.read(buf, cnt, buf.length - cnt)) > 0) {
                cnt += n;
            }
            if (cnt == buf.length) {
                return buf;
            }
            byte[] res = new byte[cnt];
            System.arraycopy(buf, 0, res, 0, cnt);
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] readFully(File path, int max) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SilentFileInputStream in = new SilentFileInputStream(path);){
            long sz = Math.max(path.length(), 1L);
            if (sz > (long)max) {
                throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path));
            }
            byte[] buf = new byte[(int)sz];
            int valid = 0;
            while (true) {
                int n;
                if (buf.length == valid) {
                    if (buf.length == max) {
                        int next = in.read();
                        if (next < 0) break;
                        throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path));
                    }
                    byte[] nb = new byte[Math.min(buf.length * 2, max)];
                    System.arraycopy(buf, 0, nb, 0, valid);
                    buf = nb;
                }
                if ((n = in.read(buf, valid, buf.length - valid)) < 0) break;
                valid += n;
            }
            if (valid < buf.length) {
                byte[] nb = new byte[valid];
                System.arraycopy(buf, 0, nb, 0, valid);
                buf = nb;
            }
            return buf;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ByteBuffer readWholeStream(InputStream in, int sizeHint) throws IOException {
        byte[] out = new byte[sizeHint];
        int pos = 0;
        while (pos < out.length) {
            int read = in.read(out, pos, out.length - pos);
            if (read < 0) {
                return ByteBuffer.wrap(out, 0, pos);
            }
            pos += read;
        }
        int last = in.read();
        if (last < 0) {
            return ByteBuffer.wrap(out, 0, pos);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TemporaryBuffer.Heap tmp = new TemporaryBuffer.Heap(Integer.MAX_VALUE);){
            tmp.write(out);
            tmp.write(last);
            tmp.copy(in);
            return ByteBuffer.wrap(tmp.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(dst, off, len);
            if (r <= 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            off += r;
            len -= r;
        }
    }

    public static int readFully(InputStream fd, byte[] dst, int off) throws IOException {
        int r;
        int len = 0;
        while (off < dst.length && (r = fd.read(dst, off, dst.length - off)) >= 0) {
            off += r;
            len += r;
        }
        return len;
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }
}

