/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class JDK14LoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger {
    final transient Logger logger;
    static String SELF = JDK14LoggerAdapter.class.getName();
    static String SUPER = MarkerIgnoringBase.class.getName();

    JDK14LoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(SELF, Level.FINE, msg, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log(SELF, Level.FINE, ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log(SELF, Level.FINE, ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String format, Object ... argArray) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log(SELF, Level.FINE, ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(SELF, Level.FINE, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(SELF, Level.INFO, msg, null);
        }
    }

    public void warn(String msg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(SELF, Level.WARNING, msg, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log(SELF, Level.WARNING, ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String format, Object ... argArray) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log(SELF, Level.WARNING, ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(SELF, Level.WARNING, msg, t);
        }
    }

    public void error(String msg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(SELF, Level.SEVERE, msg, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log(SELF, Level.SEVERE, ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log(SELF, Level.SEVERE, ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(SELF, Level.SEVERE, msg, t);
        }
    }

    private void log(String callerFQCN, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        this.fillCallerData(callerFQCN, record);
        this.logger.log(record);
    }

    private final void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(SUPER)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || className.equals(SUPER)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

