/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.builder;

import com.google.common.base.Joiner;
import java.awt.GraphicsEnvironment;
import joptsimple.OptionSet;
import org.spigotmc.builder.Builder;
import org.spigotmc.builder.JavaVersion;
import org.spigotmc.gui.BuildToolsGui;
import org.spigotmc.utils.Flags;
import org.spigotmc.utils.SwingUtils;
import org.spigotmc.utils.Utils;

public class Bootstrap {
    private static boolean guiEnabled = false;

    public static void main(String[] args) throws Exception {
        OptionSet options = Flags.PARSER.parse(args);
        if ((args.length == 0 && !Utils.isRanFromCommandLine() || options.has(Flags.GUI_FLAG)) && !options.has(Flags.NO_GUI_FLAG)) {
            if (!GraphicsEnvironment.isHeadless()) {
                guiEnabled = true;
                SwingUtils.applyInitialTheme();
                BuildToolsGui gui = new BuildToolsGui();
                gui.setLocationRelativeTo(null);
                gui.setVisible(true);
            } else {
                System.err.println("Headless environment detected, BuildTools GUI unavailable.");
            }
        }
        if (!guiEnabled) {
            long memoryMb;
            JavaVersion javaVersion = JavaVersion.getCurrentVersion();
            if (javaVersion.isUnknown()) {
                System.err.println("*** WARNING *** Unsupported Java detected (" + javaVersion + "). BuildTools has only been tested up to " + JavaVersion.getLatestVersion() + ". Use of development Java versions is not supported.");
                System.err.println("*** WARNING *** You may use java -version to double check your Java version.");
            }
            if ((memoryMb = Runtime.getRuntime().maxMemory() >> 20) < 448L) {
                System.err.println("BuildTools requires at least 512M of memory to run (1024M recommended), but has only detected " + memoryMb + "M.");
                System.err.println("This can often occur if you are running a 32-bit system, or one with low RAM.");
                System.err.println("Please re-run BuildTools with manually specified memory, e.g: java -Xmx1024M -jar BuildTools.jar " + Joiner.on(' ').join(args));
                System.exit(1);
            }
            Builder.logOutput(System.out, System.err);
            Builder.startBuilder(args, options);
        }
    }
}

